%% INITIALIZATION
clear
dbclear all
Config = struct(); %initializes the Configuration structure

%Habituation Protocol
Config.Habituation.Function = false; %All lights are turned on. Experiment doesn't start. Protocol can be stopped with "ESC".
Config.Habituation.TimeLimit = 30; %Habituation time limit (in minutes)
Config.Habituation.LedBrightness = 0.2; %Brightness of bright stimuli (between 0.01 and 1)

%Experiment Configuration
Config.Experiment.Directory = 'C:\Users\julia\OneDrive\Desktop\Dokumente\Work\Betreuen\Original Code'; %data path
Config.Experiment.Subject = 'red1'; %Subject Identification
Config.Experiment.AutoSave = true; %Automatically save generated data
Config.Experiment.ExperimentLimitTrigger = true; %Experiment stops when limit is reached
Config.Experiment.NumTrials = 100; %Experimental trial limit
Config.Experiment.TimeLimit = 30; %Experimental time limit (in minutes)
Config.Experiment.PerfCheck = true; %Automatic Performance Check
Config.Experiment.PerfCheckAfterNumTrial = 2; %Number of complete trials before each performance check
Config.Experiment.MinNumTrials = 3; %Minimum number of trials to complete (on current day!) before automatic level update
Config.Experiment.NumCalculatedTrials = 'all'; %Total number of trials included in the performance check. Type 'all' if all trials should be observed.
Config.Experiment.AutoLoad = true; %Automatically upload previous data. Will update parameters based on STAIRCASE function
Config.Experiment.AutoLoadData = 'latest'; %load 'latest' dataset or an exact dataset

%Staircase Configuration (Training)
Config.Staircase.Function = true; %Staircase function is called at start of experiment and after each performance check
Config.Staircase.StartLevel = 1; %Start level of the experiment, defined in the STAIRCASE function
Config.Staircase.NumLevels = 8; %Total number of training levels in the STAIRCASE function
Config.Staircase.Group = 'group1'; %Group definition for different level update

%Trial Configuration
Config.Trial.FreePellet = true; %Free pellet dispensed before first trial
Config.Trial.MagazineEntry = true; %Confirmation of magazine entry needed before each trial
Config.Trial.ITIType = 'defined'; %ITI design: 'defined','random'
Config.Trial.ITIFixedTime = 5; %Fixed ITI length (in seconds)
Config.Trial.ITIRandomInterval = [0, 2]; %Interval of random ITI length (in seconds). Added to Config.Trial.ITIFixedTime
Config.Trial.RedoPremature = true; %Redo trials with premature responses
Config.Trial.LimitedHold = 5; %Limited Hold length (in seconds)
Config.Trial.PerseverativeTime = 'none'; %Perseverative Time Window (in seconds). Type 'none' if no time window should be defined.
Config.Trial.PerseverativeTimeout = false; %Perseverative response evokes time-out
Config.Trial.Timeout = 5; %Time-out Time Window (in seconds)
Config.Trial.ConsecutiveTimeout = false; %Response during time-out evokes another time-out

%Stimuli Configuration
Config.LED.N = 5; %total number of apertures
Config.LED.StimSequence = 'pseudorandom'; %Stimulus sequence design: 'random','pseudorandom'
Config.LED.StimDuration = 5; %Stimulus duration (in seconds)
Config.LED.StimType = 'single'; %Stimulus design: 'single','neighbour','shifted','all'
Config.LED.NumHighLED = 1; %Number of light stimulus with high brightness
Config.LED.HighLevel = 0.2; %Brightness of bright stimuli (between 0.01 and 1)
Config.LED.NumDimmedLED = 0; %Number of light stimulus with dimmed brightness
Config.LED.DimmedLevel = 0.01; %Brightness of dimmed stimuli (between 0.01 and 1)

%Speaker Configuration
Config.Speaker.LED.System = false; %Speaker sound before LED Stimulus
Config.Speaker.LED.TimeWindow = 200; %Time (in ms) between speaker sound and LED stimulus
Config.Speaker.LED.Duration = 100; %Sound duration (in ms)
Config.Speaker.LED.Volume = 1; %Sound volume (between 0 and 1)
Config.Speaker.Nosepoke.System = false; %Speaker sound following sucessful nosepoke
Config.Speaker.Nosepoke.Duration = 100; %Sound duration (in ms)
Config.Speaker.Nosepoke.Volume = 1; %Sound volume (between 0 and 1)

%Reward Configuration
Config.Reward.System = 'non-binary'; %Reward design: 'binary','non-binary'
Config.Reward.RTDependence = 'non-dependent'; %Reaction Time dependence: 'dependent','non-dependent'
%dependent on reaction time:
Config.Reward.CorrectReactionTimeBins = [0.5, 1, 2; 1, 1, 1; 3, 2, 1]; %Response in bright stimulus: 1st row: ReactionTime bins (in seconds); 2nd: Motor number; 3nd: Pellet number
Config.Reward.HalfCorrectReactionTimeBins = [0.5, 1, 2; 2, 2, 2; 3, 2, 1]; %Response in dimmed stimulus: 1st row: ReactionTime bins (in seconds); 2nd: Motor number; 3nd: Pellet number
%not dependent on reaction time:
Config.Reward.CorrectFeeder = 1; %Motor number for response in bright stimulus
Config.Reward.CorrectNumPellet = 1; %Pellet number following response in bright stimulus
Config.Reward.HalfCorrectFeeder = 2; %Motor number for response in dimmed stimulus
Config.Reward.HalfCorrectNumPellet = 1; %Pellet number following response in dimmed stimulus

s = serialport('COM3', 115200); %Opens the Arduino Port
pause(2); %pauses shortly to ensure connection is ready
[Data, Config, PerformanceCheck] = Code(s, Config); %calls function
clear s %Closes the Arduino Port after experiment