function [Config, trial_count, Config_trigger, UpdateTrigger] = Staircase(Config, PerformanceCheck, trial_count, Config_trigger, group)

switch group
    case 'group1'
        for ii = 1:Config.Staircase.CurrentLevel + 1
            UpdateTrigger = 0; %reinitializes update trigger for all training levels

            if ii == 1 %Training Stage 1
                if (Config_trigger == 2) %trigger so that level 1 always gets used when a new experiment starts
                    UpdateTrigger = 1;
                    Config.LED.StimDuration = 60;
                    Config.Trial.LimitedHold = 60;
                end
            end

            if ii == 2 %Training Stage 2
                if (PerformanceCheck.NumCorrect >= 30) || (Config_trigger == 2) %criteria to next stage
                    UpdateTrigger = 1;
                    Config.LED.StimDuration = 30;
                    Config.Trial.LimitedHold = 30;
                end
            end

            if ii == 3 %Training Stage 3
                if (PerformanceCheck.NumCorrect >= 50) || (Config_trigger == 2)
                    UpdateTrigger = 1;
                    Config.LED.StimDuration = 20;
                    Config.Trial.LimitedHold = 20;
                end
            end

            if ii == 4 %Training Stage 4
                if (PerformanceCheck.NumCorrect >= 50) || (Config_trigger == 2)
                    UpdateTrigger = 1;
                    Config.LED.StimDuration = 10;
                    Config.Trial.LimitedHold = 10;
                end
            end

            if ii == 5 %Training Stage 5
                if ((PerformanceCheck.NumCorrect >= 50) && (PerformanceCheck.Accuracy > 80) && (PerformanceCheck.PercentOmission < 20)) || (Config_trigger == 2)
                    UpdateTrigger = 1;
                    Config.LED.StimDuration = 5;
                    Config.Trial.LimitedHold = 5;
                end
            end

            if ii == 6 %Training Stage 6
                if ((PerformanceCheck.NumCorrect >= 50) && (PerformanceCheck.Accuracy > 80) && (PerformanceCheck.PercentOmission < 20)) || (Config_trigger == 2)
                    UpdateTrigger = 1;
                    Config.LED.StimDuration = 2.5;
                    Config.Trial.LimitedHold = 5;
                end
            end

            if ii == 7 %Training Stage 7
                if ((PerformanceCheck.NumCorrect >= 50) && (PerformanceCheck.Accuracy > 80) && (PerformanceCheck.PercentOmission < 20)) || (Config_trigger == 2)
                    UpdateTrigger = 1;
                    Config.LED.StimDuration = 1.5;
                    Config.Trial.LimitedHold = 5;
                end
            end

            if ii == 8 %Training Stage 8
                if ((PerformanceCheck.NumCorrect >= 50) && (PerformanceCheck.Accuracy > 80) && (PerformanceCheck.PercentOmission < 20)) || (Config_trigger == 2)
                    UpdateTrigger = 1;
                    Config.LED.StimDuration = 1;
                    Config.Trial.LimitedHold = 5;
                end
            end

            if (Config_trigger == 2) && (ii == Config.Staircase.CurrentLevel) %stops loop when it reaches the current level (only for the start of the experiment)
                break;
            end

        end
    case 'group2'
        for ii = 1:Config.Staircase.CurrentLevel + 1
            UpdateTrigger = 0; %reinitializes update trigger for all training levels

            if ii == 1 %Training Stage 1
                if (Config_trigger == 2) %>= 30 %criterion to next stage
                    Config.LED.StimType = 'all'; %Stimuli design: 'single','neighbour','shifted','all'
                    Config.LED.NumHighLED = 5;
                    Config.LED.NumDimmedLED = 0;
                    Config.Speaker.LED.Volume = 1;
                    Config.Speaker.Nosepoke.Volume = 1;
                    UpdateTrigger = 1;
                    Config.LED.StimDuration = 60; %60; %time of visual stimulus in seconds
                    Config.Trial.LimitedHold = 60; %60; %time in seconds to interupt the beam sensor
                end
            end

            if ii == 2 %Training Stage 2
                if (PerformanceCheck.NumCorrect >= 30) || (Config_trigger == 2) %>= 30 %criterion to next stage
                    Config.LED.StimType = 'neighbour'; %Stimuli design: 'single','neighbour','shifted','all'
                    Config.LED.NumHighLED = 3;
                    Config.LED.NumDimmedLED = 2;
                    Config.Speaker.LED.Volume = 0.98;
                    Config.Speaker.Nosepoke.Volume = 0.98;
                    UpdateTrigger = 1;
                    Config.LED.StimDuration = 60; %60; %time of visual stimulus in seconds
                    Config.Trial.LimitedHold = 60; %60; %time in seconds to interupt the beam sensor
                end
            end

            if ii == 3 %Training Stage 3
                if (PerformanceCheck.NumCorrect >= 30) || (Config_trigger == 2) %>= 30 %criterion to next stage
                    Config.LED.StimType = 'shifted'; %Stimuli design: 'single','neighbour','shifted','all'
                    Config.LED.NumHighLED = 1;
                    Config.LED.NumDimmedLED = 4;
                    Config.Speaker.LED.Volume = 0.96;
                    Config.Speaker.Nosepoke.Volume = 0.96;
                    UpdateTrigger = 1;
                    Config.LED.StimDuration = 60; %60; %time of visual stimulus in seconds
                    Config.Trial.LimitedHold = 60; %60; %time in seconds to interupt the beam sensor
                end
            end

            if ii == 4 %Training Stage 4
                if (PerformanceCheck.NumCorrect >= 30) || (Config_trigger == 2) %>= 30 %criterion to next stage
                    Config.LED.StimType = 'shifted'; %Stimuli design: 'single','neighbour','shifted','all'
                    Config.LED.NumHighLED = 1;
                    Config.LED.NumDimmedLED = 2;
                    Config.Speaker.LED.Volume = 0.92;
                    Config.Speaker.Nosepoke.Volume = 0.92;
                    UpdateTrigger = 1;
                    Config.LED.StimDuration = 60; %60; %time of visual stimulus in seconds
                    Config.Trial.LimitedHold = 60; %60; %time in seconds to interupt the beam sensor
                end
            end

            if ii == 5 %Training Stage 5
                if (PerformanceCheck.NumCorrect >= 30) || (Config_trigger == 2) %>= 30 %criterion to next stage
                    Config.LED.StimType = 'single'; %Stimuli design: 'single','neighbour','shifted','all'
                    Config.LED.NumHighLED = 1;
                    Config.LED.NumDimmedLED = 0;
                    Config.Speaker.LED.System = false; %no tone
                    Config.Speaker.Nosepoke.System = false; %no tone
                    UpdateTrigger = 1;
                    Config.LED.StimDuration = 60; %60; %time of visual stimulus in seconds
                    Config.Trial.LimitedHold = 60; %60; %time in seconds to interupt the beam sensor
                end
            end

            if ii == 6 %Training Stage 6
                if (PerformanceCheck.NumCorrect >= 30) || (Config_trigger == 2) %criteria to next stage
                    UpdateTrigger = 1;
                    Config.LED.StimDuration = 30;
                    Config.Trial.LimitedHold = 30;
                end
            end

            if ii == 7 %Training Stage 7
                if (PerformanceCheck.NumCorrect >= 50) || (Config_trigger == 2)
                    UpdateTrigger = 1;
                    Config.LED.StimDuration = 20;
                    Config.Trial.LimitedHold = 20;
                end
            end

            if ii == 8 %Training Stage 8
                if (PerformanceCheck.NumCorrect >= 50) || (Config_trigger == 2)
                    UpdateTrigger = 1;
                    Config.LED.StimDuration = 10;
                    Config.Trial.LimitedHold = 10;
                end
            end

            if ii == 9 %Training Stage 9
                if ((PerformanceCheck.NumCorrect >= 50) && (PerformanceCheck.Accuracy > 80) && (PerformanceCheck.PercentOmission < 20)) || (Config_trigger == 2)
                    UpdateTrigger = 1;
                    Config.LED.StimDuration = 5;
                    Config.Trial.LimitedHold = 5;
                end
            end

            if ii == 10 %Training Stage 10
                if ((PerformanceCheck.NumCorrect >= 50) && (PerformanceCheck.Accuracy > 80) && (PerformanceCheck.PercentOmission < 20)) || (Config_trigger == 2)
                    UpdateTrigger = 1;
                    Config.LED.StimDuration = 2.5;
                    Config.Trial.LimitedHold = 5;
                end
            end

            if ii == 11 %Training Stage 11
                if ((PerformanceCheck.NumCorrect >= 50) && (PerformanceCheck.Accuracy > 80) && (PerformanceCheck.PercentOmission < 20)) || (Config_trigger == 2)
                    UpdateTrigger = 1;
                    Config.LED.StimDuration = 1.5;
                    Config.Trial.LimitedHold = 5;
                end
            end

            if ii == 12 %Training Stage 12
                if ((PerformanceCheck.NumCorrect >= 50) && (PerformanceCheck.Accuracy > 80) && (PerformanceCheck.PercentOmission < 20)) || (Config_trigger == 2)
                    UpdateTrigger = 1;
                    Config.LED.StimDuration = 1;
                    Config.Trial.LimitedHold = 5;
                end
            end

            if (Config_trigger == 2) && (ii == Config.Staircase.CurrentLevel) %stops loop when it reaches the current level (only for the start of the experiment)
                break;
            end

        end
end



if UpdateTrigger == 1 %current level was updated
    trial_count = 0; %not really important. Shows the number of trials needed before the level update
    if Config_trigger == 2
        fprintf('Parameter Update based on last experiment \n') %only when a new session was started
    elseif Config_trigger == 0
        fprintf('Training Level updated \n') %in case it's not a new session
        Config.Staircase.CurrentLevel = Config.Staircase.CurrentLevel + 1; %updates current training level
    end
end