% function
% images is MxNxFrameNum image sequense
function [Cp, Sp] = writeBox(images, dirpath)

if nargin < 2, dirpath = []; end

%load data
if exist([dirpath, 'extRange.mat'], 'file') == 2
    load([dirpath, 'extRange.mat'], 'Sp', 'Cp');
else
    Cp = [];
    Sp = []; 
end

figure('WindowButtonDownFcn', {@xbBDcallback, images, Sp, Cp, dirpath},...
    'WindowButtonUpFcn', '');
colormap('gray');
h = imagesc(images(:, :, 1));

end

function xbBDcallback(src, evt, images, Sp, Cp, dirpath)
Sp_temp = get(gca, 'currentpoint'); %startpoint
Sp_temp = round(Sp_temp(1, :));
h = imagesc(images(:, :,1));
hold on;
for i = 1:size(Sp, 1)
    plot([Sp(i, 1), Sp(i, 1)], [Sp(i, 2), Cp(i, 2)], 'b',  'LineWidth', 2);
    plot([Sp(i, 1), Cp(i, 1)], [Sp(i, 2), Sp(i, 2)], 'b',  'LineWidth', 2);
    plot([Sp(i, 1), Cp(i, 1)], [Cp(i, 2), Cp(i, 2)], 'b',  'LineWidth', 2);
    plot([Cp(i, 1), Cp(i, 1)], [Sp(i, 2), Cp(i, 2)], 'b',  'LineWidth', 2);
end
scatter(Sp_temp(1), Sp_temp(2), 20, 'r', 'fill');
hold off;
set(src,'WindowButtonMotionFcn', {@xbBMcallback, images, Sp, Cp, Sp_temp, dirpath});
end

function xbBMcallback(src, evt, images, Sp, Cp, Sp_temp, dirpath)
Cp_temp = get(gca, 'currentpoint');
Cp_temp = round(Cp_temp(1, :));

% make square
xlen = Cp_temp(1)-Sp_temp(1);
ylen = Cp_temp(2)-Sp_temp(2);
len = min(abs(xlen), abs(ylen));
xlen = sign(xlen)*len;
ylen = sign(ylen)*len;

Cp_temp(1) = Sp_temp(1)+xlen;
Cp_temp(2) = Sp_temp(2)+ylen;

imagesc(images(:, :, 1));
hold on;
%write box
for i = 1:size(Sp, 1)
    plot([Sp(i, 1), Sp(i, 1)], [Sp(i, 2), Cp(i, 2)], 'b',  'LineWidth', 2);
    plot([Sp(i, 1), Cp(i, 1)], [Sp(i, 2), Sp(i, 2)], 'b',  'LineWidth', 2);
    plot([Sp(i, 1), Cp(i, 1)], [Cp(i, 2), Cp(i, 2)], 'b',  'LineWidth', 2);
    plot([Cp(i, 1), Cp(i, 1)], [Sp(i, 2), Cp(i, 2)], 'b',  'LineWidth', 2);
end
plot([Sp_temp(1), Sp_temp(1)], [Sp_temp(2), Cp_temp(2)], 'r',  'LineWidth', 2);
plot([Sp_temp(1), Cp_temp(1)], [Sp_temp(2), Sp_temp(2)], 'r',  'LineWidth', 2);
plot([Sp_temp(1), Cp_temp(1)], [Cp_temp(2), Cp_temp(2)], 'r',  'LineWidth', 2);
plot([Cp_temp(1), Cp_temp(1)], [Sp_temp(2), Cp_temp(2)], 'r',  'LineWidth', 2);
scatter(Cp_temp(1), Cp_temp(2), 20, 'g', 'fill');
hold off; 
set(src, 'WindowButtonUpFcn', {@xbBUcallback, images, [Sp;Sp_temp], [Cp;Cp_temp], dirpath})
end

function xbBUcallback(src, evt, images, Sp, Cp, dirpath)
set(src, 'WindowButtonMotionFcn', '');
set(src, 'KeyPressFcn', {@xbKPcallback, images, Sp, Cp, dirpath});
end

%KeyPress callback function
function xbKPcallback(src, evt, images, Sp, Cp, dirpath)
if strcmp(evt.Key, 's')
    deffilename = [dirpath, '/extRange.mat'];
    %check override
    [filename] = uiputfile('*.mat', 'confirm overwrite', deffilename); 
    if filename ~= 0
        save(filename, 'Sp', 'Cp');
    else
        disp('Didn''t save variables.');
    end
    close(gcf);
elseif strcmp(evt.Key, 'l')
    nframe = size(images, 3);
    for nf = 1:nframe
        imagesc(images(:, :, nf));
        hold on; 
        for i = 1:size(Sp, 1)
            plot([Sp(i, 1), Sp(i, 1)], [Sp(i, 2), Cp(i, 2)], 'b',  'LineWidth', 2);
            plot([Sp(i, 1), Cp(i, 1)], [Sp(i, 2), Sp(i, 2)], 'b',  'LineWidth', 2);
            plot([Sp(i, 1), Cp(i, 1)], [Cp(i, 2), Cp(i, 2)], 'b',  'LineWidth', 2);
            plot([Cp(i, 1), Cp(i, 1)], [Sp(i, 2), Cp(i, 2)], 'b',  'LineWidth', 2);
        end
        hold off;
        
        pause(0.1);
        drawnow;
    end
elseif strcmp(evt.Key, 'c')
    set(src, 'WindowButtonDownFcn', {@xbBDcallback, images, Sp, Cp, dirpath});
elseif strcmp(evt.Key, 'r')
    narea = size(Sp, 1);
    if narea > 2
        Sp = Sp(1:(narea-2), :);
        Cp = Cp(1:(narea-2), :);
    else 
        Sp = [];
        Cp = [];
    end
    set(src, 'WindowButtonDownFcn', {@xbBDcallback, images, Sp, Cp, dirpath});  
elseif strcmp(evt.Key , 'q')
    close(gcf);
end
end