function [MOV] = varI_movie(beadsdata, gb, svflag, fordisplay, filename, charsize)
% [MOV] = varI_catchBeads(beadsdata, gb, svflag, fordisplay, filename)
% difference with 'varI_catchBeads' is to display both of before/after netrin
% images. Then, in this script, beadsdata is 2x1 array of the struct. 

if nargin < 2, gb = 'g'; end
if nargin < 3, svflag = 0; end
if nargin < 4, filename = sprintf('%s.avi', date); end 
if nargin < 5, fordisplay = 0; end
if nargin < 6, charsize = 14;end


if fordisplay
    bsize = 20;
else
    bsize = 100;
end

%extract number
target_num = size(beadsdata(1).GSimages, 3); %num of image
width = size(beadsdata(1).GSimages, 2); %image width
height = size(beadsdata(1).GSimages, 1); %image height

if fordisplay 
    coords0 = beadsdata(1).coords(~beadsdata(1).elilist, :, :);
    coords60 = beadsdata(2).coords(~beadsdata(2).elilist, :, :);
    coords60(:, 1, :) = coords60(:, 1, :) + width; 
    coords = [coords0; coords60];
else 
    coords0 = beadsdata(1).coords;
    coords60 = beadsdata(2).coords;
    coords60(:, 1, :) = coords60(:, 1, :) + width; 
    coords = [coords0; coords60];
end
beadsnum = size(coords, 1); % num of beads

% colormap fo beads
if isfield(beadsdata, 'isin') && isfield(beadsdata, 'elilist') && isfield(beadsdata, 'tume')

    if fordisplay
        cdist0 = [beadsdata(1).tume.*beadsdata(1).isin(:, 1),...    %R
            max(beadsdata(1).isin(:, 1), beadsdata(1).tume),...     %G
            ~beadsdata(1).isin(:, 1)];                                     %B
        cdist0 = cdist0(~beadsdata(1).elilist, :);
        cdist60 = [beadsdata(2).tume.*beadsdata(2).isin(:, 1),...
            max(beadsdata(2).isin(:, 1), beadsdata(2).tume),...
            ~beadsdata(2).isin(:, 1)]; %B
        cdist60 = cdist60(~beadsdata(2).elilist, :);
        cdist = [cdist0; cdist60];
    else
        cdist0 = [beadsdata(1).elilist, beadsdata(1).isin(:, 1)]; %RG
        cdist60 = [beadsdata(2).elilist, beadsdata(2).isin(:, 1)]; %
        cdist = [cdist0; cdist60];
        cdist = [cdist, zeros(beadsnum, 1)]; %B
    end
else
    if fordisplay
        cdist0 = [beadsdata(1).isin(:, 1), beadsdata(1).isin(:, 1), ones(beadsdata(1).beadsnum, 1)]; %RGB
        cdist0 = cdist0(~beadsdata(1).elilist, :);
        cdist60 = [beadsdata(2).isin(:, 1), beadsdata(2).isin(:, 1), ones(beadsdata(2).beadsnum, 1)]; %RGB
        cdist60 = cdist60(~beadsdata(2).elilist, :);
        cdist = [cdist0; cdist60];
    else
        cdist = [(beadsnum:-1:1)'./beadsnum, zeros(beadsnum, 1), (1:beadsnum)'./beadsnum];
    end
end

    

%make edge data
GSedge = edge(beadsdata(1).GSarea);
[y0, x0] = find(GSedge == 1);
GSedge = edge(beadsdata(2).GSarea);
[y60, x60] = find(GSedge == 1);
x60 = x60 + width;
GSedge = edge(beadsdata(1).GSarea .* beadsdata(2).GSarea);
[ym, xm] = find(GSedge == 1); %merge


figure('Position', [1, 1, floor(9.5*width), 5*height]);

%figure; 
colormap('gray');
for i = 1:target_num
    hold off;
    switch gb
        case {'g', 'G'}
            imagesc([beadsdata(1).GSimages(:, :, i), beadsdata(2).GSimages(:, :, i)]);
        case {'e', 'E'}
            imagesc([beadsdata(1).BSimages(:, :, i+1), beadsdata(2).BSimages(:, :, i+1)]);
        case {'c', 'C'}
            img_ = [beadsdata(1).CSimages(:, :, i), beadsdata(2).CSimages(:, :, i)];
            img = zeros(size(img_, 1), size(img_, 2), 3); 
            img(:, :, 2) = img_;   

            image(img./max(img(:)));
            axis equal;
            set(gca, 'Color', [0.5 0.5 0.5]);
        otherwise
            fprintf('invalid character, %s\n', gb);
            MOV = [];
            return
    end
    hold on;    
    if ~fordisplay
        scatter(beadsdata(1).GScenter(1), beadsdata(1).GScenter(2), 10, 'g');
    end
    plot([width, width], [1, height], 'r'); %kyoukaisen
    scatter(x0, y0, 5, 'g', 'filled'); %edge plot
    scatter(x60, y60, 5, 'g', 'filled'); 
    scatter(xm, ym, 5, 'y', 'filled'); 
    scatter(xm+width, ym, 5, 'y', 'filled');         
    
    quiver(coords(:, 1, 1), coords(:, 2, 1), ...
        coords(:, 1, i+1)-coords(:, 1, 1),...
        coords(:, 2, i+1)-coords(:, 2, 1),...
        0, 'r', 'LineWidth', 2);
    scatter(coords(:, 1, i+1)', coords(:, 2, i+1)', bsize,...
        cdist,...
        'filled'); %beads coordinate

    for j = 1:beadsnum
        h = text(coords(j, 1, i+1), coords(j, 2, i+1)-3, sprintf('%d', j),...
            'FontName', 'Times', 'FontSize', charsize);
        set(h, 'HorizontalAlignment', 'Center', 'Color', 'white');
    end     

    pause(0.1);
    drawnow;
    
    %for avi
    if svflag || nargout == 1
        MOV(i) = getframe;
    end
end
if svflag
    movie2avi(MOV, filename);
end