function [MOV] = varI_catchBeads(beadsdata, gb, svflag, filename, fordisplay, varargin)
% [MOV] = varI_catchBeads(beadsdata, gb, svflag, filename, fordisplay)
%
if nargin < 2, gb = 'g'; end
if nargin < 3, svflag = 0; end
if nargin < 4, filename = sprintf('%s.avi', date); end 
if nargin < 5, fordisplay = 0; end

%==========================================================================
%                  setparameter from varargin
%==========================================================================
% edge
edgeext = strcmpi('edge', varargin);
if sum(edgeext) == 1,
    if strcmp('off', varargin{find(edgeext == 1, 1) + 1})
        optedge = 0;
    elseif strcmp('on', varargin{find(edgeext == 1, 1) + 1})
        optedge = 1;
    else 
        optedge = 0;
    end
else 
    optedge = 0;
end

%set for save image
imgsvext = strcmpi('imgfilename', varargin);
imgnum = sum(imgsvext);
imgnumind = find(imgsvext == 1);

%set text size
charsize_def = 14;
fsizeext = strcmpi('FontSize', varargin);
if sum(fsizeext) == 1
    charsize = varargin{find(fsizeext)+1};
    if ~isa(charsize, 'double')
        charsize = charsize_def;
    end
else
    charsize = charsize_def;
end

%display matched beads only
dmext = strcmpi('DisplayMode', varargin);
dmnum = sum(dmext);
if dmnum == 1 && strcmpi('Match', varargin{find(dmext)+1}) && isfield(beadsdata, 'match')
    matchmode = 1;
else
    matchmode = 0;
end
    
%display set GrowthCone direction 
dirext = strcmpi('Direction', varargin);
if sum(dirext) == 1 
    if strcmpi('on', varargin{find(dirext)+1});
        dirmode = 1;
    else
        dirmode = 0;
    end
else
    dirmode = 0;
end

%set beadssize
bsizext = strcmpi('BeadsSize', varargin);
if sum(bsizext) == 1
    if isa(varargin{find(bsizext)+1}, 'double');
        bsize = varargin{find(bsizext)+1};
    else
        if fordisplay
            bsize = 40;
        else
            bsize = 100;
        end
    end
else
    if fordisplay
        bsize = 40;
    else
        bsize = 100;
    end
end

%set mode (movie or image)
modetypeext = strcmpi('ModeType', varargin);
if sum(modetypeext) == 1
    if strcmpi(varargin{find(modetypeext)+1}, 'image')
        imgmode = 1;
    else
        imgmode = 0;
    end
else 
    imgmode = 0;
end

%=========================================================================
%                          pre-processing
%=========================================================================
target_num = size(beadsdata.GSimages, 3); %num of image
if matchmode
    coords = beadsdata.coords(find(beadsdata.match ~= 0), :, :);
    beadsnum = sum(beadsdata.match ~= 0);
elseif fordisplay 
    coords = beadsdata.coords(~beadsdata.elilist, :, :);
    beadsnum = sum(~beadsdata.elilist);
else
    coords = beadsdata.coords;
    beadsnum = size(coords, 1); % num of beads
end

% set beads color
if isfield(beadsdata, 'useprocess') && ~isempty(beadsdata(1).useprocess)
    maxnum = max(beadsdata(1).useprocess);
    cdist = [(beadsdata(1).useprocess)./(maxnum+0.001),... % R (to avoid zero divide)
        beadsdata(1).useprocess./(maxnum+0.001),... % G (the same as above)
        zeros(beadsdata(1).beadsnum, 1)];
elseif isfield(beadsdata, 'isin') && isfield(beadsdata, 'elilist')
    if fordisplay
        %cdist = 'b';
        cdist = [zeros(beadsnum,1), zeros(beadsnum,1), ones(beadsnum,1)];
        %cdist = [zeros(beadsnum,1), beadsdata.isin(~beadsdata.elilist, 1), zeros(beadsnum, 1)];
    else
        cdist = [beadsdata.elilist, beadsdata.isin(:, 1), ones(beadsnum, 1)];
    end
else
    if fordisplay
        cdist = 'b';
    else
        cdist = [(beadsnum:-1:1)'./beadsnum, zeros(beadsnum, 1), (1:beadsnum)'./beadsnum];
    end
end

    

%make edge data
if optedge == 1
    GSedge = edge(beadsdata.GSarea);
    [y, x] = find(GSedge == 1);
end

if gb == 'g' || gb == 'G'
    img = beadsdata.GSimages;
elseif gb == 'c' || gb == 'C'
    img = beadsdata.CSimages;  
else
    img = beadsdata.BSimages(:, :, 2:end);
end
%=========================================================================
%                     process start
%=========================================================================

if imgmode     
    if optedge
        imageMode(img, coords, bsize, charsize, cdist, 'edge', [x, y]);
        return
    else
        imageMode(img, coords, bsize, charsize, cdist);
        return
    end
end

figure; colormap('gray');
for i = 1:target_num
    hold off;
    imagesc(img(:, :, i));
    set(gca, 'YTick', [], 'XTick', []);

    hold on;    

    if optedge == 1,
        scatter(beadsdata.GScenter(1), beadsdata.GScenter(2), 10, 'g');
        scatter(x, y, 5, 'g', 'filled'); %edge plot
    end
    if bsize > 0
    quiver(coords(:, 1, 1), coords(:, 2, 1), ...
        coords(:, 1, i+1)-coords(:, 1, 1),...
        coords(:, 2, i+1)-coords(:, 2, 1),...
        0, 'r', 'LineWidth', 4, 'showarrowhead', 'off');
    scatter(coords(:, 1, i+1)', coords(:, 2, i+1)', bsize, cdist, 'filled'); %beads coordinate
    end
    if charsize > 0 
        for j = 1:beadsnum
            h = text(coords(j, 1, i+1), coords(j, 2, i+1)-3, sprintf('%d', j),...
                'FontName', 'Times', 'FontSize', charsize);
            if gb == 'G' || gb == 'g',
                col = 'black'; 
            else
                col = 'white'; 
            end
            set(h, 'HorizontalAlignment', 'Center', 'Color', col);
        end
    end
    
    if dirmode == 1
        [height, width] = size(beadsdata.GSarea); 
        quiver(0.5*width, 0.5*height,...
            (0.4*width)*cos(beadsdata.deg), (0.4*height)*sin(beadsdata.deg),...
            1, 'lineWidth', 10, 'Color', 'g'); 
    end
    
    pause(0.1);
    drawnow;
    
	%save image
	if i <= length(imgnumind)        
        imgnm = varargin{imgnumind(i)+1};
        disp(imgnm);
        if ~isempty(strfind(imgnum, '.eps'))
            % if save image as eps
            saveas(gcf, imgnm, 'psc2');
        else
            saveas(gcf, imgnm);
        end
    end
    
    %for avi
    if svflag || nargout == 1
        MOV(i) = getframe;
    end
end

if svflag
    movie2avi(MOV, filename);
end
end


function [] = imageMode(img, coords, bsize, fontsize, cdist, varargin)
extedge = strcmpi(varargin, 'edge');
if sum(extedge) == 1
    edgemode = 1;
    ex = varargin{find(extedge)+1}(:, 1);
    ey = varargin{find(extedge)+1}(:, 2);
else
    edgemode = 0;
end

Int_image = 1;

clear imageMode_handle

h = figure; 
colormap('gray');
if edgemode
    set(h, 'KeyPressFcn',...
        @(obj, evt) imageMode_handle(evt, img, coords, bsize, fontsize, cdist, 'edge', [ex, ey]));
else
    set(h, 'KeyPressFcn',...
        @(obj, evt) imageMode_handle(evt, img, coords, bsize, fontsize, cdist));
end
imagesc(img(:, :, Int_image));
hold on;
if bsize > 0
    quiver(coords(:, 1, 1), coords(:, 2, 1), ...
        coords(:, 1, Int_image+1)-coords(:, 1, 1),...
        coords(:, 2, Int_image+1)-coords(:, 2, 1),...
        0, 'r', 'LineWidth', 4, 'showarrowhead', 'off');
    scatter(coords(:, 1, Int_image+1)', coords(:, 2, Int_image+1)', bsize, cdist, 'filled');
end

if edgemode
    scatter(ex, ey, 5, 'g', 'filled');
end

if fontsize > 0
end
title(sprintf('%d', Int_image));
end

function [] = imageMode_handle(evt, img, coords, bsize, fontsize, cdist, varargin)
extedge = strcmpi(varargin, 'edge');
if sum(extedge) == 1
    edgemode = 1;
    ex = varargin{find(extedge)+1}(:, 1);
    ey = varargin{find(extedge)+1}(:, 2);
else
    edgemode = 0;
end

persistent Int_image;
if isempty(Int_image), Int_image = 1; end

if strcmp(evt.Key, 'rightarrow')
    if Int_image < size(img, 3)
        Int_image = Int_image + 1;
    elseif Int_image == size(img, 3)
        Int_image = 1;
    else
        Int_image = mod(Int_image, size(img, 3));
    end
end
if strcmp(evt.Key, 'leftarrow')
    if Int_image > 1
        Int_image = Int_image - 1;
    elseif Int_image == 1
        Int_image = size(img, 3);
    else
        Int_image = mod(Int_image, size(img, 3));
    end
end

%draw
hold off;
imagesc(img(:, :, Int_image));
hold on;
if bsize > 0
    quiver(coords(:, 1, 1), coords(:, 2, 1), ...
        coords(:, 1, Int_image+1)-coords(:, 1, 1),...
        coords(:, 2, Int_image+1)-coords(:, 2, 1),...
        0, 'r', 'LineWidth', 4, 'showarrowhead', 'off');
    scatter(coords(:, 1, Int_image+1)', coords(:, 2, Int_image+1)', bsize, cdist, 'filled');
end

if edgemode
    scatter(ex, ey, 5, 'g', 'fill');
end

if fontsize > 0
end
title(sprintf('%d', Int_image));
end