function [isin] = naibuhantei(coords, GS_area)
maxcsize = size(coords, 1);
isin = zeros(maxcsize, 2);

for bind = 1:maxcsize
    bx = min(ceil(coords(bind, 1, :))):max(floor(coords(bind, 1, :)));
    by = min(ceil(coords(bind, 2, :))):max(floor(coords(bind, 2, :)));
    
    tempimg = zeros(size(GS_area)); % bind-th bead
    tempimg(by, bx) = 1;            % existed area.
    tempimg2 = GS_area + tempimg;
    if sum(tempimg2(:) == 2) > 0
        isin(bind, :) = [1, 1];
    else
        isin(bind, :) = [0, 0];
    end
end