function [beadsdata] = matchingba(beadsdata)
    %matching
    match = [];
    chead0 = squeeze(beadsdata(1).coords(:, :, 1));
    chead60 = squeeze(beadsdata(2).coords(:, :, 1));
    for i = 1:size(chead0, 1)
        disttemp = repmat(chead0(i, :), size(chead60, 1), 1) - chead60;
        dist = sqrt(sum(disttemp.^2, 2));
        mind = find(dist == 0);
        if ~isempty(mind)
            match = [match; i, mind];
        end
    end

    %add matching data
    beadsdata(1).match = zeros(beadsdata(1).beadsnum, 1);
    beadsdata(2).match = zeros(beadsdata(2).beadsnum, 1);
    for i = 1:size(match, 1)
        beadsdata(1).match(match(i, 1)) = i;
        beadsdata(2).match(match(i, 2)) = i;
    end