function [dimage, images, mu1, Fai] = lregbasisfun_120124(image1, h, sparam)
% [dimage, images, mu1, Fai] = lregbasisfun_120124(image1, h, sparam)
% sparam controls sparsity of mu1
if nargin < 3, sparam = 100; end

subrate = 1;
psize = 21; %patchsize : input image divide to improve calculation time
width = size(image1, 2);
height = size(image1, 1);

images = cell(ceil(height./psize), ceil(width./psize));
%mu1 = cell(size(images));
indx = cell(size(images));
indy = cell(size(images));

%make basis functions (gram matrix) with gaussian basis
Fai = zeros(psize^2, ((subrate*psize)^2)+1);
[imgx, imgy] = meshgrid(1:psize);
imgind = [imgy(:), imgx(:)];
for ux = 1:subrate*psize
    for uy = 1:subrate*psize
        u = [uy, ux]./subrate;
        gelem = gaussb(imgind, u, h);
        Fai(:, (ux-1)*psize + uy) = gelem;
    end
end
Fai(:, end) = ones(psize^2, 1);

% partition image to small patchs
mu0 = zeros(size(Fai, 2),1);
fdantzig = @(img) fdantzig_orig(img, Fai, sparam);   
%rmat = randn(90, size(Fai, 1));
%fdantzig = @(img) l1qc_logbarrier(mu0, rmat*Fai, [], rmat*img(:), sparam); 

for i2 = 1:size(images, 2)
    for i1 = 1:size(images, 1)
        if i1 == size(images, 1)
            indy{i1, i2} = (height-psize+1):height;
        else
            indy{i1, i2} = (i1-1)*psize + (1:psize);
        end
        if i2 == size(images, 2)
            indx{i1, i2} = (width-psize+1):width;
        else
            indx{i1, i2} = (i2-1)*psize + (1:psize);
        end
        images{i1, i2} = image1(indy{i1, i2}, indx{i1, i2});
        
        %mu1{i1, i2} = fdantzig(images{i1, i2});
    end
end

%estimate gauss centrals from each patch using dantzig selector
%fdantzig = @(img) l1dantzig_pd(mu0, Fai, [], img(:), 100);   
mu1 = cellfun(fdantzig, images, 'UniformOutput', false);

dimage = zeros(size(image1));
for i = 1:numel(indx)
    dimage(indy{i}, indx{i}) = max(reshape(mu1{i}(1:end-1), psize, psize), dimage(indy{i}, indx{i}));
end
end

function [xhat] = fdantzig_orig(img, Fai, sparam)
if sum(abs(img(:))) == 0,
    xhat = zeros(size(Fai, 2), 1);
else
    xhat = l1dantzig_pd(Fai'*img(:), Fai, [], img(:), sparam);
end
end

function [g] = gaussb(x, u, h)
disxu = sum((x-repmat(u, [size(x, 1), 1])).^2, 2); %distance between x and u 
g = exp(-disxu./(2*h^2));
end
