% function [B, E] = loadImage(dirPath, startN, frame_num, nocelln)
% 
function [B, E, C] = loadImage(dirPath)
RED = 1;
GREEN = 2;
%BLUE = 3;

if exist([dirPath, 'dirpaths.mat'], 'file') == 2, 
    paths = load([dirPath, 'dirpaths.mat']);
    beaddir = paths.beaddir;
    celldir = paths.celldir;
    if nargout == 3
        gcfdir = paths.gcfdir;
    end
    if isfield(paths, 'sdsdir');
        sdsdir = paths.sdsdir;
    end
else
    %select each dir 
    beaddir = uigetdir(dirPath, 'please select beads directory');
    celldir = uigetdir(dirPath, 'please select cell directroy');
    if nargout == 3
        gcfdir = uigetdir(dirPath, 'please select gcf directory');
        save([dirPath, 'dirpaths.mat'], 'beaddir', 'celldir', 'gcfdir');
    else
        save([dirPath, 'dirpaths.mat'], 'beaddir', 'celldir');
    end
end

%get names of image files
imgnameB = dir(sprintf('%s/*.tif', beaddir));
imgnameE = dir(sprintf('%s/*.tif', celldir));
if nargout == 3
    imgnameC = dir(sprintf('%s/*.tif', gcfdir));
end
frame_num = size(imgnameB, 1);

if 1 == exist('sdsdir', 'var') 
    imgs_sds = dir([sdsdir, '/*.tif']);
    B_ori = imread([sdsdir, '/', imgs_sds(1).name]);
else
    kardir = pwd;
    cd(dirPath);
    sdsdir = uigetdir('../', 'please select sds directroy');
    imgs_sds = dir([sdsdir, '/*.tif']);
    B_ori = imread([sdsdir, '/', imgs_sds(1).name]);
    save('dirpaths.mat', 'sdsdir', '-append');
    cd(kardir);
end

height = size(B_ori, 1);
width = size(B_ori, 2);
B = zeros(height, width, frame_num+1);
B(:, :, 1) = B_ori(:, :, RED);
E = zeros(height, width, frame_num);
if nargout == 3
    C = zeros(height, width, frame_num);
end

for i = 1:frame_num
    tempB = imread(sprintf('%s/%s', beaddir, imgnameB(i).name));
    B(:, :, i+1) = tempB(:, :, RED);
    tempE = imread(sprintf('%s/%s', celldir,imgnameE(i).name));
    E(:, :, i) = tempE(:, :, RED);
    if nargout == 3
        tempC = imread(sprintf('%s/%s', gcfdir, imgnameC(i).name));
        C(:, :, i) = tempC(:, :, GREEN);
    end
end