function [tume, mean_abs, isout_mean, isout_std] = detectTume(beadsdata)
%detection effectively moved beads lager than background beads. 
coords = beadsdata.coords;
isin = beadsdata.isin(:, 1);
beadsnum = size(coords, 1);
framenum = size(coords, 3);
mean_abs = zeros(beadsnum, 1);

%
for i = 1:beadsnum
    temp_trans = repmat(coords(i, :, 1), [1, 1, framenum-1]) - coords(i, :, 2:end);
    temp_abs = sqrt(sum(temp_trans.^2));
    mean_abs(i) = mean(temp_abs);
end

%m
isout_mean = mean(mean_abs(~isin));
isout_std = std(mean_abs(~isin));

tume = mean_abs > (isout_mean+isout_std);
