function [beadsdata] = catchBeads_121107(B0, E0, C0, attention, range, deg, th_GSarea, showimg, th_cbeads)
% B0: (target_num + 1) beads images. The first of these is refference image
% E0: (target_num cell) images
% 

if nargin < 4, attention = [217, 333]; end
if nargin < 5, range = 49; end
if nargin < 7, th_GSarea = 2200; end
if nargin < 8, showimg = 0; end
    
indx = attention(1) + (-range:range);
indy = attention(2) + (-range:range);

target_num = size(E0, 3); 
BInum = size(B0, 3);

%check the number of images
if target_num ~= (BInum-1), 
    fprintf('Please make sure of Image numbers such as \n');
    fprintf('size(B0, 3) == size(E0, 3) + 1\n');
end

%pre-processing
for i = 1:BInum
    % ajust contrust 
    MINInt = min(reshape(B0(indy, indx, i), 1, []));
	MAXInt = max(reshape(B0(indy, indx, i), 1, []));
    B0(indy, indx, i) = 255*(B0(indy, indx, i) - MINInt)./(MAXInt - MINInt);
    
    %eliminate noise
    %B0(indy, indx, i) = wiener2(B0(indy, indx, i), [5, 5]);
	B0(indy, indx, i) = medfilt2(B0(indy, indx, i), [3, 3]);
end


%% detect GS area

[GS_area] = detectGSarea(C0, indy, indx, th_GSarea);

%calc center
[yy, xx] = find(GS_area);
jy = mean(yy);
jx = mean(xx);

%% generage row beads data
coords = cell(BInum, 1);
 
parfor i = 1:BInum, 
    [coords{i}] = beadsDetect_coordgen(B0(indy, indx, i), th_cbeads); 
end

%% match pairs
desc = cell(BInum, 1);
for i = 1:BInum
    [desc{i}] = makedesc(B0(indy, indx, i), coords{i});
end

%% beads selection
[mcoords, maxcsize] = matchPair(desc);

%interpolate novel data
[mcoords] = coordsInt(mcoords);

% eliminate jumped beads
elilist = zeros(maxcsize, 1);
th_eli = 1;
for j = 1:maxcsize, 
    %fprintf('%d, x:%f, y:%f, abs:%f\n', j, mean(abs(diff(coords(j, 1, :)))), mean(abs(diff(coords(j, 2, :)))), mean(sqrt(sum(diff(coords(j, 1, :)).^2+diff(coords(j, 2, :)).^2, 2))));
    if mean(sqrt(sum(diff(mcoords(j, 1, :)).^2+diff(mcoords(j, 2, :)).^2, 2))) > th_eli
        elilist(j) =  1;
    end
end

mcoords(logical(elilist), :, :) = [];
maxcsize = size(mcoords, 1);

%% elibeads2
th_eli2 = 0;
bint = zeros(maxcsize, target_num);
%fprintf('maxcsize:%d\n', maxcsize);
for i = 1:target_num
    tempimage = B0(indy, indx, i);
    bindx = round(mcoords(:, 1, i));
    bindx(bindx<=0) = 1;
    bindx(bindx>length(indx)) = length(indx);    
    bindy = round(mcoords(:, 2, i));
    bindy(bindy<=0) = 1;
    bindy(bindy>length(indy)) = length(indy);
    
    for j = 1:maxcsize,
        bint(j, i) = tempimage(bindy(j), bindx(j));
    end
end
elilist = mean(bint, 2) < th_eli2; 

%% naibuhantei
% if a bead is in cell body at least once, the bead is counted as ''in-cell
% beads''.
isin = zeros(maxcsize, 2);
for bind = 1:maxcsize
    bx = min(round(mcoords(bind, 1, :))):max(round(mcoords(bind, 1, :)));
    by = min(round(mcoords(bind, 2, :))):max(round(mcoords(bind, 2, :)));
    
    tempimg = zeros(size(GS_area)); % bind-th bead
    tempimg(by, bx) = 1;            % existed area.
    tempimg2 = GS_area + tempimg;
    if sum(tempimg2(:) == 2) > 0
        isin(bind, :) = [1, 1];
    else
        isin(bind, :) = [0, 0];
    end
end

%% zahyouhennkan
[trans_coords] = trans_coords_fun(mcoords, deg, [jx, jy]);

%% data collection
beadsdata.coords = mcoords;
beadsdata.beadsnum = maxcsize;
beadsdata.GScenter = [jx, jy];
beadsdata.GSarea = GS_area;
beadsdata.GSimages = E0(indy, indx, :);
beadsdata.BSimages = B0(indy, indx, :);
beadsdata.CSimages = C0(indy, indx, :);
beadsdata.isin = isin;
beadsdata.elilist = elilist;
beadsdata.deg = deg;
beadsdata.trans_coords = trans_coords;

%% tume
tume = detectTume(beadsdata);
beadsdata.tume = tume;
%% check data 1
if showimg
    varI_catchBeads2(beadsdata);
end

%% check data 2

if showimg 
    varI_catchBeads(beadsdata);
end