function [coords, imfil] = beadsDetect_coordgen(img, th)
if nargin == 1 || isempty(th)
    th = -20;
end
[hei, wid] = size(img);
%normalize (to 255)
img = 255.*img./max(img(:));

LoGope = fspecial('log', [11, 11], 1.8);
imfil_temp = filter2(LoGope, img);
imfil = (th+1)*ones(hei+2, wid+2);
imfil(2:(end-1), 2:(end-1)) = imfil_temp;

coords = zeros(round(wid*hei/9), 2);
ind_coords = 1;
for x  = 1:wid
    for y = 1:hei
        if imfil(y+1, x+1) <= th
            tempwin = imfil(y+1+(-1:1), x+1+(-1:1));
            lvec = find(min(tempwin(:)) == tempwin(:));
            if sum(lvec == 5) == 1
                [i, j] = ind2sub([3, 3], lvec);
                coords(ind_coords, :) = [x-2+mean(j), y-2+mean(i)];
                ind_coords = ind_coords+1;
            end 
        end
    end
end
coords(coords == 0) = [];
coords = reshape(coords, [], 2);