function [u, upos, fx, fy, c, G] = makeSynData(N, fnum, unum, nlevel)
if nargin < 4, nlevel = inf; end

%set constant
Ym = 0.3*1e3; %Young module
Pr = 0.5;     %Poisson rate

%generate force field
fx = zeros(N);
fy = zeros(N);
fp = zeros(N);

%decide force exsorted point (fnum-points)
inds_temp = randperm(N^2);
fp(inds_temp(1:fnum)) = 1;
[py, px] = find(fp == 1);
%deside convergent point;
cy = mean(py);
cx = mean(px);
c = [cx; cy];
%make force
for i = 1:fnum
    ithf = (rand()*1e3)*(c-[px(i); py(i)]);
    %address force in fx and fy
    fx(py(i), px(i)) = ithf(1);
    fy(py(i), px(i)) = ithf(2);
end
if fnum == 1
    fx(ceil(N/2), ceil(N/2)) = 1e3;
    fy(ceil(N/2), ceil(N/2)) = 1e3;
end

%make Green function
%G = zeros(2*unum, 2*(N^2));
upos = zeros(unum, 2);
indsu_temp = randperm(N^2);
for i = 1:unum
    [upy, upx] = ind2sub([N, N], indsu_temp(i));
    upos(i, :) = [upx, upy];
end
[x, y] = meshgrid(1:N);
fpos = [x(:), y(:)];
G = makeGreal(upos, fpos, Pr, Ym);

%add noise to f
fx1 = fx + sqrt(fx.^2 + fy.^2)./(10^(nlevel/10)).*randn(size(fx)); 
fy1 = fy + sqrt(fx.^2 + fy.^2)./(10^(nlevel/10)).*randn(size(fy)); 
fx = fx1;
fy = fy1;

%generate displacement field
f = [fx(:)'; fy(:)'];
utemptemp = G*f(:);
utemp = reshape(utemptemp', 2, []);
u = utemp';
