function [G] = makeGreal(upos, fpos, nu, Ym)
Nf = size(fpos, 1);
Nu = size(upos, 1);
altzero = 0.1; 

%make design matrix G
G = zeros(2*Nu, 2*Nf);
for indf = 1:Nf
    for indu = 1:Nu
        distfu = upos(indu, :)-fpos(indf, :);
        if distfu(1) == 0 && distfu(2) == 0, distfu = [altzero, altzero]; end
        G((indu-1)*2 +(1:2), (indf-1)*2+(1:2)) = makeG(distfu, nu, Ym);
    end
end

end

function [G] = makeG(x, nu, Ym)
r = norm(x, 2);
sfac = (1+nu)./(pi*Ym*r^3);
G = [(1-nu)*(r^2) + nu*(x(1)^2), nu*x(1)*x(2);...
    nu*x(1)*x(2), (1-nu)*(r^2) + nu*(x(2)^2)];
G = sfac*G;
end