function [G] = makeGreal(upos, fpos, nu, Ym)
Nf = size(fpos, 1);
Nu = size(upos, 1);
altzero_rate = 0.1; 

%make design matrix G
G = zeros(2*Nu, 2*Nf);
%for indf = 1:Nf
    for indu = 1:Nu
        difffu = repmat(upos(indu, :), [size(fpos, 1), 1]) - fpos;
        distfu = sqrt(difffu(:, 1).^2 + difffu(:, 2).^2);
        if sum(distfu == 0)
            %disp('hey')
            minind = find(min(distfu(distfu ~= 0)) == distfu, 1);
            numzero = sum(distfu == 0);
            difffu(find(distfu == 0), :) = altzero_rate*repmat(difffu(minind, :), numzero, 1);
            distfu(distfu == 0) = altzero_rate*min(distfu(distfu ~= 0));
        end
        G((indu-1)*2 +(1:2), :) = makeG(difffu, distfu, nu, Ym);
    end
%end

end

function [G] = makeG(x, r, nu, Ym)
sfac = (1+nu)./(pi*Ym*r.^3);
G11 = (1-nu)*(r.^2) + nu*(x(:, 1).^2);
G21 = nu*x(:, 1).*x(:, 2);
G22 = (1-nu)*(r.^2) + nu*(x(:, 2).^2);
G_tensor = cat(1, ...
    cat(2, permute(sfac.*G11, [3, 2, 1]), permute(sfac.*G21, [3, 2, 1])),...
    cat(2, permute(sfac.*G21, [3, 2, 1]), permute(sfac.*G22, [3, 2, 1])));
G = reshape(G_tensor, 2, []);
end