%estForceSabass
%In original papter paramter lambda determined by L-curve criterion method
%In this function, you can use L-curve criterion by lambda = [];

function [Tx, Ty] = estForceSabass2(upos, u, fpos, Pr, Ym, lambda)
if nargin < 6, lambda =[]; end
G = makeGreal(upos, fpos, Pr, Ym);

if ~isempty(lambda)
    % ridge
    [U, S, V] = svd(G);
    s = diag(S);
    [xhat] = tikhonov(U, s, V, reshape(u', [], 1), lambda);
%    xhat = (1/lambda*G'/(1/lambda*(G*G') + eye(size(G, 1))))*reshape(u', [], 1);
else 
    [xhat] = iLcurve(G, reshape(u', [], 1));
end

xhatt = reshape(xhat, 2, []);
Tx = xhatt(1, :)';
Ty = xhatt(2, :)';
end

function [x, lambda] = iLcurve(G, u)
%determine lambda range
[U, S, V] = svd(G);
singularvales = diag(S);
maxorder = ceil(log10(singularvales(1)));
minorder = floor(log10(singularvales(end)));
ndiv = (maxorder-minorder)*10;
lambdas = logspace(minorder, maxorder, ndiv);

GG = G'*G;
Gu = G'*u;

eta = zeros(ndiv, 1);
rho = zeros(ndiv, 1);
for i = 1:ndiv
    xi = (GG * lambdas(i)*eye(size(G, 2)))\Gu;
    
    eta(i) = norm(xi)^2;
    rho(i) = norm(G*xi-u)^2;
end

% --tempolary--%
x = xi;
lambda = lambdas(1);
% --tempolary--%
end
