%arrows and heatmap
% deadsdata is 1x2 struct has field 'fx'
function [] = drawfig_integral(beadsdata, numgc, gcstt, filesave)
if isfield(beadsdata, 'fx') == 0, 
    disp('Varable ''beadsdata'' dont have field ''fx''.');
    return;
end
if nargin < 3, 
    [hwimg] = size(beadsdata(2, numgc).GSarea);
    gcstt = [hwimg(2)/2, hwimg(1)/2];
end
if nargin < 4, filesave = 0; end

th = 1;
th_grad = -0.5;
vector_proportion = 2;
Nimg = size(beadsdata(1, numgc).GSarea, 1);
clevel = 128; %colormap level;
arrow_width = 5;
arrow_height = 10;
cmap_cool = colormap(cool(clevel));


%directory name
if filesave == 1;
    dirname = sprintf('%sdata/images', datestr(date));
    if ~isdir(dirname), mkdir(dirname); end
end


%==================================================================
%                 arorws netrin off
%==================================================================
figure; 
[y, x] = find(beadsdata(1, numgc).GSarea);
[edy, edx] = find(edge(beadsdata(1, numgc).GSarea) == 1);
fx = sum(beadsdata(1, numgc).fx, 3);
fy = sum(beadsdata(1, numgc).fy, 3);

mags1 = sqrt(fx.^2 + fy.^2);
magimg1 = zeros(Nimg);
magimg1(sub2ind([Nimg, Nimg], y, x)) = mags1;
[gx, gy]= gradient(magimg1);
[gxx, gxy] = gradient(gx);
[gyx, gyy] = gradient(gy);

gxx = permute(gxx(sub2ind([Nimg, Nimg], y, x)), [3, 2, 1]);
gxy = permute(gxy(sub2ind([Nimg, Nimg], y, x)), [3, 2, 1]);
gyx = permute(gyx(sub2ind([Nimg, Nimg], y, x)), [3, 2, 1]);
gyy = permute(gyy(sub2ind([Nimg, Nimg], y, x)), [3, 2, 1]);
hesian = [gxx, gxy; gyx, gyy];
kyokuti = zeros(numel(gxx), 1);
for nump = 1:numel(gxx)
    evals = eig(hesian(:,:,nump));
    kyokuti(nump) = sum(evals);
end
inds = (kyokuti < th_grad) & (mags1>th);
cimage = zeros(Nimg, Nimg, 3);
if 0
    cang = ang;
    cang(cang<0) = cang(cang<0)+2*pi;
    cang = int16((clevel-1)*cang/(2*pi));
    col = repmat( 1./(1+exp(10*(0.2-(mags1./max(mags1))))), 1, 3).*cmaps(cang+1, :);
    
    for nump = 1:length(y) 
        cimage(y(nump), x(nump), :) = col(nump, :);
    end
end
for nump =1:length(edx)
    cimage(edy(nump), edx(nump), :) = [1, 0, 0];
end

imagesc(cimage);
hold on;
%draw grwoth cone orientation
degs = beadsdata(2, numgc).deg;
gcvec = [cos(degs), sin(degs)];
daspect([1 1 1]);
arrow3(gcstt, gcstt+40*gcvec, 'w-3', arrow_width, arrow_height);

%draw arrow
xstt = [x(inds), y(inds)];    
ang = atan2(fy(inds), fx(inds));
xend = xstt + vector_proportion*[cos(ang), cos(ang)]; 
daspect([1 1 1]);
arrow3(xstt, xend, '1.5_w');
hold off;
set(gca, 'Ydir', 'reverse');
set(gca, 'Ylim', [0 Nimg]);
set(gca, 'XTicklabel', [], 'YTicklabel', []);

if filesave == 1
    %eps
    filename = sprintf('%s/arrows_NtrinOFF_cell%d.eps', dirname, numgc);
    saveas(gcf, filename, 'psc2');
    
    %png
    filename = sprintf('%s/arrows_NtrinOFF_cell%d.png', dirname, numgc);
    saveas(gcf, filename);
    
    close(gcf);
end


%============================================================
%                  arrows netrin on
%============================================================
figure;
[y, x] = find(beadsdata(2, numgc).GSarea);
[edy, edx] = find(edge(beadsdata(2, numgc).GSarea) == 1);
fx = sum(beadsdata(2, numgc).fx, 3);
fy = sum(beadsdata(2, numgc).fy, 3);

mags2 = sqrt(fx.^2 + fy.^2);
magimg2 = zeros(Nimg);
magimg2(sub2ind([Nimg, Nimg], y, x)) = mags2;
[gx, gy]= gradient(magimg2);
[gxx, gxy] = gradient(gx);
[gyx, gyy] = gradient(gy);

gxx = permute(gxx(sub2ind([Nimg, Nimg], y, x)), [3, 2, 1]);
gxy = permute(gxy(sub2ind([Nimg, Nimg], y, x)), [3, 2, 1]);
gyx = permute(gyx(sub2ind([Nimg, Nimg], y, x)), [3, 2, 1]);
gyy = permute(gyy(sub2ind([Nimg, Nimg], y, x)), [3, 2, 1]);
hesian = [gxx, gxy; gyx, gyy];
kyokuti = zeros(numel(gxx), 1);
for nump = 1:numel(gxx)
    evals = eig(hesian(:,:,nump));
    kyokuti(nump) = sum(evals);
end

inds = (mags2>th) & kyokuti < th_grad;
%inds = (mags2>th);

cimage = zeros(Nimg, Nimg, 3);
if 0
    ang = atan2(fy, fx);
    cang = ang;
    cang(cang<0) = cang(cang<0)+2*pi;
    cang = int16((clevel-1)*cang/(2*pi));
    col = repmat( 1./(1+exp(10*(0.2-(mags1./max(mags1))))), 1, 3).*cmaps(cang+1, :);
    
    for nump = 1:length(y) 
        cimage(y(nump), x(nump), :) = col(nump, :);
    end
end
for nump =1:length(edx)
    cimage(edy(nump), edx(nump), :) = [1, 0, 0];
end

imagesc(cimage); 
hold on;
%draw grwoth cone orientation
degs = beadsdata(2, numgc).deg;
gcvec = [cos(degs), sin(degs)];
daspect([1 1 1]);
arrow3(gcstt, gcstt+40*gcvec, 'w-3', arrow_width, arrow_height);

%draw force arrow
xstt = [x(inds), y(inds)];
ang = atan2(fy(inds), fx(inds));
xend = xstt + vector_proportion*[cos(ang), sin(ang)]; 
%xend = xstt + vector_proportion*[fx(inds), fy(inds)]; 
hoseiyou = x(inds)./max(x(inds));
xmag = vector_proportion*abs(fx(inds) + 1i*fy(inds));
xmaglevel = ceil(clevel*hoseiyou(ceil(length(hoseiyou)*(xmag./max(xmag)))));
%xmaglevel = ceil(clevel*xmag./max(xmag));
cols = cmap_cool(xmaglevel, :);
set(gca, 'ColorOrder', cols);
%colormap cool;
daspect([1 1 1]);
arrow3(xstt, xend, 'o', 0.85);
hold off;
set(gca, 'Ydir', 'reverse');
set(gca, 'Ylim', [0 Nimg]);
set(gca, 'XTicklabel', [], 'YTicklabel', []);

if filesave == 1
    %eps
    filename = sprintf('%s/arrows_NtrinON_cell%d.eps', dirname, numgc);
    saveas(gcf, filename, 'psc2');
    
    %png
    filename = sprintf('%s/arrows_NtrinON_cell%d.png', dirname, numgc);
    saveas(gcf, filename);
    
    close(gcf);
end

%================================================================
%                  magnitude map netrin on
%================================================================
figure;
ubclim = max([mags1; mags2]);
cmap_jet = colormap(jet(clevel));
magimg2_color = zeros(Nimg, Nimg, 3);
for nump = 1:length(y)
    if mags2 == 0;
       magimg2_color(y(nump), x(nump), :) = 0;
    else
       magimg2_color(y(nump), x(nump), :) = cmap_jet(int8((clevel-1)*mags2(nump)./ubclim)+1, :);
    end
end
imagesc(magimg2_color, [0, ubclim]);
set(gca, 'XTicklabel', [], 'YTicklabel', []);
if filesave == 1
    %eps
    filename = sprintf('%s/hmap_NtrinON_cell%d.eps', dirname, numgc);
    saveas(gcf, filename, 'psc2');
    
    %png
    filename = sprintf('%s/hmap_NtrinON_cell%d.png', dirname, numgc);
    saveas(gcf, filename);
    
    close(gcf);
end

%================================================================
%                  magnitude map netrin off
%================================================================
figure;
magimg1_color = zeros(Nimg, Nimg, 3);
[y, x] = find(beadsdata(1, numgc).GSarea);
for nump = 1:length(y)
    if mags1 == 0;
       magimg1_color(y(nump), x(nump), :) = 0;
    else
       magimg1_color(y(nump), x(nump), :) = cmap_jet(int8((clevel-1)*mags1(nump)./ubclim)+1, :);
    end
end
imagesc(magimg1_color, [0, ubclim]);
set(gca, 'XTicklabel', [], 'YTicklabel', []);

if filesave == 1
    %eps
    filename = sprintf('%s/hmap_NtrinOFF_cell%d.eps', dirname, numgc);
    saveas(gcf, filename, 'psc2');
    
    %png
    filename = sprintf('%s/hmap_NtrinOFF_cell%d.png', dirname, numgc);
    saveas(gcf, filename);
    
    close(gcf);
end

end