%arrows and heatmap
% deadsdata is 1x2 struct has field 'fx'
function [] = drawfig_arrow(beadsdata, gcstt, filesave, filename)
if isfield(beadsdata, 'fx') == 0, 
    disp('Varable ''beadsdata'' dont have field ''fx''.');
    return;
end
if nargin < 2, 
    [hwimg] = size(beadsdata.GSarea);
    gcstt = [hwimg(2)/2, hwimg(1)/2];
end
if nargin < 3, filesave = 0; end
if nargin < 4, filename = 'test'; end

th = 1;
th_grad = -0.5;
vector_proportion = 2;
Nimg = size(beadsdata.GSarea, 1);
clevel = 128; %colormap level;
arrow_width = 5;
arrow_height = 10;
cmap_cool = colormap(cool(clevel));
numframe = size(beadsdata.GSimages, 3);


[y, x] = find(beadsdata.GSarea);
[edy, edx] = find(edge(beadsdata.GSarea) == 1);
sfx = sum(beadsdata.fx, 3);
sfy = sum(beadsdata.fy, 3);
mags = sqrt(sfx.^2 + sfy.^2);
magimg = zeros(Nimg);
magimg(sub2ind([Nimg, Nimg], y, x)) = mags;
[gx, gy]= gradient(magimg);
[gxx, gxy] = gradient(gx);
[gyx, gyy] = gradient(gy);
gxx = permute(gxx(sub2ind([Nimg, Nimg], y, x)), [3, 2, 1]);
gxy = permute(gxy(sub2ind([Nimg, Nimg], y, x)), [3, 2, 1]);
gyx = permute(gyx(sub2ind([Nimg, Nimg], y, x)), [3, 2, 1]);
gyy = permute(gyy(sub2ind([Nimg, Nimg], y, x)), [3, 2, 1]);
hesian = [gxx, gxy; gyx, gyy];
kyokuti = zeros(numel(gxx), 1);
for nump = 1:numel(gxx)
    evals = eig(hesian(:,:,nump));
    kyokuti(nump) = sum(evals);
end
inds = (mags>th) & kyokuti < th_grad;

cimage = zeros(Nimg, Nimg, 3);
for nump =1:length(edx)
    cimage(edy(nump), edx(nump), :) = [1, 0, 0];
end
fx = beadsdata.fx;
fy = beadsdata.fy;
xstt = [x(inds), y(inds)];
xend = cell(numframe, 1);
cols = cell(numframe, 1);

for i = 1:numframe
    ang = atan2(fy(inds, 1, i), fx(inds, :, i));
    xend{i} = xstt + vector_proportion*[cos(ang), sin(ang)]; 
    %xend = xstt + vector_proportion*[fx(inds), fy(inds)]; 
    hoseiyou = x(inds)./max(x(inds));
    xmag = vector_proportion*abs(fx(inds) + 1i*fy(inds));
    xmaglevel = ceil(clevel*hoseiyou(ceil(length(hoseiyou)*(xmag./max(xmag)))));
    %xmaglevel = ceil(clevel*xmag./max(xmag));
    cols{i} = cmap_cool(xmaglevel, :);
end

%draw grwoth cone orientation
degs = beadsdata.deg;
gcvec = [cos(degs), sin(degs)];

figure; 
for nf = 1:numframe
    imagesc(cimage);
    hold on;
    daspect([1 1 1]);
    arrow3(gcstt, gcstt+40*gcvec, 'w-3', arrow_width, arrow_height);

    set(gca, 'ColorOrder', cols{nf});
    daspect([1 1 1]);
    arrow3(xstt, xend{nf}, 'o', 0.85);
    hold off;
    set(gca, 'Ydir', 'reverse');
    set(gca, 'Ylim', [0 Nimg]);
    set(gca, 'XTicklabel', [], 'YTicklabel', []);
    
    
    if filesave == 1
        %eps
        fname = sprintf('%s%02d.eps', filename, nf);
        saveas(gcf, fname, 'psc2');
    
        %png
        fname = sprintf('%s%02d.png', filename, nf);
        saveas(gcf, fname);
    else
        pause(0.1);
        drawnow;
    end
end