function [results] = addforcedata_AP(bdata, Pr, Ym, alpha, beta, unitpixel, selection, gridmode, Nframe)
if nargin < 7, selection = 0; end
if nargin < 8, gridmode = 1; end
if nargin < 9, 
    Nframe = size(bdata.BSimages, 3)-1;
end
Tx = cell(Nframe, 1);
Ty = cell(Nframe, 1);
c = cell(Nframe, 1);
r = cell(Nframe, 1);
errs = cell(Nframe, 1);
if gridmode == 1
    gridwise = 3;
    [hei, wid, Nf] = size(bdata.BSimages);
    [x, y] = meshgrid(1:gridwise:wid, 1:gridwise:hei);
    fpos = [x(:), y(:)];
else
    [y, x] = find(bdata.GSarea == 1);
    fpos = [x(:), y(:)].*unitpixel;
end
if selection == 0
    cod_parfor = bdata.coords(:, :, 2:end);
    cod_ref = bdata.coords(:, :, 1);
elseif selection == 1
    if isfield(bdata, 'useprocess') && ~isempty(bdata.useprocess)
        cod_parfor = bdata.coords(find(bdata.useprocess == 1), :, 2:end);
        cod_ref = bdata.coords(find(bdata.useprocess == 1), :, 1);
    else
        cod_parfor = bdata.coords(find(bdata.isin(:, 1) == 1), :, 2:end);
        cod_ref = bdata.coords(find(bdata.isin(:, 1) == 1), :, 1);
    end
end    


parfor nframe = 1:Nframe
    if isnan(cod_parfor(1, 1, nframe))
        Tx{nframe} = nan*ones(size(fpos, 1), 1);
        Ty{nframe} = nan*ones(size(fpos, 1), 1);
    else
        cod = cod_parfor(:, :, nframe);
        vec = cod - cod_ref;
        G = makeGreal(cod_ref, fpos, Pr, Ym);
        initfx = rand(size(fpos, 1), 1); 
        initfy = rand(size(fpos, 1), 1);
        initr = abs(rand(size(fpos, 1), 1));
        [Tx{nframe}, Ty{nframe}, c{nframe}, r{nframe}, errs{nframe}] =...
            reconstFargP_fpos(vec, G, alpha, beta, fpos, initfx, initfy, initr, 0);
    end
    
end

bdata.fx = real(cell2mat(permute(Tx, [3, 2, 1])));
bdata.fy = real(cell2mat(permute(Ty, [3, 2, 1])));
results.bdata = bdata;
results.c = c;
results.r = r;
results.err = errs;
results.fpos = fpos;