function [bdata, lambdas] = addforcedata_121204(bdata, sigma, Ym, Sabass, lambda, unitpixel, selection)

if nargin < 2, sigma = 0.5; end %Poisson ratio 
if nargin < 3, Ym = 0.3e3; end % Young module 
if nargin < 4, Sabass = 1; end
if nargin < 5, lambda = 0.1; end

if nargin < 7, selection = 0; end

Nframe = size(bdata.GSimages, 3);
Tx = cell(Nframe, 1);
Ty = cell(Nframe, 1);

%bdata = beadsdata(1);
[XI, YI] = meshgrid(1:size(bdata.GSimages, 2), 1:size(bdata.GSimages, 1));
[y, x] = find(bdata.GSarea == 1);
fpos = [x(:), y(:)].*unitpixel;
if selection == 0
    cod_parfor = bdata.coords(:, :, 2:end);
    cod_ref = bdata.coords(:, :, 1);
elseif selection == 1
    if isfield(bdata, 'useprocess') && ~isempty(bdata.useprocess)
        cod_parfor = bdata.coords(find(bdata.useprocess == 1), :, 2:end);
        cod_ref = bdata.coords(find(bdata.useprocess == 1), :, 1);
    else
        cod_parfor = bdata.coords(find(bdata.isin(:, 1) == 1), :, 2:end);
        cod_ref = bdata.coords(find(bdata.isin(:, 1) == 1), :, 1);
    end
end    

if isempty(lambda), lambdas = zeros(Nframe, 1); 
else lambdas = lambda*ones(Nframe, 1);
end


for nframe = 1:Nframe
    if isnan(cod_parfor(1, 1, nframe))
        Tx{nframe} = nan*ones(size(fpos, 1), 1);
        Ty{nframe} = nan*ones(size(fpos, 1), 1);
    else
    cod = cod_parfor(:, :, nframe);
    vec = cod - cod_ref;
    
    if Sabass == 0
        %FTTC
        %make ux, uy by interpolation
        gux = griddata(cod(:, 1), cod(:, 2), vec(:, 1), XI, YI, 'cubic');
        guy = griddata(cod(:, 1), cod(:, 2), vec(:, 2), XI, YI, 'cubic');
        gux(isnan(gux)) = 0;
        guy(isnan(guy)) = 0;
    
        [Tx{nframe}, Ty{nframe}] = estForceFTTC(gux, guy, sigma, Ym); 
    elseif Sabass == 1
        %Sabass
        [Tx{nframe}, Ty{nframe}, lambdas(nframe)] = estForceSabass_121204(cod, vec, fpos, sigma, Ym, lambda);
    elseif Sabass == 2
        [Tx{nframe}, Ty{nframe}] = estForceSabass2(cod, vec, fpos, sigma, Ym, lambda);        
    end
    end
end

bdata.fx = real(cell2mat(permute(Tx, [3, 2, 1])));
bdata.fy = real(cell2mat(permute(Ty, [3, 2, 1])));