function [trans_coords] = trans_coords_fun(coords, deg, center)     
%
beadsnum = size(coords, 1);
rmat = mk_rotmat( deg );
R = [];

trans_coords = zeros(size(coords));
R = zeros(beadsnum*size(rmat));

for k = 1:beadsnum     
    R((k-1)*2+(1:2), (k-1)*2+(1:2)) = rmat;
end

for k = 1:size(coords, 3)
    % heikouidou
    temp_coords = coords(:, :, k) - repmat(center, [beadsnum, 1]);
    % vectorize to apply rotation matrix
    vec_coords = reshape(temp_coords', numel(temp_coords), 1)';
    % rotation
    trans_coords(:, :, k) = reshape(vec_coords*R, 2, [])';
end