function [B, E, C, reg] = traceBeads2(loaddir, reg_init)

%loadImage
if nargout >= 3
    [B0, E, C] = loadImage(loaddir);
    isC = 1;
else 
    [B0, E] = loadImage(loaddir);
    isC = 0;
end
BInum = size(B0, 3);

%% spotdetector
eliedImg = cell (BInum, 1);

parfor i =1:BInum
    [framedata(i), eliedImg{i}] = spotDetector(B0(:, :, i));
end 
%% registration regular image
if nargin < 2, 
    regx = zeros(BInum-1, 1);
    regy = zeros(BInum-1, 1);
else
    regx = reg_init(1)*ones(BInum-1, 1);
    regy = reg_init(2)*ones(BInum-1, 1);
end

deltatra = ones(BInum-1, 2);    
coords_reg = [framedata(1).xCoord(:, 1),framedata(1).yCoord(:, 1)];   
while mean(sqrt(sum((deltatra).^2, 2))) > 0.01     
    %relat_RegImgs = zeros(size(coords_reg, 1)*(length(framedata)-1), 2);
    
    parfor j = 2:BInum      
        coords = [framedata(j).xCoord(:, 1)+regx(j-1) ,framedata(j).yCoord(:, 1)+regy(j-1)];
        relat_RegImgs = zeros(size(coords_reg, 1), 2);

        for i = 1:size(coords_reg, 1);
            temp = repmat(coords_reg(i, :), [size(coords, 1), 1]) - coords;
            dist = sqrt(sum(temp.^2, 2));
            relat_RegImgs(i, :) = temp(find(min(dist)==dist, 1), :); 
        end
        
        deltatra(j-1, :) = [median(relat_RegImgs(:, 1)), median(relat_RegImgs(:, 2))];
    end

    regx = regx + deltatra(:, 1);
    regy = regy + deltatra(:, 2);
    fprintf('error:%f\n', mean(sqrt(sum((deltatra).^2, 2))));
    fprintf('x:%f, y:%f\n', mean(regx), mean(regy));
end

%make images (B, C, E) registrated along to redidual B0 and {B}.
B = B0;
for i = 2:BInum
    %make transform matrix
    T = maketform('affine', [1 0 0; 0 1 0; regx(i-1) regy(i-1) 1]);
    %image registration
    B(:, :, i) = imtransform(B0(:, :, i), T, 'XData', [1 size(B0, 2)], 'YData', [1 size(B0, 1)]);
    if isC == 1;
        C(:, :, i-1) = imtransform(C(:, :, i-1), T, 'XData', [1 size(C, 2)], 'YData', [1 size(C, 1)]);
    end
    E(:, :, i-1) = imtransform(E(:, :, i-1), T, 'XData', [1 size(E, 2)], 'YData', [1 size(E, 1)]);
end
reg = [regx, regy];