function [beadsdata] = revise_data(beadsdata, pair, nums)
% [beadsdata] = revise_data(beadsdata, pair, nums)
% make and add `useprocess` field to beadsdata.
% pair : flag for decision format of nums
% 
% NOTE :pair define at only 1 now
%       please set pair to 1
%
% nums :beads number and the kinds of the each beads 
if pair == 1
    if (~isfield(beadsdata(1), 'match'))
        [beadsdata] = matchingba(beadsdata);
    elseif isempty(beadsdata(1).match)
        [beadsdata] = matchingba(beadsdata);
    end
    if isempty(beadsdata(1).useprocess)
        beadsdata(1).useprocess = zeros(beadsdata(1).beadsnum, 1);
    end
    if isempty(beadsdata(2).useprocess)
        beadsdata(2).useprocess = zeros(beadsdata(2).beadsnum, 1);
    end

    % beads eliminate as useprocess
    for i = 1:size(nums, 2)
        beadsdata(1).useprocess(beadsdata(1).match == nums(1, i)) = nums(2, i);
        beadsdata(2).useprocess(beadsdata(2).match == nums(1, i)) = nums(2, i);
        
        beadsdata(1).useprocess(beadsdata(1).match == 0) = 0;
        beadsdata(2).useprocess(beadsdata(2).match == 0) = 0;
        
    end    
else 
    %only 1 GS version
    if isempty(beadsdata(1).useprocess)
        beadsdata(1).useprocess = zeros(beadsdata(1).beadsnum, 1);    
    end
    for i = 1:size(nums, 2)
        beadsdata(1).useprocess((1:beadsdata(1).beadsnum) == nums(1, i)) = nums(2, i);
    end  
end