

%% load data
clear
addpath ../functions/

LF43 = load('1304107/TFMkatsuS1304107.mat', 'beadsdata');
%LF45 = load('45/LF45beadsdata.mat', 'beadsdata'); 
%LF46 = load('46/LF46beadsdata.mat', 'beadsdata'); 
%LF47 = load('47/LF47beadsdata.mat', 'beadsdata');
%LF48 = load('48/LF48beadsdata.mat', 'beadsdata');
%LF49 = load('49/LF49beadsdata.mat', 'beadsdata'); 
%LF50 = load('50/LF50beadsdata.mat', 'beadsdata'); 
%LF53 = load('53/LF53beadsdata.mat', 'beadsdata'); 
%LF54 = load('54/LF54beadsdata.mat', 'beadsdata'); 
%LF55 = load('55/LF55beadsdata.mat', 'beadsdata'); 
%LF56 = load('56/LF56beadsdata.mat', 'beadsdata'); 
%LF58 = load('58/LF58beadsdata.mat', 'beadsdata'); 
%LF59 = load('59/LF59beadsdata.mat', 'beadsdata'); 
%LF60 = load('60/LF60beadsdata.mat', 'beadsdata'); 
%LF63 = load('63/LF63beadsdata.mat', 'beadsdata'); 


%%

beadsdata = [LF43.beadsdata];
gcnum = size(beadsdata, 2);
agnum = size(beadsdata, 1);

%% selected beads number, 
No1 = [19, 31, 35, 78, 95, 120, 134, 135, 142, 143, 147, 148, 149, 150, 153, 164, 175];
No1 = [No1; ones(size(No1))];
%No2 = [14, 16, 22, 24, 247, 31, 32, 35, 37, 40, 42, 43, 45, 47, 51, 52, 55, 57, 58, 59, ...
    %60, 63, 64, 66, 67, 68, 70, 72, 75, 76, 77, 78, 80, 81, 82, 83, 85, 86, 87, 89, ...
    %90, 91, 94, 95, 96, 97, 99, 100, 101, 102, 105, 106, 109, 110, 111, 112, 114, 115, 116, 117, 118, 119, ...
    %120, 121, 122, 125, 126, 127, 128, 130, 131, 132, 135, 136, 138, 139, ...
    %142, 143, 145, 146, 149, 165, 184]; 
%No2 = [No2; ones(size(No2))];


LFlist = {No1, ...
    %No2, ...
    %No3, No4, No5, No6, No7, No8, No9, No10, ...
    };

%% beads selection
beadsdata(1).match = [];
beadsdata(1).useprocess = [];
for i = 1:length(LFlist)
   if ~isempty(LFlist{i})
       beadsdata(1, i).useprocess = [];
       beadsdata(:, i) = revise_data(beadsdata(:, i), 0, LFlist{i});
   end
end

%% confirm selection process
varI_catchBeads(beadsdata(1), 'g', 0, [], 1);

%% save data
save('S1304107.mat', 'beadsdata');

%% write cvs file
for i = 1:size(beadsdata, 2)
    if ~isempty(beadsdata(1, i).useprocess)
        for j = 1:max(beadsdata(1, i).useprocess)
            %0min
            inds0 = find(beadsdata(1, i).useprocess == j);
            mags0 = repmat(beadsdata(1, i).coords(inds0, :, 1), [1, 1, 50]) - beadsdata(1, i).coords(inds0, :, 2:end);
            mags0 = sqrt(sum(mags0.^2, 2));


            xydata0 = repmat(beadsdata(1, i).coords(inds0, :, 1), [1,1, 50]) - beadsdata(1, i).coords(inds0, :, 2:end);
            temp = reshape(permute(xydata0, [1,3,2]), [], 2);
            angs0 = reshape(atan2(temp(:, 2), temp(:, 1)), [], 50);
            angs0 = angs0*360/(2*pi);
            angs0(angs0<0) = angs0(angs0<0)+360;
            
            
            %write file
            filename = sprintf('S1304107No%02d-%d.csv', i, j);
            csvwrite(filename, [inds0, squeeze(mags0); inds0, angs0]);
        end
    end
end   
%% save movies
dirname = sprintf('./SMovie2/');
if ~isdir(dirname), mkdir(dirname); end
svflag = 1;

for i = 1:gcnum
        %beads
        %filename = sprintf('%s%02dBeads.avi', dirname, i);
        %varI_catchBeads(beadsdata(:, i), 'e', svflag, filename, 1);
        %close(gcf);
        %cell
        filename = sprintf('%s%02d1304107.avi', dirname, i);
        pngfile = sprintf('%s%02d1304107.png', dirname, i);
        %varI_catchBeads(beadsdata(:, i), 'g', svflag, filename, 1, 'FonsSize', 8, 'imgfilename', pngfile);
        varI_catchBeads(beadsdata(:, i), 'g', svflag, filename, 1, 'FontSize', 8);
        close(gcf);
end
