function [desc]  = makedesc(image1, coords)
range  = (-3:3);
wid = size(image1, 2);
hei = size(image1, 1);
desc = zeros(size(coords, 1), length(range)^2 + 2);
for i = 1:size(coords, 1)
    tempdesc = zeros(length(range));
    indy = round(coords(i, 1)) +range; indx = round(coords(i, 2))+range;
    indy = (indy <= hei & indy > 0) .* indy; 
    indx = (indx <= wid & indx > 0) .* indx; 
    indyi = indy; indyi(indyi == 0) = [];
    indxi = indx; indxi(indxi == 0) = [];
    tempdesc(indy ~= 0, indx ~= 0) = image1(indyi, indxi);
    desc(i, :) = [coords(i, :), tempdesc(:)'./255];
end