function [coords] = coordsInt(coords_ori) 
coords = coords_ori;
maxcsize = size(coords, 1);
BInum = size(coords, 3);

% interpolate novel data
for j = 1:maxcsize
    % first
    if (coords(j, 1, 1) == 0)
        k = 1;
        while coords(j, 1, 1+k) == 0 && 1+k < BInum
            k = k+1;
        end
        if 1+k == BInum
            coords(j, :, :) = 0;  
        else
            coords(j, :, 1:k) = repmat(coords(j, :, 1+k), [1, 1, k]);
        end
       
    end
    
    %middle
    for i = 2:(BInum-1)
        %x
        if coords(j, 1, i) == 0
            k = 1;
            while coords(j, 1, i+k) == 0 && i+k < BInum
                k = k+1;
            end
            if (i+k) == BInum
                coords(j, :, i:(i+k)) = repmat(coords(j, :, i-1), [1, 1, k+1]);
            else
                coords(j, :, i:(i+k-1)) = repmat(0.5*(coords(j, :, i-1) + coords(j, :, i+k)), [1, 1, k]);
            end
        end
    end
    
    %last
    if coords(j, 1, end) == 0
        coords(j, :, end) = coords(j, :, end-1);
    end
end

if max(coords == 0)
    disp(find(coords, 0));
end