function [beadsdata] = catchBeads_120202(B0, E0, C0, attention, range, deg, th_GSarea, showimg, sparam)
% B0: (target_num + 1) beads images. The first of these is refference image
% E0: (target_num cell) images
%

if nargin < 4, attention = [217, 333]; end
if nargin < 5, range = 49; end
if nargin < 7, th_GSarea = 2200; end
if nargin < 8, showimg = 0; end
if nargin < 9, sparam = 100; end
    
indx = attention(1) + (-range:range);
indy = attention(2) + (-range:range);

target_num = size(E0, 3); 
BInum = size(B0, 3);

%check the number of images
if target_num ~= (BInum-1), 
    fprintf('Please make sure of Image numbers such as \n');
    fprintf('size(B0, 3) == size(E0, 3) + 1\n');
end

%% detect GS area

[GS_area] = detectGSarea(C0, indy, indx, th_GSarea);

%calc center
[yy, xx] = find(GS_area);
jy = mean(yy);
jx = mean(xx);

%% generage row beads data
dimages = cell(BInum, 1);
mu1 =cell(BInum, 1);
Fai = cell(BInum, 1);
images = cell(BInum, 1);

tic

parfor i = 1:BInum
    [dimages{i}, images{i}, mu1{i}, Fai{i}] = lregbasisfun_120124(B0(indy, indx, i), 1.2, sparam);
end
toc
%% make coords
th = 5;
coords = cell(BInum, 1);
for im = 1:BInum
    ddimage = dimages{im};
    ddimage(dimages{im} < th) = 0;
    ddimage(dimages{im} >= th) = 1;
    [L, numl] = bwlabel(ddimage, 8);
    coords{im} = zeros(numl, 2);
    for i =1:numl, 
        [y, x] = find(L == i);
        coords{im}(i, :) = [mean(x), mean(y)];
    end
end

%% match pairs
desc = cell(BInum, 1);
for i = 1:BInum
    [desc{i}] = makedesc(B0(indy, indx, i), coords{i});
end

%% beads selection
[coords, maxcsize] = matchPair(desc);

%interpolate novel data
[coords] = coordsInt(coords);

% eliminate jumped beads
elilist = zeros(maxcsize, 1);
th_eli = 1;
for j = 1:maxcsize, 
    %fprintf('%d, x:%f, y:%f, abs:%f\n', j, mean(abs(diff(coords(j, 1, :)))), mean(abs(diff(coords(j, 2, :)))), mean(sqrt(sum(diff(coords(j, 1, :)).^2+diff(coords(j, 2, :)).^2, 2))));
    if mean(sqrt(sum(diff(coords(j, 1, :)).^2+diff(coords(j, 2, :)).^2, 2))) > th_eli
        elilist(j) =  1;
    end
end

coords(logical(elilist), :, :) = [];
maxcsize = size(coords, 1);

%% elibeads2
th_eli2 = 0;
bint = zeros(maxcsize, target_num);
%fprintf('maxcsize:%d\n', maxcsize);
for i = 1:target_num
    tempimage = B0(indy, indx, i);
    bindx = round(coords(:, 1, i));
    bindx(bindx<=0) = 1;
    bindx(bindx>length(indx)) = length(indx);    
    bindy = round(coords(:, 2, i));
    bindy(bindy<=0) = 1;
    bindy(bindy>length(indy)) = length(indy);
    
    for j = 1:maxcsize,
        bint(j, i) = tempimage(bindy(j), bindx(j));
    end
end
elilist = mean(bint, 2) < th_eli2; 

%% naibuhantei
% if a bead is in cell body at least once, the bead is counted as ''in-cell
% beads''.
isin = zeros(maxcsize, 2);
for bind = 1:maxcsize
    bx = min(round(coords(bind, 1, :))):max(round(coords(bind, 1, :)));
    by = min(round(coords(bind, 2, :))):max(round(coords(bind, 2, :)));
    
    tempimg = zeros(size(GS_area)); % bind-th bead
    tempimg(by, bx) = 1;            % existed area.
    tempimg2 = GS_area + tempimg;
    if sum(tempimg2(:) == 2) > 0
        isin(bind, :) = [1, 1];
    else
        isin(bind, :) = [0, 0];
    end
end

%% zahyouhennkan
[trans_coords] = trans_coords_fun(coords, deg, [jx, jy]);

%% data collection
beadsdata.coords = coords;
beadsdata.beadsnum = maxcsize;
beadsdata.GScenter = [jx, jy];
beadsdata.GSarea = GS_area;
beadsdata.GSimages = E0(indy, indx, :);
beadsdata.BSimages = B0(indy, indx, :);
beadsdata.CSimages = C0(indy, indx, :);
beadsdata.isin = isin;
beadsdata.elilist = elilist;
beadsdata.deg = deg;
beadsdata.trans_coords = trans_coords;

%% tume
tume = detectTume(beadsdata);
beadsdata.tume = tume;
%% check data 1
if showimg
    varI_catchBeads2(beadsdata);
end

%% check data 2

if showimg 
    varI_catchBeads(beadsdata);
end