function [bdata, lambda_re] = FestProtType(bdata, unitpixel, yModule, Prate, useprocess, lambda)
%load mat data
if nargin <1
    Mat = load('matlab.mat');
    bdata = Mat.beadsdata;
end
if nargin <2, unitpixel = 5/52*1e-6; end %5micro m = 1pixel
numGC = size(bdata, 1);

if nargin <3,
    Ym = 269.42; %189.56;  %Young module
else
    Ym = yModule;
end
if nargin <4, 
    sigma = 0.3; %Poisson ratio
else
    sigma = Prate;
end

%% re-get GSarea using 'useporocess' data
if ~isfield(bdata, 'useprocess')
    bdata.useprocess = ones(bdata.beadsnum, 1);
end
if ~isempty(useprocess),
    bdata.useprocess =  useprocess;
end

se = strel('disk', 1);
    for i = 1:numGC
        if ~isempty(bdata(i).useprocess)
            siz = size(bdata(i).GSarea);
            GSarea_UP = zeros(siz);
            
            inds = sub2ind(siz,...
                round(bdata(i).coords(find(bdata(i).useprocess), 2, :)),... 
                round(bdata(i).coords(find(bdata(i).useprocess), 1, :))... 
                ); 
           
            GSarea_UP(inds) = 1; 
            bdata(i).GSarea = imdilate(GSarea_UP, se);
        end
    end


%% force estimation
Sabass = 1; % processing mode
beadsselection = 1;

% if matlabpool('size') == 0, matlabpool; end
        fprintf('Force Estimation:start\n');
        beadsdata_temp = bdata;
        for i = 1:numGC
            beadsdata_temp(i).fx = [];
            beadsdata_temp(i).fy = [];
            beadsdata_temp(i).coords = beadsdata_temp(i).coords.*unitpixel;
        end
        lambdas = cell(numGC, 1);
            
        for i = 1:numGC   
            if ~isempty(beadsdata_temp(i).coords)
                [beadsdata_temp(i), lambdas{i}] =...
                    addforcedata_121204(beadsdata_temp(i), sigma, Ym,...
                    Sabass, lambda, unitpixel, beadsselection); 
                beadsdata_temp(i).coords = beadsdata_temp(i).coords./unitpixel;
            end
            fprintf('GCNo%d:end\n', i);
        end
        bdata = beadsdata_temp;

%% re-process force estimation using 'selected lambda'
temp = cell2mat(lambdas);
lambda_re = mean(temp);
	fprintf('Force Estimation:restart\n');
	beadsdata_temp = bdata;
	for i = 1:numGC
        beadsdata_temp(i).fx = [];
        beadsdata_temp(i).fy = [];
        beadsdata_temp(i).coords = beadsdata_temp(i).coords.*unitpixel;
    end

	for i = 1:numGC  
        if ~isempty(beadsdata_temp(i).coords)
            [beadsdata_temp(i), lambdas{i}] =...
                addforcedata_121204(beadsdata_temp(i), sigma, Ym,...
                Sabass, lambda_re, unitpixel, beadsselection); 
            beadsdata_temp(i).coords = beadsdata_temp(i).coords./unitpixel;
        end
        fprintf('GCNo%d:end\n', i);
    end
	bdata = beadsdata_temp;  

end