function [MOV, match] = varI_movie2(beadsdata, gb, svflag, fordisplay, filename, varargin)
% [MOV] = varI_catchBeads(beadsdata, gb, svflag, fordisplay, filename)
% difference with 'varI_catchBeads' is to display both of before/after netrin
% images. Then, in this script, beadsdata is 2x1 array of the struct. 
%disp(varargin);
if nargin < 2, gb = 'g'; end
if nargin < 3, svflag = 0; end
if nargin < 4, filename = sprintf('%s.avi', date); end 
if nargin < 5, fordisplay = 0; end
if nargin < 6, charsize = 14;end

if svflag == 0, MOV = []; end 

if fordisplay
    bsize = 20;
else
    bsize = 100;
end
%setparameter from varargin
%
edgeext = strcmpi('edge', varargin);
if sum(edgeext) == 1,
    if strcmp('off', varargin{find(edgeext == 1, 1) + 1})
        optedge = 0;
    elseif strcmp('on', varargin{find(edgeext == 1, 1) + 1})
        optedge = 1;
    else 
        optedge = 0;
    end
else 
    optedge = 0;
end

%set for save image
imgsvext = strcmpi('imgfilename', varargin);
imgnum = sum(imgsvext);
imgnumind = find(imgsvext == 1);
imgnm = cell(imgnum, 1);


%extract number
target_num = size(beadsdata(1).GSimages, 3); %num of image
width = size(beadsdata(1).GSimages, 2); %image width
height = size(beadsdata(1).GSimages, 1); %image height

if ~isfield('beadsdata', 'match')
    [beadsdata] = matchingba(beadsdata);
end

%set text size
charsize_def = 14;
fsizeext = strcmpi('FontSize', varargin);
if sum(fsizeext) == 1
    charsize = varargin{find(fsizeext)+1};
    if ~isa(charsize, 'double')
        charsize = charsize_def;
    end
else
    charsize = charsize_def;
end

if fordisplay 
    coords0 = beadsdata(1).coords(~beadsdata(1).elilist, :, :);
    coords60 = beadsdata(2).coords(~beadsdata(2).elilist, :, :);
    coords60(:, 1, :) = coords60(:, 1, :) + width; 
    coords = [coords0; coords60];
    match0 = beadsdata(1).match(~beadsdata(1).elilist);
    match60 = beadsdata(2).match(~beadsdata(2).elilist);
    match = [match0; match60];
else 
    coords0 = beadsdata(1).coords;
    coords60 = beadsdata(2).coords;
    coords60(:, 1, :) = coords60(:, 1, :) + width; 
    coords = [coords0; coords60];
    match0 = beadsdata(1).match;
    match60 = beadsdata(2).match;
    match = [match0; match60];
end
beadsnum = size(coords, 1); % num of beads

% colormap fo beads
if isfield(beadsdata, 'useprocess') && ~isempty(beadsdata(1).useprocess)
    maxnum = max(beadsdata(1).useprocess);
    cdist0 = [(beadsdata(1).useprocess)./(maxnum+0.001),... % R (to avoid zero divide)
        beadsdata(1).useprocess./(maxnum+0.001),... % G (the same as above)
        zeros(beadsdata(1).beadsnum, 1)];
    cdist60 = [(beadsdata(2).useprocess)./(maxnum+0.001),...
        beadsdata(2).useprocess./(maxnum+0.001),...
        zeros(beadsdata(2).beadsnum, 1)];
    cdist = [cdist0; cdist60];
elseif isfield(beadsdata, 'isin') && isfield(beadsdata, 'elilist') && isfield(beadsdata, 'tume')

    if fordisplay
        cdist0 = [beadsdata(1).tume.*beadsdata(1).isin(:, 1),...    %R
            max(beadsdata(1).isin(:, 1), beadsdata(1).tume),...     %G
            ~beadsdata(1).isin(:, 1)];                                     %B
        cdist0 = cdist0(~beadsdata(1).elilist, :);
        cdist60 = [beadsdata(2).tume.*beadsdata(2).isin(:, 1),...
            max(beadsdata(2).isin(:, 1), beadsdata(2).tume),...
            ~beadsdata(2).isin(:, 1)]; %B
        cdist60 = cdist60(~beadsdata(2).elilist, :);
        cdist = [cdist0; cdist60];
    else
        cdist0 = [beadsdata(1).elilist, beadsdata(1).isin(:, 1)]; %RG
        cdist60 = [beadsdata(2).elilist, beadsdata(2).isin(:, 1)]; %
        cdist = [cdist0; cdist60];
        cdist = [cdist, zeros(beadsnum, 1)]; %B
    end
else
    if fordisplay
        cdist0 = [beadsdata(1).isin(:, 1), beadsdata(1).isin(:, 1), ones(beadsdata(1).beadsnum, 1)]; %RGB
        cdist0 = cdist0(~beadsdata(1).elilist, :);
        cdist60 = [beadsdata(2).isin(:, 1), beadsdata(2).isin(:, 1), ones(beadsdata(2).beadsnum, 1)]; %RGB
        cdist60 = cdist60(~beadsdata(2).elilist, :);
        cdist = [cdist0; cdist60];
    else
        cdist = [(beadsnum:-1:1)'./beadsnum, zeros(beadsnum, 1), (1:beadsnum)'./beadsnum];
    end
end

    

%make edge data
GSedge = edge(beadsdata(1).GSarea);
[y0, x0] = find(GSedge == 1);
GSedge = edge(beadsdata(2).GSarea);
[y60, x60] = find(GSedge == 1);
x60 = x60 + width;
GSedge = edge(beadsdata(1).GSarea .* beadsdata(2).GSarea);
[ym, xm] = find(GSedge == 1); %merge




figure('Position', [1, 1, floor(9.5*width), 5*height]);

%figure; 
colormap('gray');
for i = 1:target_num
    hold off;
    switch gb
        case {'g', 'G'}
            imagesc([beadsdata(1).GSimages(:, :, i), beadsdata(2).GSimages(:, :, i)]);
        case {'e', 'E'}
            imagesc([beadsdata(1).BSimages(:, :, i+1), beadsdata(2).BSimages(:, :, i+1)]);
        case {'c', 'C'}
            img_ = [beadsdata(1).CSimages(:, :, i), beadsdata(2).CSimages(:, :, i)];
            img = zeros(size(img_, 1), size(img_, 2), 3); 
            img(:, :, 2) = img_;   

            image(img./max(img(:)));
            axis equal;
            set(gca, 'Color', [0.5 0.5 0.5]);
        otherwise
            fprintf('invalid character, %s\n', gb);
            MOV = [];
            return
    end
    hold on;    
    if ~fordisplay
        %center point
        scatter(beadsdata(1).GScenter(1), beadsdata(1).GScenter(2), 10, 'g');
    end
    if optedge == 1
        %edge
        scatter(x0, y0, 5, 'g', 'filled'); 
        scatter(x60, y60, 5, 'g', 'filled'); 
        scatter(xm, ym, 5, 'y', 'filled'); 
        scatter(xm+width, ym, 5, 'y', 'filled');         
    end
    
    plot([width, width], [1, height], 'r'); %divid before/after image
    
    quiver(coords(:, 1, 1), coords(:, 2, 1), ...
        coords(:, 1, i+1)-coords(:, 1, 1),...
        coords(:, 2, i+1)-coords(:, 2, 1),...
        0, 'r', 'LineWidth', 2);
    scatter(coords(:, 1, i+1)', coords(:, 2, i+1)', bsize,...
        cdist,...
        'filled'); %beads coordinate
    if charsize > 0
        for j = 1:beadsnum
            if(match(j) ~=0 && charsize > 0)
            h = text(coords(j, 1, i+1), coords(j, 2, i+1)-3, sprintf('%d', match(j)),...
                'FontName', 'Times', 'FontSize', charsize);
            if gb == 'G' || gb == 'g', col = 'black'; else col = 'white'; end 
            set(h, 'HorizontalAlignment', 'Center', 'Color', col);
            end    
        end
    end     

    pause(0.1);
    drawnow;
    
    %save image
	if i <= length(imgnumind)
        
        imgnm = varargin{imgnumind(i)+1};
        disp(imgnm);
        if ~isempty(strfind(imgnum, '.eps'))
            % if save image as eps
            saveas(gcf, imgnm, 'psc2');
        else
            saveas(gcf, imgnm);
        end
    end
    
    %for avi
    if svflag %|| nargout == 1
        MOV(i) = getframe;
    end
end
if svflag
    movie2avi(MOV, filename);
end