function [coords, maxcsize, diss] = matchPair(desc) 
BInum = length(desc);
%% beads selection
csize = cell2mat(cellfun(@(x) size(x, 1), desc, 'UniformOutput', false));
%maxcsize = max(csize);
coords = zeros(csize(1), 2,  BInum);
weight = [1, 1, ones(1, 49)];
regcoord = desc{1};
coords(:, :, 1) = desc{1}(:, 1:2);

for i = 2:BInum
    tempcoords = desc{i};
    diss = zeros(csize(i), csize(1));
    for j = 1:csize(1)
        diss(:, j) = sqrt(sum(repmat(weight, [csize(i), 1]).*(tempcoords - repmat(regcoord(j, :), [csize(i), 1])).^2, 2));
    end
    for j = 1:csize(1)
        kouho_min = find(diss(:, j) == min(diss(:, j)));
        if diss(kouho_min, j) == min(diss(kouho_min, :))
            coords(j, :, i) = tempcoords(kouho_min, 1:2);
        end
    end
end

% eliminate almost 0 point
elilist = zeros(csize(1), 1);
for j = 1:csize(1)
    zeronum = sum(coords(j, 1, :) == 0, 3);
    elilist(j) = ( zeronum./BInum >= .5 ); 
end
coords(find(elilist == 1), :, :) = [];
maxcsize = size(coords, 1);