function [GSareas, resimg, E0] = detectGSarea(E0, indy, indx, th, showflag)
%  [GSarea, resimg] = detectGSarea(E0, indy, indx, th, showflag)
%
% input: E0
%        indy, indx
%        th
%        showflag
% output: GSarea, resimg, images
% example
if nargin < 4, th = 220; end
if nargin < 5, showflag = 0; end

imnum = size(E0, 3);
resimgs = zeros(length(indy), length(indx), imnum);
degs = -45:45:90;
degnum = length(degs);
if showflag
    figure;
end

%contrust up
E0_ori = E0;
funs = fspecial('unsharp');
for im = 1:imnum
    E0(:, :, im) = imfilter(E0_ori(:, :, im), funs, 'replicate');
end

for im = 1:imnum,
    tempimage = zeros(length(indy), length(indx), degnum);
    for i = 1:degnum, 
        se = strel('line', 7, degs(i)); 
        tempimage(:, :, i) = (imdilate(E0(indy, indx, im), se)- imerode(E0(indy, indx, im),se));
    end; 
    
    resimgs(:, :, im) = sum(tempimage, 3);
    if showflag
    for i = 1:degnum
        subplot(3, degnum./2, i);
        imagesc(tempimage(:, :, i));
    end
    subplot(3, degnum./2, [degnum+1 degnum+2]);
    imagesc(resimgs(:, :, im));
    pause(0.1);
    drawnow;
    end
end
resimg = mean(resimgs, 3);

GSareas = resimg;
GSareas(resimg <= th) = 0;
GSareas(resimg > th) = 1;

if showflag
subplot(1, 2, 1);
imagesc(mean(resimgs, 3));
subplot(1, 2, 2);
imagesc(mean(GSareas, 3));
end

%% 
%se = strel('disk', 5, 0);
%for im = 1:imnum
%    GSareas(:, :, im) = imopen(GSareas(:, :, im), se);
%end
%%
% choose GSarea as the region have the maximum area.
for im = 1
    GSareaIM = GSareas;
    labeledimg = bwlabel(GSareaIM);
    labelnum = max(labeledimg(:));
    areasize = zeros(labelnum, 1);
    for i = 1:labelnum
        areasize(i) = sum(labeledimg(:) == i);
    end

    GSareaIM(labeledimg(:) ~= find(areasize == max(areasize))) = 0;
    
    % eliminate isolated point by MM
    loopnum = 50;
    for i = 1:loopnum
        GS_area_new = imclose(GSareaIM, se); 
        errnum = sum(abs(GSareaIM(:)-GS_area_new(:))); 
        %disp(errnum);
        if errnum == 0,
            break
        end; 
        GSareaIM = GS_area_new; 
    end
    GSareas = GSareaIM;
end
