"""electromagnet.py for option 2
see main.py and ReadMe.txt0"""

import RPi.GPIO as GPIO
import concurrent.futures
from datetime import datetime
import time
import csv

show_electromag_movement_logs = True

def configure_cam_and_em_gpio(input_from_camera_pin: int, output_to_camera_pin: int, electro_mag_pin: int, camera_ready_pin: int, pwmHZ: int) -> tuple:
    GPIO.setmode(GPIO.BCM)
    GPIO.setup(electro_mag_pin, GPIO.OUT, initial=GPIO.LOW)
    GPIO.setup(input_from_camera_pin, GPIO.IN)
    GPIO.setup(camera_ready_pin, GPIO.IN)
    GPIO.setup(output_to_camera_pin, GPIO.OUT, initial=GPIO.LOW)
    pwm = GPIO.PWM(electro_mag_pin, pwmHZ) # GPIO 17 for PWM with 50Hz

    return (input_from_camera_pin, output_to_camera_pin, pwm, camera_ready_pin)

def adjust_electro_mag(active_pwm: int, camera_num: int) -> None:
    active_pwm.start(5)
    if show_electromag_movement_logs: print(f"CAMERA {camera_num}: moving electromag up\n")
    for dc in range(0, 90, 5): # Loop 0 to 100 stepping dc by 5 each loop
        active_pwm.ChangeDutyCycle(dc)
        time.sleep(0.05) # wait .05 seconds at current LED brightness
        if show_electromag_movement_logs: print(f"CAMERA {camera_num}: {dc}\n")

    if show_electromag_movement_logs: print(f"CAMERA {camera_num}: moving electromag down\n")
    for dc in range(85, 0, -2): # Loop 95 to 5 stepping dc down by 5 each loop
        active_pwm.ChangeDutyCycle(dc)
        time.sleep(0.05) # wait .05 seconds at current LED brightness
        if show_electromag_movement_logs: print(f"CAMERA {camera_num}: {dc}\n")
    if show_electromag_movement_logs: print(f"CAMERA {camera_num}: done moving electromag\n")

    active_pwm.stop()


def activate_single_camera(total_num_tries: int, input_from_cam_pin: int, output_to_cam_pin:int, pwm: int, camera_ready_pin: int, camera_number: int) -> dict:
    time_since_last_trap = time.perf_counter()
    current_num_of_tries = 0
    particle_is_trapped = False # variable that tracks between iterations whether a particle was trapped or not

    research_log = {
        "camera_number": camera_number,
        "total_log": [],
        "trap_log": [],
        "time_log": []
    }

    print("A 1 means the camera thinks its trapped something and a 0 means no trap.")
    try:
        while current_num_of_tries < total_num_tries:

            #print(f"input_from_cam_pin:{GPIO.input(input_from_cam_pin)}\ncamera_ready_pin:{GPIO.input(camera_ready_pin)}\n")

            GPIO.output(output_to_cam_pin, True) # tell the camera dont search

            if GPIO.input(camera_ready_pin) == 1: # if means camera is not currently searching

                GPIO.output(output_to_cam_pin, False) # tell the camera to start searching
                
                adjust_electro_mag(pwm, camera_number) # attempting to trap
                current_num_of_tries += 1

                particle_was_trapped = 0
                while GPIO.input(camera_ready_pin) == 0: # while the camera has obeyed the order to search
                    
                    if particle_is_trapped == True: # particle was trapped, record the timing
                        if GPIO.input(input_from_cam_pin) == 0:
                            particle_was_trapped = 1
                            particle_is_trapped = False


                    elif particle_is_trapped == False: # if no particle has been trapped, attempt to trap again
                        # check input pin to see if trap was successful
                        if GPIO.input(input_from_cam_pin) == 1:
                            particle_is_trapped = True
                        elif GPIO.input(input_from_cam_pin) == 0:
                            particle_is_trapped = False

                        else:
                            print(f"CAMERA {camera_number}: input pin error\n")

                    else:
                        print(f"CAMERA {camera_number}: camera error, particle_is_trapped var is not True nor False (perhaps not a bool?)\n")

                # logs
                if particle_was_trapped:
                    research_log["total_log"].append(
                        {
                            "TRAP": "YES",
                            "CAMERA_NUMBER": camera_number,
                        }
                    )

                else:
                    research_log["total_log"].append(
                        {
                            "TRAP": "NO",
                            "CAMERA_NUMBER": camera_number,
                        }
                    )

                print(f"CAMERA {camera_number} TRAPPED OR NOT: {particle_was_trapped}\n")
                research_log["trap_log"].append(particle_was_trapped)

                time.sleep(1.5) # after checking the camera's output, wait for 5 seconds before proceeding

    
    except Exception as ex:
        print(f"CAMERA {camera_number}: camera error -> {ex}\n")


    return research_log

def main(number_of_attempts: int=5) -> tuple:

    research_logs = []

    gpio_configs = [
        # camera_input_from_cam_pin, camera_output_to_cam_pin, electro_mag_pin, camera_status_pin pwmHZ
        [19, 17, 23, 5, 50], # camera and mag 1 pins
        #(OPTION 2.1)[26, 27, 24, 6, 50] # camera and mag 2 pins
    ]
    NUMBER_OF_CAMS = len(gpio_configs)

    try:
        with concurrent.futures.ThreadPoolExecutor() as executor:

            results = []
            for camera_num in range(NUMBER_OF_CAMS):
                gpio_config = gpio_configs[camera_num]
                print(f"SETTING UP CAM AND MAG {(camera_num+1)}")
                input_from_cam, output_to_cam, pwm, camera_ready  = configure_cam_and_em_gpio(*gpio_config)
                print(f"FINISHED {(camera_num+1)}\n")

                results.append(executor.submit(activate_single_camera, number_of_attempts, input_from_cam, output_to_cam, pwm, camera_ready, camera_num))

            for f in concurrent.futures.as_completed(results):
                camera_result = f.result()
                research_logs.append(camera_result)
                print(camera_result)

    except Exception as ex:
        print(ex)
        raise(ex)

    finally:
        # SHUT OFF THE PWMs, CLEAR OFF THE GPIO PINS
        # for config in gpio_configs:
        #     pwm_to_shutoff = config[3]
        #     try:
        #         pwm_to_shutoff.stop()
        #     except Exception as ex:
        #         camera_num = config[-1]
        #         print(f"Unable to shut off camera {camera_num} due to error -> {ex}\n")
        try:
            GPIO.cleanup()
            print("FINISHED GPIO CLEANUP AND TRAP DATA LOGGING")
        except Exception as ex:
            print(f"GPIO doesn't need to be cleaned up, IO pins were not used. Error: {ex}")

        # BACK UP ALL THE DATA TO A CSV AND SAVE TO LOCAL DIR
        try:
            back_up_logs = [(b_u_l.get("camera_number"), b_u_l.get("total_log")) for b_u_l in research_logs]
            fieldnames = back_up_logs[0][1][0].keys() if back_up_logs else ["NO_DATA"]
            dt_string = datetime.now().strftime("%d/%m/%Y %H:%M:%S")
            with open(f"{dt_string}-BACK-UP-LOG-{number_of_attempts}-ATTEMPTS.txt", "w", newline="") as write_file:
                csv_writer = csv.DictWriter(write_file, fieldnames=fieldnames)
                csv_writer.writeheader()
                for row in back_up_logs:
                    csv_writer.writerow(row)
        except Exception as ex:
            print(f"Unable to back up data to local CSV due to error: {ex}")

    try:
        trap_log_a= research_logs[0]["trap_log"] #(OPTION 2.0)
        #(OPTION 2.1)trap_log_a, trap_log_b = research_logs[0]["trap_log"], research_logs[1]["trap_log"]

            
        return trap_log_a #(OPTION 2.0)
        #(OPTION 2.1)return trap_log_a, trap_log_b


    except:
        trap_log_a = research_logs[0]["trap_log"]

        return trap_log_a
