#           ###READ ME###
# this file is the simple run code for the miniature trapping rig.
#the only variable to change is the num_tries variable found towards the end of the code.
# once you have entered your desired number you can start the program
# also in the function trap_e_m you can change the dc(duty cycle range) if you desire.
# the duty cycle range must stay between 0 and 100.
# feel free to decrease or increase the time.sleep commands throughout the code.


import RPi.GPIO as GPIO
import time
import sys

delay_time = 4 # In seconds, this is a float, so decimals can be used


em_pin_1 = 23

GPIO.setmode(GPIO.BCM)
GPIO.setup(em_pin_1, GPIO.OUT)

pwm = GPIO.PWM(em_pin_1, 50) # GPIO 17 for PWM with 50Hz


def trap():
    
    p.ChangeDutyCycle(12.5)
    time.sleep(1)
    p.ChangeDutyCycle(7.5)
    time.sleep(1)
    
    
def trap_e_m():
    dc=0                               # set dc variable to 0 for 0%
    pwm.start(5)   #(dc) //ALTERED
   
    for dc in range(0, 90, 5):    # Loop 0 to 100 stepping dc by 5 each loop
        pwm.ChangeDutyCycle(dc)
        time.sleep(0.05)             # wait .05 seconds at current LED brightness
        print(dc)
    for dc in range(85, 0, -2):    # Loop 95 to 5 stepping dc down by 5 each loop //ALTERED from -5
        pwm.ChangeDutyCycle(dc)
        time.sleep(0.05)             # wait .05 seconds at current LED brightness //ALTERED from .05
        print(dc)
      

    pwm.stop()      

def run_tests(num_tries):
    tries = 0
    while tries < num_tries:
        trap_e_m()
        tries += 1
        #time.sleep(delay_time)
              
    return tries


try:
    run_tests(25)
finally:
    #
    pwm.stop()
    GPIO.cleanup()


