/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.xml.parsers.ParserConfigurationException;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.MissingLibraryException;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import loci.formats.services.OMEXMLServiceImpl;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.xml.model.primitives.PositiveInteger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OBFReader
extends FormatReader {
    private static final boolean LITTLE_ENDIAN = true;
    private static final String FILE_MAGIC_STRING = "OMAS_BF\n";
    private static final String STACK_MAGIC_STRING = "OMAS_BF_STACK\n";
    private static final short MAGIC_NUMBER = -1;
    private static final int MAXIMAL_NUMBER_OF_DIMENSIONS = 15;
    private int file_version = -1;
    private transient OMEXMLMetadata ome_meta_data;
    private List<Stack> stacks = new ArrayList<Stack>();
    private Frame currentInflatedFrame = new Frame();
    private transient Inflater inflater;

    public OBFReader() {
        super("OBF", new String[]{"obf", "msr"});
        this.suffixNecessary = false;
        this.suffixSufficient = false;
        this.datasetDescription = "OBF file";
    }

    private int getFileVersion(RandomAccessInputStream stream) throws IOException {
        stream.seek(0L);
        stream.order(true);
        try {
            String magicString = stream.readString(FILE_MAGIC_STRING.length());
            short magicNumber = stream.readShort();
            int version = stream.readInt();
            if (magicString.equals(FILE_MAGIC_STRING) && magicNumber == -1) {
                return version;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return -1;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return this.getFileVersion(stream) >= 0;
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.currentInflatedFrame.series = -1;
        this.currentInflatedFrame.number = -1;
        this.in = new RandomAccessInputStream(id);
        this.file_version = this.getFileVersion(this.in);
        long stackPosition = this.in.readLong();
        int lengthOfDescription = this.in.readInt();
        String description = this.in.readString(lengthOfDescription);
        this.metadata.put("Description", description);
        if (this.file_version >= 2) {
            long meta_data_position = this.in.readLong();
            long current_position = this.in.getFilePointer();
            this.in.seek(meta_data_position);
            String key = this.readString();
            while (key.length() > 0) {
                if (key.equals("ome_xml")) {
                    String ome_xml = this.readString();
                    try {
                        ServiceFactory factory = new ServiceFactory();
                        OMEXMLService service = factory.getInstance(OMEXMLService.class);
                        if (!service.validateOMEXML(ome_xml)) break;
                        this.ome_meta_data = service.createOMEXMLMetadata(ome_xml);
                        for (int image = 0; image != this.ome_meta_data.getImageCount(); ++image) {
                            if (this.ome_meta_data.getPixelsBigEndian(image) == null) {
                                this.ome_meta_data.setPixelsBigEndian(Boolean.FALSE, image);
                            }
                            int channels = this.ome_meta_data.getChannelCount(image);
                            for (int channel = 0; channel != channels; ++channel) {
                                if (this.ome_meta_data.getChannelSamplesPerPixel(image, channel) != null) continue;
                                this.ome_meta_data.setChannelSamplesPerPixel(new PositiveInteger(1), image, channel);
                            }
                        }
                        service.convertMetadata(this.ome_meta_data, this.metadataStore);
                        OMEXMLMetadata reference = service.getOMEMetadata(service.asRetrieve(this.metadataStore));
                        for (int image = 0; image != this.ome_meta_data.getImageCount(); ++image) {
                            service.addMetadataOnly(reference, image);
                        }
                        break;
                    }
                    catch (DependencyException exception) {
                        throw new MissingLibraryException(OMEXMLServiceImpl.NO_OME_XML_MSG, exception);
                    }
                    catch (ServiceException exception) {
                        throw new FormatException(exception);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Could not parse OME-XML metadata", e);
                        break;
                    }
                }
                this.addGlobalMeta(key, this.readString());
                key = this.readString();
            }
            this.in.seek(current_position);
        }
        if (stackPosition != 0L) {
            this.core.clear();
            while ((stackPosition = this.initStack(stackPosition)) != 0L) {
            }
        }
        if (this.ome_meta_data == null) {
            MetadataTools.populatePixels(this.metadataStore, this);
            for (int image = 0; image != this.core.size(); ++image) {
                Length physicalSizeZ;
                CoreMetadata meta_data = (CoreMetadata)this.core.get(image);
                String name = meta_data.seriesMetadata.get("Name").toString();
                this.metadataStore.setImageName(name, image);
                List lengths = (List)meta_data.seriesMetadata.get("Lengths");
                if (lengths.size() > 0) {
                    Length physicalSizeX;
                    double lengthX = Math.abs((Double)lengths.get(0));
                    if (lengthX < 0.01) {
                        lengthX *= 1000000.0;
                    }
                    if (lengthX > 0.0 && (physicalSizeX = FormatTools.getPhysicalSizeX((Double)(lengthX / (double)meta_data.sizeX), UNITS.MICROMETER)) != null) {
                        this.metadataStore.setPixelsPhysicalSizeX(physicalSizeX, image);
                    }
                }
                if (lengths.size() > 1) {
                    Length physicalSizeY;
                    double lengthY = Math.abs((Double)lengths.get(1));
                    if (lengthY < 0.01) {
                        lengthY *= 1000000.0;
                    }
                    if (lengthY > 0.0 && (physicalSizeY = FormatTools.getPhysicalSizeY((Double)(lengthY / (double)meta_data.sizeY), UNITS.MICROMETER)) != null) {
                        this.metadataStore.setPixelsPhysicalSizeY(physicalSizeY, image);
                    }
                }
                if (lengths.size() <= 2) continue;
                double lengthZ = Math.abs((Double)lengths.get(2));
                if (lengthZ < 0.01) {
                    lengthZ *= 1000000.0;
                }
                if (!(lengthZ > 0.0) || (physicalSizeZ = FormatTools.getPhysicalSizeZ((Double)(lengthZ / (double)meta_data.sizeZ), UNITS.MICROMETER)) == null) continue;
                this.metadataStore.setPixelsPhysicalSizeZ(physicalSizeZ, image);
            }
        }
    }

    private long initStack(long current) throws FormatException, IOException {
        this.in.seek(current);
        String magicString = this.in.readString(STACK_MAGIC_STRING.length());
        short magicNumber = this.in.readShort();
        int version = this.in.readInt();
        if (magicString.equals(STACK_MAGIC_STRING) && magicNumber == -1) {
            int image = this.core.size();
            CoreMetadata meta_data = new CoreMetadata();
            this.core.add(meta_data);
            meta_data.littleEndian = true;
            meta_data.thumbnail = false;
            int numberOfDimensions = this.in.readInt();
            if (numberOfDimensions > 5) {
                throw new FormatException("Unsupported number of " + numberOfDimensions + " dimensions");
            }
            int[] sizes = new int[15];
            for (int dimension = 0; dimension != 15; ++dimension) {
                int size = this.in.readInt();
                sizes[dimension] = dimension < numberOfDimensions ? size : 1;
            }
            if (this.ome_meta_data != null) {
                meta_data.sizeX = (Integer)this.ome_meta_data.getPixelsSizeX(image).getValue();
                meta_data.sizeY = (Integer)this.ome_meta_data.getPixelsSizeY(image).getValue();
                meta_data.sizeZ = (Integer)this.ome_meta_data.getPixelsSizeZ(image).getValue();
                meta_data.sizeC = (Integer)this.ome_meta_data.getPixelsSizeC(image).getValue();
                meta_data.sizeT = (Integer)this.ome_meta_data.getPixelsSizeT(image).getValue();
            } else {
                meta_data.sizeX = sizes[0];
                meta_data.sizeY = sizes[1];
                meta_data.sizeZ = sizes[2];
                meta_data.sizeC = sizes[3];
                meta_data.sizeT = sizes[4];
            }
            meta_data.imageCount = meta_data.sizeZ * meta_data.sizeC * meta_data.sizeT;
            if (this.ome_meta_data != null) {
                meta_data.dimensionOrder = this.ome_meta_data.getPixelsDimensionOrder(image).toString();
                meta_data.orderCertain = true;
            } else {
                meta_data.dimensionOrder = "XYZCT";
                meta_data.orderCertain = false;
            }
            ArrayList<Double> lengths = new ArrayList<Double>();
            for (int dimension = 0; dimension != 15; ++dimension) {
                double length = this.in.readDouble();
                if (dimension >= numberOfDimensions) continue;
                lengths.add(new Double(length));
            }
            meta_data.seriesMetadata.put("Lengths", lengths);
            ArrayList<Double> offsets = new ArrayList<Double>();
            for (int dimension = 0; dimension != 15; ++dimension) {
                double offset = this.in.readDouble();
                if (dimension >= numberOfDimensions) continue;
                offsets.add(new Double(offset));
            }
            meta_data.seriesMetadata.put("Offsets", offsets);
            int type = this.in.readInt();
            meta_data.pixelType = this.getPixelType(type);
            meta_data.bitsPerPixel = this.getBitsPerPixel(type);
            meta_data.indexed = false;
            meta_data.rgb = false;
            meta_data.interleaved = false;
            Stack stack = new Stack();
            int compression = this.in.readInt();
            stack.compression = this.getCompression(compression);
            this.in.skipBytes(4);
            int lengthOfName = this.in.readInt();
            int lengthOfDescription = this.in.readInt();
            this.in.skipBytes(8);
            long lengthOfData = this.in.readLong();
            stack.length = this.getLength(lengthOfData);
            long next = this.in.readLong();
            String name = this.in.readString(lengthOfName);
            meta_data.seriesMetadata.put("Name", name);
            String description = this.in.readString(lengthOfDescription);
            if (description != null && lengthOfDescription > 0) {
                description = XMLTools.sanitizeXML(description);
                description = description.replaceAll("<Time Lapse ", "<TimeLapse ");
                description = description.replaceAll("</Time Lapse", "</TimeLapse");
                boolean xml = false;
                try {
                    Element root = XMLTools.parseDOM(description).getDocumentElement();
                    root = this.getChildNodes(root).get(0);
                    ArrayList<Element> children = this.getChildNodes(root);
                    for (Element child : children) {
                        String nodeName = child.getNodeName();
                        ArrayList<Element> grandchildren = this.getChildNodes(child);
                        for (Element grandchild : grandchildren) {
                            String key = grandchild.getNodeName();
                            String value = grandchild.getTextContent().trim();
                            if (!key.equals("doc") && !key.equals("hwr")) {
                                this.addSeriesMeta(nodeName + " " + key, value);
                                continue;
                            }
                            ArrayList<Element> docs = this.getChildNodes(grandchild);
                            for (Element doc : docs) {
                                key = doc.getNodeName();
                                value = doc.getTextContent().trim();
                                this.addSeriesMeta(nodeName + " " + key, value);
                            }
                        }
                    }
                    xml = true;
                }
                catch (ParserConfigurationException e) {
                    LOGGER.warn("Could not parse description as XML", e);
                }
                catch (SAXException e) {
                    LOGGER.warn("Could not parse description as XML", e);
                }
                if (!xml) {
                    meta_data.seriesMetadata.put("Description", description);
                }
            }
            stack.position = this.in.getFilePointer();
            this.stacks.add(stack);
            if (this.file_version >= 1) {
                this.in.skip(lengthOfData);
                long footer = this.in.getFilePointer();
                int offset = this.in.readInt();
                ArrayList<Boolean> stepsPresent = new ArrayList<Boolean>();
                for (int dimension = 0; dimension != 15; ++dimension) {
                    int present = this.in.readInt();
                    if (dimension >= numberOfDimensions) continue;
                    stepsPresent.add(new Boolean(present != 0));
                }
                ArrayList<Boolean> stepLabelsPresent = new ArrayList<Boolean>();
                for (int dimension = 0; dimension != 15; ++dimension) {
                    int present = this.in.readInt();
                    if (dimension >= numberOfDimensions) continue;
                    stepLabelsPresent.add(new Boolean(present != 0));
                }
                this.in.seek(footer + (long)offset);
                ArrayList<String> labels = new ArrayList<String>();
                for (int dimension = 0; dimension != numberOfDimensions; ++dimension) {
                    int length = this.in.readInt();
                    String label = this.in.readString(length);
                    labels.add(label);
                }
                meta_data.seriesMetadata.put("Labels", labels);
                ArrayList steps = new ArrayList();
                for (int dimension = 0; dimension != numberOfDimensions; ++dimension) {
                    ArrayList<Double> list = new ArrayList<Double>();
                    if (((Boolean)stepsPresent.get(dimension)).booleanValue()) {
                        for (int position = 0; position != sizes[dimension]; ++position) {
                            double step = this.in.readDouble();
                            list.add(new Double(step));
                        }
                    }
                    steps.add(list);
                }
                meta_data.seriesMetadata.put("Steps", steps);
                ArrayList stepLabels = new ArrayList();
                for (int dimension = 0; dimension != numberOfDimensions; ++dimension) {
                    ArrayList<String> list = new ArrayList<String>();
                    if (((Boolean)stepLabelsPresent.get(dimension)).booleanValue()) {
                        for (int position = 0; position != sizes[dimension]; ++position) {
                            int length = this.in.readInt();
                            String label = this.in.readString(length);
                            list.add(label);
                        }
                    }
                    stepLabels.add(list);
                }
                meta_data.seriesMetadata.put("StepLabels", stepLabels);
            }
            return next;
        }
        throw new FormatException("Unsupported stack format");
    }

    private int getPixelType(int type) throws FormatException {
        switch (type) {
            case 1: {
                return 1;
            }
            case 2: {
                return 0;
            }
            case 4: {
                return 3;
            }
            case 8: {
                return 2;
            }
            case 16: {
                return 5;
            }
            case 32: {
                return 4;
            }
            case 64: {
                return 6;
            }
            case 128: {
                return 7;
            }
        }
        throw new FormatException("Unsupported data type " + type);
    }

    private int getBitsPerPixel(int type) throws FormatException {
        switch (type) {
            case 1: 
            case 2: {
                return 8;
            }
            case 4: 
            case 8: {
                return 16;
            }
            case 16: 
            case 32: {
                return 32;
            }
            case 64: {
                return 32;
            }
            case 128: {
                return 64;
            }
        }
        throw new FormatException("Unsupported data type " + type);
    }

    private long getLength(long length) throws FormatException {
        if (length >= 0L) {
            return length;
        }
        throw new FormatException("Negative stack length on disk");
    }

    private boolean getCompression(int compression) throws FormatException {
        switch (compression) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        throw new FormatException("Unsupported compression " + compression);
    }

    private String readString() throws IOException {
        int length = this.in.readInt();
        if (length > 0) {
            return this.in.readString(length);
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] openBytes(int no, byte[] buffer, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buffer.length, x, y, w, h);
        int rows = this.getSizeY();
        int columns = this.getSizeX();
        int bytesPerPixel = this.getBitsPerPixel() / 8;
        int series = this.getSeries();
        Stack stack = this.stacks.get(series);
        if (stack.compression) {
            if (series != this.currentInflatedFrame.series) {
                this.currentInflatedFrame.bytes = new byte[rows * columns * bytesPerPixel];
                this.currentInflatedFrame.series = series;
                this.currentInflatedFrame.number = -1;
            }
            if (this.inflater == null) {
                this.inflater = new Inflater();
            }
            byte[] bytes = this.currentInflatedFrame.bytes;
            if (no != this.currentInflatedFrame.number) {
                if (no < this.currentInflatedFrame.number) {
                    this.currentInflatedFrame.number = -1;
                }
                if (this.currentInflatedFrame.number == -1) {
                    this.in.seek(stack.position);
                    this.inflater.reset();
                }
                byte[] input = new byte[8192];
                while (no != this.currentInflatedFrame.number) {
                    for (int offset = 0; offset != bytes.length; offset += this.inflater.inflate(bytes, offset, bytes.length - offset)) {
                        if (this.inflater.needsInput()) {
                            long remainder = stack.position + stack.length - this.in.getFilePointer();
                            if (remainder <= 0L) throw new FormatException("Corrupted zlib compression");
                            int length = remainder > (long)input.length ? input.length : (int)remainder;
                            this.in.read(input, 0, length);
                            this.inflater.setInput(input, 0, length);
                        } else if (this.inflater.needsDictionary()) {
                            throw new FormatException("Unsupported zlib compression");
                        }
                        try {
                            continue;
                        }
                        catch (DataFormatException exception) {
                            throw new FormatException(exception.getMessage());
                        }
                    }
                    ++this.currentInflatedFrame.number;
                }
            }
            for (int row = 0; row != h; ++row) {
                System.arraycopy(bytes, ((row + y) * columns + x) * bytesPerPixel, buffer, row * w * bytesPerPixel, w * bytesPerPixel);
            }
            return buffer;
        } else {
            for (int row = 0; row != h; ++row) {
                this.in.seek(stack.position + (long)(((no * rows + row + y) * columns + x) * bytesPerPixel));
                this.in.read(buffer, row * w * bytesPerPixel, w * bytesPerPixel);
            }
        }
        return buffer;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        if (!fileOnly) {
            this.file_version = -1;
            this.ome_meta_data = null;
            this.stacks.clear();
            this.currentInflatedFrame = new Frame();
            this.inflater = null;
        }
        super.close(fileOnly);
    }

    private ArrayList<Element> getChildNodes(Element root) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            list.add((Element)child);
        }
        return list;
    }

    private class Frame {
        byte[] bytes;
        int series;
        int number;

        private Frame() {
        }
    }

    private class Stack {
        long position;
        long length;
        boolean compression;

        private Stack() {
        }
    }
}

