/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.codec.JPEG2000CodecOptions;
import loci.formats.in.JPEG2000MetadataParser;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffCompression;
import loci.formats.tiff.TiffParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinimalTiffReader
extends FormatReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(MinimalTiffReader.class);
    protected IFDList ifds;
    protected IFDList thumbnailIFDs;
    protected List<IFDList> subResolutionIFDs;
    protected transient TiffParser tiffParser;
    protected boolean equalStrips = false;
    protected boolean use64Bit = false;
    protected int lastPlane = 0;
    protected boolean noSubresolutions = false;
    protected boolean seriesToIFD = false;
    private Integer resolutionLevels;
    private JPEG2000CodecOptions j2kCodecOptions;

    public MinimalTiffReader() {
        this("Minimal TIFF", new String[]{"tif", "tiff", "tf2", "tf8", "btf"});
    }

    public MinimalTiffReader(String name, String suffix) {
        this(name, new String[]{suffix});
    }

    public MinimalTiffReader(String name, String[] suffixes) {
        super(name, suffixes);
        this.domains = new String[]{"Graphics"};
        this.suffixNecessary = false;
    }

    public IFDList getIFDs() {
        return this.ifds;
    }

    public IFDList getThumbnailIFDs() {
        return this.thumbnailIFDs;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return new TiffParser(stream).isValidHeader();
    }

    @Override
    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.ifds == null || this.lastPlane < 0 || this.lastPlane >= this.ifds.size()) {
            return null;
        }
        IFD lastIFD = (IFD)this.ifds.get(this.lastPlane);
        int[] bits = lastIFD.getBitsPerSample();
        if (bits[0] <= 8) {
            int[] colorMap = this.tiffParser.getColorMap(lastIFD);
            if (colorMap == null) {
                if (this.lastPlane != 0) {
                    lastIFD = (IFD)this.ifds.get(0);
                    colorMap = this.tiffParser.getColorMap(lastIFD);
                    if (colorMap == null) {
                        return null;
                    }
                } else {
                    return null;
                }
            }
            byte[][] table = new byte[3][colorMap.length / 3];
            int next = 0;
            for (int j = 0; j < table.length; ++j) {
                for (int i = 0; i < table[0].length; ++i) {
                    table[j][i] = colorMap[next] > 255 ? (byte)(colorMap[next++] >> 8 & 0xFF) : (byte)(colorMap[next++] & 0xFF);
                }
            }
            return table;
        }
        return null;
    }

    @Override
    public short[][] get16BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.ifds == null || this.lastPlane < 0 || this.lastPlane >= this.ifds.size()) {
            return null;
        }
        IFD lastIFD = (IFD)this.ifds.get(this.lastPlane);
        int[] bits = lastIFD.getBitsPerSample();
        if (bits[0] <= 16 && bits[0] > 8) {
            int[] colorMap = this.tiffParser.getColorMap(lastIFD);
            if (colorMap == null || colorMap.length < 196608) {
                if (this.lastPlane != 0) {
                    lastIFD = (IFD)this.ifds.get(0);
                    colorMap = this.tiffParser.getColorMap(lastIFD);
                    if (colorMap == null || colorMap.length < 196608) {
                        return null;
                    }
                } else {
                    return null;
                }
            }
            short[][] table = new short[3][colorMap.length / 3];
            int next = 0;
            for (int i = 0; i < table.length; ++i) {
                for (int j = 0; j < table[0].length; ++j) {
                    table[i][j] = (short)(colorMap[next++] & 0xFFFF);
                }
            }
            return table;
        }
        return null;
    }

    @Override
    public int getThumbSizeX() {
        if (this.thumbnailIFDs != null && this.thumbnailIFDs.size() > 0) {
            try {
                return (int)((IFD)this.thumbnailIFDs.get(0)).getImageWidth();
            }
            catch (FormatException e) {
                LOGGER.debug("Could not retrieve thumbnail width", e);
            }
        }
        return super.getThumbSizeX();
    }

    @Override
    public int getThumbSizeY() {
        if (this.thumbnailIFDs != null && this.thumbnailIFDs.size() > 0) {
            try {
                return (int)((IFD)this.thumbnailIFDs.get(0)).getImageLength();
            }
            catch (FormatException e) {
                LOGGER.debug("Could not retrieve thumbnail height", e);
            }
        }
        return super.getThumbSizeY();
    }

    @Override
    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.thumbnailIFDs == null || this.thumbnailIFDs.size() <= no) {
            return super.openThumbBytes(no);
        }
        if (this.tiffParser == null) {
            this.initTiffParser();
        }
        this.tiffParser.fillInIFD((IFD)this.thumbnailIFDs.get(no));
        int[] bps = null;
        try {
            bps = ((IFD)this.thumbnailIFDs.get(no)).getBitsPerSample();
        }
        catch (FormatException formatException) {
            // empty catch block
        }
        if (bps == null) {
            return super.openThumbBytes(no);
        }
        int b = bps[0];
        while (b % 8 != 0) {
            ++b;
        }
        if ((b /= 8) != FormatTools.getBytesPerPixel(this.getPixelType()) || bps.length != this.getRGBChannelCount()) {
            return super.openThumbBytes(no);
        }
        byte[] buf = new byte[this.getThumbSizeX() * this.getThumbSizeY() * this.getRGBChannelCount() * FormatTools.getBytesPerPixel(this.getPixelType())];
        return this.tiffParser.getSamples((IFD)this.thumbnailIFDs.get(no), buf);
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        boolean float24;
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        IFD firstIFD = (IFD)this.ifds.get(0);
        this.lastPlane = no;
        IFD ifd = this.seriesToIFD ? (IFD)this.ifds.get(this.getSeries()) : (IFD)this.ifds.get(no);
        if ((firstIFD.getCompression() == TiffCompression.JPEG_2000 || firstIFD.getCompression() == TiffCompression.JPEG_2000_LOSSY) && this.resolutionLevels != null) {
            if (this.getCoreIndex() > 0) {
                ifd = (IFD)this.subResolutionIFDs.get(no).get(this.getCoreIndex() - 1);
            }
            this.setResolutionLevel(ifd);
        }
        if (this.tiffParser == null) {
            this.initTiffParser();
        }
        this.tiffParser.getSamples(ifd, buf, x, y, w, h);
        boolean float16 = this.getPixelType() == 6 && firstIFD.getBitsPerSample()[0] == 16;
        boolean bl = float24 = this.getPixelType() == 6 && firstIFD.getBitsPerSample()[0] == 24;
        if (float16 || float24) {
            int nPixels = w * h * this.getRGBChannelCount();
            int nBytes = float16 ? 2 : 3;
            int mantissaBits = float16 ? 10 : 16;
            int exponentBits = float16 ? 5 : 7;
            int maxExponent = (int)Math.pow(2.0, exponentBits) - 1;
            int bits = nBytes * 8 - 1;
            byte[] newBuf = new byte[buf.length];
            for (int i = 0; i < nPixels; ++i) {
                int v = DataTools.bytesToInt(buf, i * nBytes, nBytes, this.isLittleEndian());
                int sign = v >> bits;
                int exponent = v >> mantissaBits & (int)(Math.pow(2.0, exponentBits) - 1.0);
                int mantissa = v & (int)(Math.pow(2.0, mantissaBits) - 1.0);
                if (exponent == 0) {
                    if (mantissa != 0) {
                        while ((mantissa & (int)Math.pow(2.0, mantissaBits)) == 0) {
                            mantissa <<= 1;
                            --exponent;
                        }
                        ++exponent;
                        mantissa &= (int)(Math.pow(2.0, mantissaBits) - 1.0);
                        exponent = (int)((double)exponent + (127.0 - (Math.pow(2.0, exponentBits - 1) - 1.0)));
                    }
                } else {
                    exponent = exponent == maxExponent ? 255 : (int)((double)exponent + (127.0 - (Math.pow(2.0, exponentBits - 1) - 1.0)));
                }
                int value = sign << 31 | exponent << 23 | (mantissa <<= 23 - mantissaBits);
                DataTools.unpackBytes(value, newBuf, i * 4, 4, this.isLittleEndian());
            }
            System.arraycopy(newBuf, 0, buf, 0, newBuf.length);
        }
        return buf;
    }

    @Override
    public void reopenFile() throws IOException {
        this.initTiffParser();
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            if (this.ifds != null) {
                for (IFD ifd : this.ifds) {
                    try {
                        if (ifd.getOnDemandStripOffsets() == null) continue;
                        ifd.getOnDemandStripOffsets().close();
                    }
                    catch (FormatException e) {
                        LOGGER.debug("", e);
                    }
                }
            }
            this.ifds = null;
            this.thumbnailIFDs = null;
            this.subResolutionIFDs = null;
            this.lastPlane = 0;
            this.tiffParser = null;
            this.resolutionLevels = null;
            this.j2kCodecOptions = null;
            this.seriesToIFD = false;
        }
    }

    @Override
    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            return (int)((IFD)this.ifds.get(0)).getTileWidth();
        }
        catch (FormatException e) {
            LOGGER.debug("Could not retrieve tile width", e);
            return super.getOptimalTileWidth();
        }
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            int height = (int)((IFD)this.ifds.get(0)).getTileLength();
            if (height <= 0) {
                height = this.getSizeY();
            }
            if (DataTools.safeMultiply32(height, this.getOptimalTileWidth()) > 0xA00000) {
                return super.getOptimalTileHeight();
            }
            if (height > 1) {
                return height;
            }
        }
        catch (FormatException e) {
            LOGGER.debug("Could not retrieve tile height", e);
        }
        return super.getOptimalTileHeight();
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        Object stripByteCounts;
        super.initFile(id);
        this.in = new RandomAccessInputStream(id, 16);
        this.initTiffParser();
        Boolean littleEndian = this.tiffParser.checkHeader();
        if (littleEndian == null) {
            throw new FormatException("Invalid TIFF file: " + id);
        }
        boolean little = littleEndian;
        this.in.order(little);
        LOGGER.info("Reading IFDs");
        IFDList allIFDs = this.tiffParser.getIFDs();
        if (allIFDs == null || allIFDs.size() == 0) {
            throw new FormatException("No IFDs found");
        }
        this.ifds = new IFDList();
        this.thumbnailIFDs = new IFDList();
        this.subResolutionIFDs = new ArrayList<IFDList>();
        for (Object ifd : allIFDs) {
            int subfileType;
            this.tiffParser.fillInIFD((IFD)ifd);
            Number subfile = (Number)((IFD)ifd).getIFDValue(254);
            int n = subfileType = subfile == null ? 0 : subfile.intValue();
            if (subfileType != 1 || allIFDs.size() <= 1) {
                this.ifds.add(ifd);
                continue;
            }
            if (subfileType != 1) continue;
            this.thumbnailIFDs.add(ifd);
        }
        LOGGER.info("Populating metadata");
        CoreMetadata ms0 = (CoreMetadata)this.core.get(0);
        ms0.imageCount = this.ifds.size();
        this.tiffParser.setAssumeEqualStrips(this.equalStrips);
        for (IFD ifd : this.ifds) {
            if (ifd.getCompression() != TiffCompression.JPEG_2000 && ifd.getCompression() != TiffCompression.JPEG_2000_LOSSY || ifd.getImageWidth() != ((IFD)this.ifds.get(0)).getImageWidth()) continue;
            LOGGER.debug("Found IFD with JPEG 2000 compression");
            long[] stripOffsets = ifd.getStripOffsets();
            stripByteCounts = ifd.getStripByteCounts();
            if (stripOffsets.length > 0) {
                long stripOffset = stripOffsets[0];
                this.in.seek(stripOffset);
                JPEG2000MetadataParser metadataParser = new JPEG2000MetadataParser(this.in, stripOffset + stripByteCounts[0]);
                this.resolutionLevels = metadataParser.getResolutionLevels();
                if (this.resolutionLevels == null || this.noSubresolutions) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Original resolution IFD Levels %d %dx%d Tile %dx%d", this.resolutionLevels, ifd.getImageWidth(), ifd.getImageLength(), ifd.getTileWidth(), ifd.getTileLength()));
                }
                IFDList theseSubResolutionIFDs = new IFDList();
                this.subResolutionIFDs.add(theseSubResolutionIFDs);
                for (int level = 1; level <= this.resolutionLevels; ++level) {
                    IFD newIFD = new IFD(ifd);
                    long imageWidth = ifd.getImageWidth();
                    long imageLength = ifd.getImageLength();
                    long tileWidth = ifd.getTileWidth();
                    long tileLength = ifd.getTileLength();
                    long factor = (long)Math.pow(2.0, level);
                    long newTileWidth = Math.round((double)tileWidth / (double)factor);
                    newTileWidth = newTileWidth < 1L ? 1L : newTileWidth;
                    long newTileLength = Math.round((double)tileLength / (double)factor);
                    newTileLength = newTileLength < 1L ? 1L : newTileLength;
                    long evenTilesPerRow = imageWidth / tileWidth;
                    long evenTilesPerColumn = imageLength / tileLength;
                    double remainingWidth = (double)(imageWidth - evenTilesPerRow * tileWidth) / (double)factor;
                    remainingWidth = remainingWidth < 1.0 ? Math.ceil(remainingWidth) : (double)Math.round(remainingWidth);
                    double remainingLength = (double)(imageLength - evenTilesPerColumn * tileLength) / (double)factor;
                    remainingLength = remainingLength < 1.0 ? Math.ceil(remainingLength) : (double)Math.round(remainingLength);
                    long newImageWidth = (long)((double)(evenTilesPerRow * newTileWidth) + remainingWidth);
                    long newImageLength = (long)((double)(evenTilesPerColumn * newTileLength) + remainingLength);
                    int resolutionLevel = Math.abs(level - this.resolutionLevels);
                    newIFD.put(256, newImageWidth);
                    newIFD.put(257, newImageLength);
                    newIFD.put(322, newTileWidth);
                    newIFD.put(323, newTileLength);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(String.format("Added JPEG 2000 sub-resolution IFD Level %d %dx%d Tile %dx%d", resolutionLevel, newImageWidth, newImageLength, newTileWidth, newTileLength));
                    }
                    theseSubResolutionIFDs.add(newIFD);
                }
                continue;
            }
            LOGGER.warn("IFD has no strip offsets!");
        }
        IFD firstIFD = (IFD)this.ifds.get(0);
        PhotoInterp photo = firstIFD.getPhotometricInterpretation();
        int samples = firstIFD.getSamplesPerPixel();
        ms0.rgb = samples > 1 || photo == PhotoInterp.RGB;
        ms0.interleaved = false;
        ms0.littleEndian = firstIFD.isLittleEndian();
        ms0.sizeX = (int)firstIFD.getImageWidth();
        ms0.sizeY = (int)firstIFD.getImageLength();
        ms0.sizeZ = 1;
        ms0.sizeC = this.isRGB() ? samples : 1;
        ms0.sizeT = this.ifds.size();
        ms0.pixelType = firstIFD.getPixelType();
        ms0.metadataComplete = true;
        boolean bl = ms0.indexed = photo == PhotoInterp.RGB_PALETTE && (this.get8BitLookupTable() != null || this.get16BitLookupTable() != null);
        if (this.isIndexed()) {
            ms0.sizeC = 1;
            ms0.rgb = false;
            stripByteCounts = this.ifds.iterator();
            while (stripByteCounts.hasNext()) {
                IFD ifd = (IFD)stripByteCounts.next();
                ifd.putIFDValue(262, PhotoInterp.RGB_PALETTE);
            }
        }
        if (this.getSizeC() == 1 && !this.isIndexed()) {
            ms0.rgb = false;
        }
        ms0.dimensionOrder = "XYCZT";
        ms0.bitsPerPixel = firstIFD.getBitsPerSample()[0];
        if (this.resolutionLevels != null && this.subResolutionIFDs.size() > 0) {
            IFDList ifds = this.subResolutionIFDs.get(0);
            int seriesCount = ifds.size() + 1;
            if (!this.hasFlattenedResolutions()) {
                ms0.resolutionCount = seriesCount;
            }
            ms0.imageCount = ms0.sizeT = this.subResolutionIFDs.size();
            if (ms0.sizeT <= 0) {
                ms0.sizeT = 1;
            }
            if (ms0.imageCount <= 0) {
                ms0.imageCount = 1;
            }
            for (IFD ifd : ifds) {
                CoreMetadata ms = new CoreMetadata(this, 0);
                this.core.add(ms);
                ms.sizeX = (int)ifd.getImageWidth();
                ms.sizeY = (int)ifd.getImageLength();
                ms.sizeT = ms0.sizeT;
                ms.imageCount = ms0.imageCount;
                ms.thumbnail = true;
                ms.resolutionCount = 1;
            }
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
    }

    protected void setResolutionLevel(IFD ifd) {
        if (this.tiffParser == null) {
            this.initTiffParser();
        }
        if (this.j2kCodecOptions == null) {
            this.j2kCodecOptions = new JPEG2000CodecOptions();
        }
        this.j2kCodecOptions.resolution = Math.abs(this.getCoreIndex() - this.resolutionLevels);
        LOGGER.debug("Using JPEG 2000 resolution level {}", (Object)this.j2kCodecOptions.resolution);
        this.tiffParser.setCodecOptions(this.j2kCodecOptions);
    }

    protected void initTiffParser() {
        if (this.in == null) {
            try {
                this.in = new RandomAccessInputStream(this.getCurrentFile(), 16);
            }
            catch (IOException e) {
                LOGGER.error("Could not initialize stream", e);
            }
        }
        this.tiffParser = new TiffParser(this.in);
        this.tiffParser.setDoCaching(false);
        this.tiffParser.setUse64BitOffsets(this.use64Bit);
    }
}

