/**
  @Generated Pin Manager Header File

  @Company:
    Microchip Technology Inc.

  @File Name:
    pin_manager.h

  @Summary:
    This is the Pin Manager file generated using PIC10 / PIC12 / PIC16 / PIC18 MCUs

  @Description
    This header file provides APIs for driver for .
    Generation Information :
        Product Revision  :  PIC10 / PIC12 / PIC16 / PIC18 MCUs - 1.81.7
        Device            :  PIC16LF1704
        Driver Version    :  2.11
    The generated drivers are tested against the following:
        Compiler          :  XC8 2.31 and above
        MPLAB 	          :  MPLAB X 5.45	
*/

/*
    (c) 2018 Microchip Technology Inc. and its subsidiaries. 
    
    Subject to your compliance with these terms, you may use Microchip software and any 
    derivatives exclusively with Microchip products. It is your responsibility to comply with third party 
    license terms applicable to your use of third party software (including open source software) that 
    may accompany Microchip software.
    
    THIS SOFTWARE IS SUPPLIED BY MICROCHIP "AS IS". NO WARRANTIES, WHETHER 
    EXPRESS, IMPLIED OR STATUTORY, APPLY TO THIS SOFTWARE, INCLUDING ANY 
    IMPLIED WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY, AND FITNESS 
    FOR A PARTICULAR PURPOSE.
    
    IN NO EVENT WILL MICROCHIP BE LIABLE FOR ANY INDIRECT, SPECIAL, PUNITIVE, 
    INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE, COST OR EXPENSE OF ANY KIND 
    WHATSOEVER RELATED TO THE SOFTWARE, HOWEVER CAUSED, EVEN IF MICROCHIP 
    HAS BEEN ADVISED OF THE POSSIBILITY OR THE DAMAGES ARE FORESEEABLE. TO 
    THE FULLEST EXTENT ALLOWED BY LAW, MICROCHIP'S TOTAL LIABILITY ON ALL 
    CLAIMS IN ANY WAY RELATED TO THIS SOFTWARE WILL NOT EXCEED THE AMOUNT 
    OF FEES, IF ANY, THAT YOU HAVE PAID DIRECTLY TO MICROCHIP FOR THIS 
    SOFTWARE.
*/

#ifndef PIN_MANAGER_H
#define PIN_MANAGER_H

/**
  Section: Included Files
*/

#include <xc.h>

#define INPUT   1
#define OUTPUT  0

#define HIGH    1
#define LOW     0

#define ANALOG      1
#define DIGITAL     0

#define PULL_UP_ENABLED      1
#define PULL_UP_DISABLED     0

// get/set ASK aliases
#define ASK_TRIS                 TRISAbits.TRISA0
#define ASK_LAT                  LATAbits.LATA0
#define ASK_PORT                 PORTAbits.RA0
#define ASK_WPU                  WPUAbits.WPUA0
#define ASK_OD                   ODCONAbits.ODA0
#define ASK_ANS                  ANSELAbits.ANSA0
#define ASK_SetHigh()            do { LATAbits.LATA0 = 1; } while(0)
#define ASK_SetLow()             do { LATAbits.LATA0 = 0; } while(0)
#define ASK_Toggle()             do { LATAbits.LATA0 = ~LATAbits.LATA0; } while(0)
#define ASK_GetValue()           PORTAbits.RA0
#define ASK_SetDigitalInput()    do { TRISAbits.TRISA0 = 1; } while(0)
#define ASK_SetDigitalOutput()   do { TRISAbits.TRISA0 = 0; } while(0)
#define ASK_SetPullup()          do { WPUAbits.WPUA0 = 1; } while(0)
#define ASK_ResetPullup()        do { WPUAbits.WPUA0 = 0; } while(0)
#define ASK_SetPushPull()        do { ODCONAbits.ODA0 = 0; } while(0)
#define ASK_SetOpenDrain()       do { ODCONAbits.ODA0 = 1; } while(0)
#define ASK_SetAnalogMode()      do { ANSELAbits.ANSA0 = 1; } while(0)
#define ASK_SetDigitalMode()     do { ANSELAbits.ANSA0 = 0; } while(0)

// get/set IO_RA1 aliases
#define IO_RA1_TRIS                 TRISAbits.TRISA1
#define IO_RA1_LAT                  LATAbits.LATA1
#define IO_RA1_PORT                 PORTAbits.RA1
#define IO_RA1_WPU                  WPUAbits.WPUA1
#define IO_RA1_OD                   ODCONAbits.ODA1
#define IO_RA1_ANS                  ANSELAbits.ANSA1
#define IO_RA1_SetHigh()            do { LATAbits.LATA1 = 1; } while(0)
#define IO_RA1_SetLow()             do { LATAbits.LATA1 = 0; } while(0)
#define IO_RA1_Toggle()             do { LATAbits.LATA1 = ~LATAbits.LATA1; } while(0)
#define IO_RA1_GetValue()           PORTAbits.RA1
#define IO_RA1_SetDigitalInput()    do { TRISAbits.TRISA1 = 1; } while(0)
#define IO_RA1_SetDigitalOutput()   do { TRISAbits.TRISA1 = 0; } while(0)
#define IO_RA1_SetPullup()          do { WPUAbits.WPUA1 = 1; } while(0)
#define IO_RA1_ResetPullup()        do { WPUAbits.WPUA1 = 0; } while(0)
#define IO_RA1_SetPushPull()        do { ODCONAbits.ODA1 = 0; } while(0)
#define IO_RA1_SetOpenDrain()       do { ODCONAbits.ODA1 = 1; } while(0)
#define IO_RA1_SetAnalogMode()      do { ANSELAbits.ANSA1 = 1; } while(0)
#define IO_RA1_SetDigitalMode()     do { ANSELAbits.ANSA1 = 0; } while(0)

// get/set MICRF_VDD aliases
#define MICRF_VDD_TRIS                 TRISAbits.TRISA5
#define MICRF_VDD_LAT                  LATAbits.LATA5
#define MICRF_VDD_PORT                 PORTAbits.RA5
#define MICRF_VDD_WPU                  WPUAbits.WPUA5
#define MICRF_VDD_OD                   ODCONAbits.ODA5
#define MICRF_VDD_SetHigh()            do { LATAbits.LATA5 = 1; } while(0)
#define MICRF_VDD_SetLow()             do { LATAbits.LATA5 = 0; } while(0)
#define MICRF_VDD_Toggle()             do { LATAbits.LATA5 = ~LATAbits.LATA5; } while(0)
#define MICRF_VDD_GetValue()           PORTAbits.RA5
#define MICRF_VDD_SetDigitalInput()    do { TRISAbits.TRISA5 = 1; } while(0)
#define MICRF_VDD_SetDigitalOutput()   do { TRISAbits.TRISA5 = 0; } while(0)
#define MICRF_VDD_SetPullup()          do { WPUAbits.WPUA5 = 1; } while(0)
#define MICRF_VDD_ResetPullup()        do { WPUAbits.WPUA5 = 0; } while(0)
#define MICRF_VDD_SetPushPull()        do { ODCONAbits.ODA5 = 0; } while(0)
#define MICRF_VDD_SetOpenDrain()       do { ODCONAbits.ODA5 = 1; } while(0)

// get/set RC1 procedures
#define RC1_SetHigh()            do { LATCbits.LATC1 = 1; } while(0)
#define RC1_SetLow()             do { LATCbits.LATC1 = 0; } while(0)
#define RC1_Toggle()             do { LATCbits.LATC1 = ~LATCbits.LATC1; } while(0)
#define RC1_GetValue()              PORTCbits.RC1
#define RC1_SetDigitalInput()    do { TRISCbits.TRISC1 = 1; } while(0)
#define RC1_SetDigitalOutput()   do { TRISCbits.TRISC1 = 0; } while(0)
#define RC1_SetPullup()             do { WPUCbits.WPUC1 = 1; } while(0)
#define RC1_ResetPullup()           do { WPUCbits.WPUC1 = 0; } while(0)
#define RC1_SetAnalogMode()         do { ANSELCbits.ANSC1 = 1; } while(0)
#define RC1_SetDigitalMode()        do { ANSELCbits.ANSC1 = 0; } while(0)

// get/set PH_OUT aliases
#define PH_OUT_TRIS                 TRISCbits.TRISC2
#define PH_OUT_LAT                  LATCbits.LATC2
#define PH_OUT_PORT                 PORTCbits.RC2
#define PH_OUT_WPU                  WPUCbits.WPUC2
#define PH_OUT_OD                   ODCONCbits.ODC2
#define PH_OUT_ANS                  ANSELCbits.ANSC2
#define PH_OUT_SetHigh()            do { LATCbits.LATC2 = 1; } while(0)
#define PH_OUT_SetLow()             do { LATCbits.LATC2 = 0; } while(0)
#define PH_OUT_Toggle()             do { LATCbits.LATC2 = ~LATCbits.LATC2; } while(0)
#define PH_OUT_GetValue()           PORTCbits.RC2
#define PH_OUT_SetDigitalInput()    do { TRISCbits.TRISC2 = 1; } while(0)
#define PH_OUT_SetDigitalOutput()   do { TRISCbits.TRISC2 = 0; } while(0)
#define PH_OUT_SetPullup()          do { WPUCbits.WPUC2 = 1; } while(0)
#define PH_OUT_ResetPullup()        do { WPUCbits.WPUC2 = 0; } while(0)
#define PH_OUT_SetPushPull()        do { ODCONCbits.ODC2 = 0; } while(0)
#define PH_OUT_SetOpenDrain()       do { ODCONCbits.ODC2 = 1; } while(0)
#define PH_OUT_SetAnalogMode()      do { ANSELCbits.ANSC2 = 1; } while(0)
#define PH_OUT_SetDigitalMode()     do { ANSELCbits.ANSC2 = 0; } while(0)

// get/set PH_OUT2 aliases
#define PH_OUT2_TRIS                 TRISCbits.TRISC3
#define PH_OUT2_LAT                  LATCbits.LATC3
#define PH_OUT2_PORT                 PORTCbits.RC3
#define PH_OUT2_WPU                  WPUCbits.WPUC3
#define PH_OUT2_OD                   ODCONCbits.ODC3
#define PH_OUT2_ANS                  ANSELCbits.ANSC3
#define PH_OUT2_SetHigh()            do { LATCbits.LATC3 = 1; } while(0)
#define PH_OUT2_SetLow()             do { LATCbits.LATC3 = 0; } while(0)
#define PH_OUT2_Toggle()             do { LATCbits.LATC3 = ~LATCbits.LATC3; } while(0)
#define PH_OUT2_GetValue()           PORTCbits.RC3
#define PH_OUT2_SetDigitalInput()    do { TRISCbits.TRISC3 = 1; } while(0)
#define PH_OUT2_SetDigitalOutput()   do { TRISCbits.TRISC3 = 0; } while(0)
#define PH_OUT2_SetPullup()          do { WPUCbits.WPUC3 = 1; } while(0)
#define PH_OUT2_ResetPullup()        do { WPUCbits.WPUC3 = 0; } while(0)
#define PH_OUT2_SetPushPull()        do { ODCONCbits.ODC3 = 0; } while(0)
#define PH_OUT2_SetOpenDrain()       do { ODCONCbits.ODC3 = 1; } while(0)
#define PH_OUT2_SetAnalogMode()      do { ANSELCbits.ANSC3 = 1; } while(0)
#define PH_OUT2_SetDigitalMode()     do { ANSELCbits.ANSC3 = 0; } while(0)

// get/set PH_D aliases
#define PH_D_TRIS                 TRISCbits.TRISC4
#define PH_D_LAT                  LATCbits.LATC4
#define PH_D_PORT                 PORTCbits.RC4
#define PH_D_WPU                  WPUCbits.WPUC4
#define PH_D_OD                   ODCONCbits.ODC4
#define PH_D_ANS                  ANSELCbits.ANSC4
#define PH_D_SetHigh()            do { LATCbits.LATC4 = 1; } while(0)
#define PH_D_SetLow()             do { LATCbits.LATC4 = 0; } while(0)
#define PH_D_Toggle()             do { LATCbits.LATC4 = ~LATCbits.LATC4; } while(0)
#define PH_D_GetValue()           PORTCbits.RC4
#define PH_D_SetDigitalInput()    do { TRISCbits.TRISC4 = 1; } while(0)
#define PH_D_SetDigitalOutput()   do { TRISCbits.TRISC4 = 0; } while(0)
#define PH_D_SetPullup()          do { WPUCbits.WPUC4 = 1; } while(0)
#define PH_D_ResetPullup()        do { WPUCbits.WPUC4 = 0; } while(0)
#define PH_D_SetPushPull()        do { ODCONCbits.ODC4 = 0; } while(0)
#define PH_D_SetOpenDrain()       do { ODCONCbits.ODC4 = 1; } while(0)
#define PH_D_SetAnalogMode()      do { ANSELCbits.ANSC4 = 1; } while(0)
#define PH_D_SetDigitalMode()     do { ANSELCbits.ANSC4 = 0; } while(0)

/**
   @Param
    none
   @Returns
    none
   @Description
    GPIO and peripheral I/O initialization
   @Example
    PIN_MANAGER_Initialize();
 */
void PIN_MANAGER_Initialize (void);

/**
 * @Param
    none
 * @Returns
    none
 * @Description
    Interrupt on Change Handling routine
 * @Example
    PIN_MANAGER_IOC();
 */
void PIN_MANAGER_IOC(void);



#endif // PIN_MANAGER_H
/**
 End of File
*/