/**
  Main Source File
  Authors: M. Novak, J. Rosina, R. Gurlich, I. Cibulkova, J. Hajer
*/

#include "mcc_generated_files/mcc.h" //include the MCC generated peripheral and MCU configuration files

void peripheralson() // Turns on all peripherals
{
    FVR_Initialize();
    DAC_Initialize();
    DAC_SetOutput(120);
    ADC_Initialize();
    OPA1_Initialize();
    PH_D_SetHigh();
}

void peripheralsoff() // Turns off all peripherals (to reduce thepower consumption to minimum)
{
  PH_D_SetLow();
  DAC_SetOutput(0);
  ADCON0 = 0x00;
  DAC1CON0 = 0x00;
  OPA1CON = 0x00;
  FVRCON = 0x00;
}

void rfon() // Turns RF transmission on ("ASK 1")
{
  MICRF_VDD_SetHigh();ASK_SetHigh();
}

void rfoff() // Turns RF transmission off ("ASK 0")
{
  MICRF_VDD_SetLow();ASK_SetLow();
}

void transmitpreamble() // Transmits the preamble
{
        rfon();__delay_ms(75);
        rfoff(); __delay_ms(75);
        rfon();__delay_ms(75);
        rfoff();
}

uint16_t adcval = 0;

void tmr_routine() //routine which is ran periodically
{    
        uint8_t i;
        uint16_t j;
    
        asm("clrwdt"); // Clear the WDT
        peripheralson(); // Turn on the peripherals
        __delay_ms(5); // Wait for analog front end to settle
        
        adcval = 0; // Get 8 samples, 10 bit accuracy
        for(i=0;i<8;i++)
        {
          adcval+=ADC_GetConversion(PH_OUT2);
        }
        peripheralsoff();
        
        adcval/=4; // Convert the value to mV (divide by 8 samples and multiply by 2)
        
        if(adcval<800) // If the value is too low, convert it to zero, otherwise subtract 800
        {
            adcval = 0;
        }
        else
        {
            adcval -= 800;
        }
        
        transmitpreamble(); // Transmit the preamble
        
        for(j=0;j<adcval;j+=10) // Wait for the specified amount of time before the last pulse
        {
            __delay_ms(10);
        }
        
        rfon(); // Transmit last pulse
        __delay_ms(75);
        rfoff();
}

void main(void)
{
    uint32_t k = 0;
    
    // initialize the device
    SYSTEM_Initialize();

    INTERRUPT_GlobalInterruptEnable(); // Enable the Global Interrupts
    INTERRUPT_PeripheralInterruptEnable(); // Enable the Peripheral Interrupts
    
    peripheralsoff(); // Turn off the peripherals

    tmr_routine(); // Run the timer routine once at the beginning
    
    TMR1_SetInterruptHandler(tmr_routine); // Assign the routine to the timer
    TMR1_StartTimer(); // Start the timer

    while (1) // Sleep when the timer is not triggered
    {
        asm("sleep");
    }
}
/**
 End of File
*/