% =========================================================================
% SpaghettiPlots v1.0.0
% Author Janet Y. Sheung
% =========================================================================
% Program to compile tracking data into a single overlay of where all
% traces are shifted to start from the origin.
%
%
clear all
clf

path = uigetdir('Select time folder containing well data (clean_traces.mat) to graph.'); % prompt to choose a time folder
px2mm = input('Calibration: What is the number of pixels per millimeter?');

%px = 990-46; % num of px in diameter of well at 37.5x in AxioZoom Zeiss
%mm = 5*24/16; % diameter of well in mm

figure(3);
hold on
%Times = [460 495 500]; % the time points to include in plot
%835 950 1070
%numTimes = size(Times,2);
c_list = ['r' 'b' 'g' 'c' 'm' 'y']; % colors for plotting 
%for iTime = 1:numTimes    
%Directory = ['C:\Users\janets\Box\Research\Stentor\2020 Paper Draft\corrected times data\' num2str(Times(iTime)) '\'];
cd(path);
FolderList = dir; % build list of folders
for iFolder = 3:size(FolderList,1) % loop through folders, skipping fake first two
   if isdir(FolderList(iFolder).name)
    load([path '\' FolderList(iFolder).name '\CLEAN TRACES\clean_traces.mat'])

% 2. translate and plot overlay
 
    hold on
    x = -10:0.02:10;
    for iRadius = 1:1:5
        plot(x, sqrt(iRadius^2 - x.^2),':','color','k');
        plot(x, -sqrt(iRadius^2 - x.^2),':','color','k');
    end
    for iCol = 1:100
        X = Q_loc_estimateX(1:300,iCol);
        Y = Q_loc_estimateY(1:300,iCol);
        ValidRows = find(~isnan(X));
        StartRow = min(ValidRows);
        Cz = mod(iCol,6)+1; %pick color
        new_x = (X(ValidRows)-X(StartRow))/px2mm;
        new_y = (Y(ValidRows)-Y(StartRow))/px2mm;
        plot(new_x, new_y,'.-','markersize',1,'color',c_list(Cz),'linewidth',1);
    end
    iFolder
   end
%end
hold off
%axis([-5 5 -5 5])
rr = 4;
axis([-rr rr -rr rr])
xlabel('Displacement (mm)')
ylabel('Displacement (mm)')
end
