from clodsa.augmentors.augmentorFactory import createAugmentor
from clodsa.transformers.transformerFactory import transformerGenerator
from clodsa.techniques.techniqueFactory import createTechnique
import cv2

PROBLEM = "classification"
ANNOTATION_MODE = "folders"
INPUT_PATH = "train/"
GENERATION_MODE = "linear"
OUTPUT_MODE = "folders"
OUTPUT_PATH= "output/"

augmentor = createAugmentor(PROBLEM, ANNOTATION_MODE, OUTPUT_MODE, GENERATION_MODE, INPUT_PATH, {"outputPath":OUTPUT_PATH})
transformer = transformerGenerator(PROBLEM)

none = createTechnique("none", {})
augmentor.addTransformer(transformer(none))

for angle in [90,180,270]:
    rotate = createTechnique("rotate", {"angle":angle})
    augmentor.addTransformer(transformer(rotate))

flip = createTechnique("flip", {"flip":1})
augmentor.addTransformer(transformer(flip))

noise = createTechnique("gaussian_noise", {"mean":0, "sigma":20})
augmentor.addTransformer(transformer(noise))

zoom = createTechnique("crop", {"percentage":0.75, "startFrom":"CENTER"})
augmentor.addTransformer(transformer(zoom))

augmentor.applyAugmentation()
