from clodsa.augmentors.augmentorFactory import createAugmentor
from clodsa.transformers.transformerFactory import transformerGenerator
from clodsa.techniques.techniqueFactory import createTechnique
import cv2

PROBLEM = "instance_segmentation"
ANNOTATION_MODE = "coco"
INPUT_PATH = "train/"
GENERATION_MODE = "linear"
OUTPUT_MODE = "coco"
OUTPUT_PATH= "output/"

augmentor = createAugmentor(PROBLEM, ANNOTATION_MODE, OUTPUT_MODE, GENERATION_MODE, INPUT_PATH, {"outputPath":OUTPUT_PATH})
transformer = transformerGenerator(PROBLEM)

none = createTechnique("none", {})
augmentor.addTransformer(transformer(none))

for angle in [90,180,270]:
    rotate = createTechnique("rotate", {"angle":angle})
    augmentor.addTransformer(transformer(rotate))

flip = createTechnique("flip", {"flip":1})
augmentor.addTransformer(transformer(flip))

blur = createTechnique("gaussian_blur", {"kernel":11})
augmentor.addTransformer(transformer(blur))

sharpen = createTechnique("sharpen", {})
augmentor.addTransformer(transformer(sharpen))

gamma = createTechnique("gamma", {"gamma":1.5})
augmentor.addTransformer(transformer(gamma))

augmentor.applyAugmentation()
