# -*- coding: utf-8 -*-
from apiclient.discovery import build
import imghdr
import os
import sys
import urllib2

service = build("customsearch", "v1", developerKey="api_key")
errval = 0
orig_query = raw_input("Please input the text document path containing the desired image queries: ")
query = orig_query.replace(' ', '_')
query = query.replace('č', 'c')
query = query.replace('š', 's')
query = query.replace('ž', 'z')
query = query.replace('ć', 'c')
query = query.replace('đ', 'd')
foods = [line.rstrip('\r\n') for line in open(query)]

for food in foods:
    cnt = 0
    if not os.path.exists(food):
        os.makedirs(food)
    print("Downloading images for the food/drink type \"" + food + "\", please wait...")

    for strt in xrange(1,100,10):
        try: res = service.cse().list(
            q = food,
            cx = 'custom_search_engine_id',
            cr = 'countrySI',
            searchType = 'image',
            start = strt,
            num = 10,
            imgColorType = 'color',
            imgType = 'photo',
            fileType = 'jpg',
            rights = 'cc_publicdomain,cc_nonderived',
            safe = 'off'
            ).execute()
        except Exception as e:
            sys.stderr.write(str(e))
            errval = 1
            break
        if not 'items' in res:
            print ('No result found!\nres is: {}'.format(res))
        else:
            for item in res['items']:
                req = urllib2.Request(item['link']) 
                try: con = urllib2.urlopen(req)
                except urllib2.URLError as e:
                    break
                CHUNK = 208 * 1024
                filename = food + "/img" + str(cnt) + ".jpg"
                with open(filename, 'wb') as fp:
                    while True:
                        chunk = con.read(CHUNK)
                        if not chunk: break
                        fp.write(chunk)
                image_type = imghdr.what(filename)
                if (image_type != None):                
                    cnt = cnt + 1
                else:
                    os.remove(filename)

if errval:
    print("\nThere was an error while downloading the images - look above for details.")
else:
    print("All images have successfully finished downloading!")
