##################################################
################## SNIPPET 6.5 ###################
##################################################

##################################################
################# VALUES TO EDIT #################
## simulation parameters:
## sampling steps
sampling_steps = 5000
## adaptation steps
adaptation_steps = 25000
## burnin steps
burnin_steps = 15000
## thinning parameter
thinning_parameter = 10
##################################################
##################################################

## load Rdata file
load('../Rdata/6.4.Rdata')

## import packages
if(!require(coda)){
    install.packages("coda")
    library(coda)
}
if(!require(rjags)){
    install.packages("rjags")
    library(rjags)
}
if(!require(R2WinBUGS)){
    install.packages("R2WinBUGS")
    library(R2WinBUGS)
}
if(!require(runjags)){
    install.packages("runjags")
    library(runjags)
}

## using two chains
pseeds<-parallel.seeds("base::BaseRNG",nchain=2)
svals <- list(chain1=fun.inits(), chain2=fun.inits())
if (any(grep("RNG", names(svals$chain1)))){
    svals$chain1 <- svals$chain1[-grep("RNG", names(svals$chain1))]
}
if (any(grep("RNG",names(svals$chain2)))){
    svals$chain2 <- svals$chain2[-grep("RNG", names(svals$chain2))]
}
svals$chain1$.RNG.state<-pseeds[[1]]$.RNG.state
svals$chain1$.RNG.name<-pseeds[[1]]$.RNG.name
svals$chain2$.RNG.state<-pseeds[[2]]$.RNG.state
svals$chain2$.RNG.name<-pseeds[[2]]$.RNG.name

## execute model
Modeljags <- run.jags(
              data=fun.var, inits=svals, 
              monitor=fun.parameters,
              model=fun.model.file, method='parallel', modules='glm',   
              keep.jags.files='../model_files/jags.out',
              n.chains=2, sample=sampling_steps, adapt=adaptation_steps,
              tempdir=FALSE, burnin=burnin_steps, thin=thinning_parameter)

## print analysis results
print(Modeljags)

## save Rdata file
save.image(file='../Rdata/6.5.Rdata')