##################################################
################## SNIPPET 6.1 ###################
##################################################

import math
import numpy as np
import os
import pandas as pd
import sys


def d(x1, x2, y1, y2):
    """
    Calculate the distance between two points.
    """
    return math.sqrt((float(x1)-float(x2))**2+(float(y1)-float(y2))**2)


def process(heart, dir_, dist, dist_c):
    """
    1. Read all files for a heart;
    2. Calculate nearest neighbor distances for each point, and each pair
        of colors;
    3. Compile distances into within-channel and between-channel.
    """
    mCherry_arr, mOrange_arr, CFP_arr = [], [], []
    mCherry_dict, mOrange_dict, CFP_dict = dict(), dict(), dict()

    # read files
    for root, subdirs, files in os.walk(dir_):
        for file_ in files:
            filePath = os.path.join(root, file_)
            if heart in filePath:
                if 'mCherry' in filePath:
                    mCherry_arr.append(filePath)
                if 'mOrange' in filePath:
                    mOrange_arr.append(filePath)
                if 'CFP' in filePath:
                    CFP_arr.append(filePath)

    # process file name as required by the file name format
    for file_ in mCherry_arr:
        mCherry_dict[file_.split('/')[1].split(' (')[0]] = pd.read_csv(file_)
    for file_ in mOrange_arr:
        mOrange_dict[file_.split('/')[1].split(' (')[0]] = pd.read_csv(file_)
    for file_ in CFP_arr:
        CFP_dict[file_.split('/')[1].split(' (')[0]] = pd.read_csv(file_)

    # calculate nearest neighbor distances
    def _nn_dist(dict_1, dict_2, dist_):
        """Calculate within-channel distances."""
        for key in dict_1:
            for index, row in dict_1[key].iterrows():
                min_ = np.inf
                for index1, row1 in dict_2[key].iterrows():
                    if index != index1:
                        val = d(row['XM'], row1['XM'], row['YM'], row1['YM'])
                        if val < min_:
                            min_ = val
                if min_ == np.inf:
                    continue
                dist_.append(min_)
        return dist_

    # 1) within-channel distances
    dist = _nn_dist(mCherry_dict, mCherry_dict, dist)
    dist = _nn_dist(mOrange_dict, mOrange_dict, dist)
    dist = _nn_dist(CFP_dict, CFP_dict, dist)
    # 2) between-channel distances
    dist_c = _nn_dist(mCherry_dict, mOrange_dict, dist_c)
    dist_c = _nn_dist(CFP_dict, mCherry_dict, dist_c)
    dist_c = _nn_dist(CFP_dict, mOrange_dict, dist_c)
    # return nearest neighbor distances
    return dist, dist_c


def main():
    dir_ = sys.argv[1]
    dist, dist_c = [], []
    for heart in ['CI-1', 'CI-2', 'CI-3', 'Sham-1', 'Sham-2', 'Sham-3']:
        dist, dist_c = process(heart, dir_, dist, dist_c)

    # save to csv file 
    os.system('mkdir -p ../data')
    pd_ = pd.DataFrame({'dist':dist})
    pd_.to_csv('../data/within.csv', index=False, header=False)
    pd_c = pd.DataFrame({'dist_c':dist_c})
    pd_c.to_csv('../data/between.csv', index=False, header=False)


if __name__ == "__main__":
    main()
