##################################################
################## SNIPPET 6.7 ###################
##################################################

##################################################
################# VALUES TO EDIT #################
## Estimated parameter values from the JAGS model.
## These are hard coded here (and below), however 
## in practice, these would be computed directly
## from the JAGS output. 
a1 <- 4.6612 # EDIT VALUE!
a2 <- 4.0487 # EDIT VALUE!
s1 <- 0.71435 # EDIT VALUE!
s2 <- 0.98106 # EDIT VALUE!
beta <- -1.4614 # EDIT VALUE!
##################################################
##################################################

## load Rdata file
load('../Rdata/6.6.Rdata')

expit <- function(x){exp(x)/(1 + exp(x))}
prKin = expit(beta)

## obtain estimated distributions
detail = 0.01
grid <- seq(0, log(thresh_value), by=detail)
f.kin <- dnorm(grid, a2, s2)
f.not <- dnorm(grid, a1, s1)

## calculate probability
probability <- (f.kin*prKin) / (f.kin*prKin + f.not*(1-prKin))
index = 0
for (val in probability) {
	index = index + 1
	if (val < 0.5) break
}
distance = index*detail*thresh_value/log(thresh_value)
print(distance)

## save Rdata file
save.image(file='../Rdata/6.7.Rdata')