##################################################
################## SNIPPET 6.6 ###################
##################################################

##################################################
################# VALUES TO EDIT #################
## Estimated parameter values from the JAGS model.
## These are hard coded here (and below), however 
## in practice, these would be computed directly
## from the JAGS output. 
a1 <- 4.6612 # EDIT VALUE!
a2 <- 4.0487 # EDIT VALUE!
s1 <- 0.71435 # EDIT VALUE!
s2 <- 0.98106 # EDIT VALUE!
beta <- -1.4614 # EDIT VALUE!
##################################################
##################################################

## load Rdata file
load('../Rdata/6.5.Rdata')

## import packages
system('apt install jags')
if(!require(coda)){
    install.packages("coda")
    library(coda)
}
if(!require(rjags)){
    install.packages("rjags")
    library(rjags)
}
if(!require(R2WinBUGS)){
    install.packages("R2WinBUGS")
    library(R2WinBUGS)
}
if(!require(runjags)){
    install.packages("runjags")
    library(runjags)
}

## metrics to test convergence

## create plots folder
system('mkdir -p ../plots')

## Effective Sample Size from model results (SSeff)
print(Modeljags)

## Gelman-Rubin convergence diagnostic
png(filename="../plots/gelman.png")
gelman.diag(as.mcmc.list(Modeljags))
gelman.plot(as.mcmc.list(Modeljags))
dev.off()

## Autocorrelation
plot(Modeljags, plot.type="autocorr", file="../plots/autocorrelation.pdf")

expit <- function(x){exp(x)/(1 + exp(x))}
prKin = expit(beta)

## Q-Q plot
num <- 1000000
points_wi <- vector(, num)
points_bw <- vector(, num)
for (i in 1:num){
    rand <- runif(1)
    if (rand > prKin){
        # non kin
        while (TRUE){
            points_wi[i] <- rnorm(1, a1, s1)
            if (points_wi[i] > 1 && points_wi[i] < log(thresh_value)) break
        }
    }
    if (rand <= prKin){ 
        # kin
        while (TRUE){
            points_wi[i] <- rnorm(1, a2, s2)
            if (points_wi[i] > 1 && points_wi[i] < log(thresh_value)) break
        }
    }
    while (TRUE){
        points_bw[i] <- rnorm(1, a1, s1)
        if (points_bw[i] > 1 && points_bw[i] < log(thresh_value)) break
    }
}

## Within-Channel Q-Q plot
png(filename="../plots/within.png")
qqplot(sort(exp(points_wi)), sort(wi.dist), main= 'Within-Channel Q-Q Plot')
segments(0, 0, thresh_value,  thresh_value)
dev.off()

## Between-Channel Q-Q plot
png(filename="../plots/between.png")
qqplot(sort(exp(points_bw)), sort(bw.dist), main= 'Between-Channel Q-Q Plot')
segments(0, 0, thresh_value, thresh_value)
dev.off()

## save Rdata file
save.image(file='../Rdata/6.6.Rdata')