##################################################
################## SNIPPET 6.4 ###################
##################################################

##################################################
################# VALUES TO EDIT #################
## Distribution priors:
## Mean value of non-kin distribution (log scale)
non_kin_low = 2
non_kin_high = 6
## Mean value of kin distribution (log scale)
kin_low = 1
kin_high = 5
##################################################
##################################################

## load Rdata file
load('../Rdata/6.3.Rdata')

## data structure, including model constants, for the JAGS model
fun.var <-list(bw.dist=bw.dist, wi.dist=wi.dist,
           bw.log.dist=bw.log.dist, wi.log.dist=wi.log.dist,
           n.bw=length(bw.dist), n.wi=length(wi.dist),
           l.lim=min(bw.log.dist, wi.log.dist),
           u.lim=max(bw.log.dist, wi.log.dist),
           kin_low=kin_low, kin_high=kin_high,
           non_kin_low=non_kin_low, non_kin_high=non_kin_high)

## import packages
system('apt install jags')
if(!require(coda)){
    install.packages("coda")
    library(coda)
}
if(!require(rjags)){
    install.packages("rjags")
    library(rjags)
}
if(!require(R2WinBUGS)){
    install.packages("R2WinBUGS")
    library(R2WinBUGS)
}
if(!require(runjags)){
    install.packages("runjags")
    library(runjags)
}

fun.model = function(kin_low) {
    ## probability of within-channel distance arising from kin
    for (i in 1:n.wi) {
        pi.kin[i] <- ilogit(beta)
        P[i,1] <- (1.0 - pi.kin[i])
        P[i,2] <- pi.kin[i]
        kin[i]~ dcat(P[i, 1:2])
    }
    ## between-channel distances are all non-kin
    for (i in 1:n.bw) {
        ## T(,) specified limits of truncation
        bw.log.dist[i] ~ dnorm(alpha[1], prec[1]) %_% T(l.lim, u.lim)
    }
    ## within-channel distances are from the kin + non-kin mixture model
    for (i in 1:n.wi) {
        wi.log.dist[i] ~ dnorm(alpha[kin[i]], prec[kin[i]]) %_% T(l.lim, u.lim)
    }
    ## component precision parameters
    for (k in 1:2) {
        prec[k] <- pow(sigma2[k], -1.0)
        sigma2[k] <- pow(sigma[k], 2.0)
    }
    ## component standard deviations from half Cauchy distribution
    sigma[1] ~ dnorm(1.0, prec.se1)
    sigma[2] ~ dnorm(1.0, prec.se2)
    prec.se1 ~ dgamma(0.5, 0.5)
    prec.se2 ~ dgamma(0.5, 0.5)
    ## non-kin mean larger than kin mean
    alpha[1] ~ dunif(non_kin_low, non_kin_high) ## non-kin
    alpha[2] ~ dunif(kin_low, kin_high) ## kin
    ## we expect the odds of drawing a kin cell to be less than 1
    beta ~ dunif(-5, 0)
}

## parameters to monitor
fun.parameters <- c('beta', 'alpha', 'sigma2')

## initialize starting values for the variables for this use case
fun.inits <- function(){
    return(list(beta=-1, alpha=c((non_kin_low+non_kin_high)/2, (kin_low+kin_high)/2), sigma=c(1, 1)))
}

system('mkdir -p ../model_files')
fun.model.file <- '../model_files/cm_clonality.model'
write.model(fun.model, fun.model.file)

## save Rdata file
save.image(file='../Rdata/6.4.Rdata')