/* eqArrOverTimeEarth.c
* Alex Hegedus 12/11/19
* This script uses cspice functions to align an array with antennas described with
* Latitude Logitude (Moon ME Frame) and Altitude (deviation from average 1737.4 km Lunar radius)
* This will align the frame of the antenna on the Lunar Surface to the area of the sky
* containing the targeted Earth overhead.  This saves a number of variables as output files, most important
* being the XYZ position of each antenna in J2000 coordinates, and the J2000 coordinates of the Earth from the Moon’s perspective.
*/

// compile with  gcc eqArrOverTimeEarth.c -o eqArrOverTimeEarth -I/home/alexhege/Documents/SPICE/cspice/include /home/alexhege/Documents/SPICE/cspice/lib/cspice.a -lm -std=c99
 // gcc eqArrOverTimeEarth.c -o eqArrOverTimeEarth -I/home/alexhege/SPICE/cspice/include /home/alexhege/SPICE/cspice/lib/cspice.a -lm -std=c99

// gcc –I/myhome/cspice/include -o demo demo.c /myhome/cspice/lib/cspice.a –lm

//ILUMIN, SINCPT, SUBPNT, SUBSLR are better
//Moon_ME ref frame is mean direction toward the Earth for the X axis and the mean
//rotation direction for the Z axis. Y completes the right-handed triad




#include <stdio.h>
#include "SpiceUsr.h"


int main ()
{

  #define FILESZ 256
  #define WORDSZ 41
  #define ROOM 10

  SpiceChar time [WORDSZ];
  SpiceDouble et;

  //load kernels and stuff
  furnsh_c("lunar_furnsh.txt");

  SpiceChar moonfixref[] = "MOON_ME";

  SpiceChar icrffixref[] = "ICRF";

  //easiest format is "2/3/1996 17:18:12.002"
  //prompt_c ( "Enter time > ", WORDSZ, time );

  //12 lunar days in a year, sample each 4 times, 48 total
  char date[WORDSZ];
  int numDates = 48;
  int numsc = 1024;//7;

  SpiceDouble Longs[1024] ={0.00252775497852,0.0028944812476,0.0033144121024,0.00379526645531,0.00434588307723,0.00497638306648,0.00569835588861,0.0065250724069,0.00747172881925,0.00855572598541,0.00979698927895,0.0112183348433,0.0128458889842,0.0147095684073,0.0168436301291,0.0192873011683,0.0220854995926,0.0252896601759,0.0289586798402,0.0331600002631,0.0379708475495,0.0434796517549,0.049787672352,0.0570108595213,0.0652819854757,0.0747530849989,0.0855982500552,0.0980168298421,0.112237095105,0.128520434072,0.14716615713,0.168516998568,0.0024791848754,0.00283886460205,0.00325072660322,0.00372234147458,0.0042623781525,0.00488076326125,0.00558886357805,0.00639969497025,0.00732816164508,0.00839133010965,0.00960874287706,0.011002777685,0.0125990588294,0.014426928175,0.0165199844992,0.0189167010845,0.0216611329108,0.024803726447,0.0284022469272,0.0325228401562,0.037241248361,0.0426442024382,0.0488310161884,0.0559154118416,0.0640276104301,0.0733167254316,0.0839535036824,0.0961334639409,0.110080490795,0.126050949969,0.144338400687,0.165278991693,0.00233534108786,0.00267415198189,0.00306211750372,0.00350636899849,0.00401507242574,0.00459757846106,0.00526459437445,0.00602838084489,0.00690297732858,0.00790446012369,0.00905123787506,0.0103643899506,0.0118680539094,0.0135898691836,0.0155614851295,0.0178191427867,0.0204043410389,0.0233645994207,0.0267543315929,0.0306358455411,0.0350804888831,0.040169960337,0.0459978114574,0.0526711662426,0.0603126902227,0.0690628452225,0.0790824712447,0.0905557429328,0.103693554956,0.118737398549,0.135963800451,0.155689405857,0.00210175145198,0.00240667320076,0.00275583294579,0.00315564872818,0.00361346971734,0.00413771129896,0.00473800976146,0.00542539942441,0.00621251546457,0.00711382616805,0.0081458988775,0.00932770452285,0.0106809663334,0.0122305591408,0.0140049666132,0.0160368048247,0.0183634217838,0.0210275839417,0.0240782622995,0.0275715325627,0.0315716058908,0.0361520091877,0.041396936628,0.0474027972632,0.0542799871538,0.0621549186024,0.0711723437871,0.0814980155079,0.0933217339532,0.106860835491,0.122364187613,0.140116763466,0.00178739268649,0.00204670731819,0.00234364327325,0.00268365864696,0.00307300339416,0.00351883421209,0.00402934609045,0.00461392294665,0.00528331011528,0.00604981186226,0.00692751755436,0.00793256064132,0.00908341521108,0.0104012355691,0.0119102450841,0.0136381814469,0.0156168065278,0.0178824902043,0.0204768788892,0.0234476610502,0.0268494437897,0.0307447565995,0.0352052007396,0.0403127653688,0.0461613346192,0.0528584133173,0.0605271030717,0.0693083650518,0.0793636110497,0.0908776704536,0.104062187668,0.119159512433,0.00140434542243,0.0016080876212,0.00184138870405,0.00210853706895,0.00241444327389,0.00276473029984,0.00316583690886,0.00362513599757,0.00415107012117,0.00475330667937,0.0054429156166,0.00623257290299,0.00713679353628,0.00817219834767,0.00935781951574,0.0107154504044,0.012270046155,0.0140501823969,0.0160885805068,0.0184227090731,0.021095472621,0.0241560002571,0.0276605487301,0.0316735365089,0.0362687278827,0.0415305888518,0.0475558397292,0.0544552329952,0.0623555890811,0.0714021275053,0.0817611362095,0.0936230281621,0.000967329951357,0.00110767001875,0.00126837059962,0.00145238559386,0.00166309745265,0.00190437935264,0.00218066639029,0.0024970371051,0.00285930683025,0.00327413458647,0.00374914548411,0.00429307088326,0.00491590888825,0.00562910812672,0.00644577819131,0.00738093061213,0.00845175478961,0.00967793395947,0.011082006998,0.0126897827179,0.0145308142701,0.0166389423716,0.0190529173451,0.0218171114037,0.0249823342735,0.0286067671472,0.0327570321356,0.0375094168735,0.0429512767936,0.0491826408398,0.0563180501386,0.0644886634238,0.000493140532737,0.000564685278664,0.000646609724351,0.000740419754903,0.000847839728982,0.000970844174915,0.00111169408527,0.00127297847704,0.00145766198136,0.00166913933758,0.00191129779322,0.00218858855707,0.00250610861851,0.0028696944373,0.00328602922581,0.00376276579574,0.00430866722742,0.0049337679474,0.00564955817519,0.00646919512938,0.00740774487566,0.008482459262,0.00971309303158,0.0111222669424,0.0127358835683,0.0145836034241,0.0166993901673,0.0191221348969,0.0218963710263,0.0250730928688,0.0287106929844,0.0328760355158,1.54780352174e-19,1.77235859753e-19,2.02949208613e-19,2.3239304582e-19,2.6610859e-19,3.04715579685e-19,3.48923664969e-19,3.99545451866e-19,4.57511439129e-19,5.23887122121e-19,5.99892578088e-19,6.86924892881e-19,7.86583841334e-19,9.00701293343e-19,1.03137488618e-18,1.181006582e-18,1.35234681918e-18,1.5485450693e-18,1.77320772869e-18,2.0304644091e-18,2.32504384562e-18,2.66236081748e-18,3.04861567914e-18,3.49090833147e-18,3.99736872774e-18,4.57730631351e-18,5.24138114713e-18,6.00179984644e-18,6.87253996332e-18,7.86960691058e-18,9.01132816362e-18,1.03186901449e-17,-0.000493140532737,-0.000564685278664,-0.000646609724351,-0.000740419754903,-0.000847839728982,-0.000970844174915,-0.00111169408527,-0.00127297847704,-0.00145766198136,-0.00166913933758,-0.00191129779322,-0.00218858855707,-0.00250610861851,-0.0028696944373,-0.00328602922581,-0.00376276579574,-0.00430866722742,-0.0049337679474,-0.00564955817519,-0.00646919512938,-0.00740774487566,-0.008482459262,-0.00971309303158,-0.0111222669424,-0.0127358835683,-0.0145836034241,-0.0166993901673,-0.0191221348969,-0.0218963710263,-0.0250730928688,-0.0287106929844,-0.0328760355158,-0.000967329951357,-0.00110767001875,-0.00126837059962,-0.00145238559386,-0.00166309745265,-0.00190437935264,-0.00218066639029,-0.0024970371051,-0.00285930683025,-0.00327413458647,-0.00374914548411,-0.00429307088326,-0.00491590888825,-0.00562910812672,-0.00644577819131,-0.00738093061213,-0.00845175478961,-0.00967793395947,-0.011082006998,-0.0126897827179,-0.0145308142701,-0.0166389423716,-0.0190529173451,-0.0218171114037,-0.0249823342735,-0.0286067671472,-0.0327570321356,-0.0375094168735,-0.0429512767936,-0.0491826408398,-0.0563180501386,-0.0644886634238,-0.00140434542243,-0.0016080876212,-0.00184138870405,-0.00210853706895,-0.00241444327389,-0.00276473029984,-0.00316583690886,-0.00362513599757,-0.00415107012117,-0.00475330667937,-0.0054429156166,-0.00623257290299,-0.00713679353628,-0.00817219834767,-0.00935781951574,-0.0107154504044,-0.012270046155,-0.0140501823969,-0.0160885805068,-0.0184227090731,-0.021095472621,-0.0241560002571,-0.0276605487301,-0.0316735365089,-0.0362687278827,-0.0415305888518,-0.0475558397292,-0.0544552329952,-0.0623555890811,-0.0714021275053,-0.0817611362095,-0.0936230281621,-0.00178739268649,-0.00204670731819,-0.00234364327325,-0.00268365864696,-0.00307300339416,-0.00351883421209,-0.00402934609045,-0.00461392294665,-0.00528331011528,-0.00604981186226,-0.00692751755436,-0.00793256064132,-0.00908341521108,-0.0104012355691,-0.0119102450841,-0.0136381814469,-0.0156168065278,-0.0178824902043,-0.0204768788892,-0.0234476610502,-0.0268494437897,-0.0307447565995,-0.0352052007396,-0.0403127653688,-0.0461613346192,-0.0528584133173,-0.0605271030717,-0.0693083650518,-0.0793636110497,-0.0908776704536,-0.104062187668,-0.119159512433,-0.00210175145198,-0.00240667320076,-0.00275583294579,-0.00315564872818,-0.00361346971734,-0.00413771129896,-0.00473800976146,-0.00542539942441,-0.00621251546457,-0.00711382616805,-0.0081458988775,-0.00932770452285,-0.0106809663334,-0.0122305591408,-0.0140049666132,-0.0160368048247,-0.0183634217838,-0.0210275839417,-0.0240782622995,-0.0275715325627,-0.0315716058908,-0.0361520091877,-0.041396936628,-0.0474027972632,-0.0542799871538,-0.0621549186024,-0.0711723437871,-0.0814980155079,-0.0933217339532,-0.106860835491,-0.122364187613,-0.140116763466,-0.00233534108786,-0.00267415198189,-0.00306211750372,-0.00350636899849,-0.00401507242574,-0.00459757846106,-0.00526459437445,-0.00602838084489,-0.00690297732858,-0.00790446012369,-0.00905123787506,-0.0103643899506,-0.0118680539094,-0.0135898691836,-0.0155614851295,-0.0178191427867,-0.0204043410389,-0.0233645994207,-0.0267543315929,-0.0306358455411,-0.0350804888831,-0.040169960337,-0.0459978114574,-0.0526711662426,-0.0603126902227,-0.0690628452225,-0.0790824712447,-0.0905557429328,-0.103693554956,-0.118737398549,-0.135963800451,-0.155689405857,-0.0024791848754,-0.00283886460205,-0.00325072660322,-0.00372234147458,-0.0042623781525,-0.00488076326125,-0.00558886357805,-0.00639969497025,-0.00732816164508,-0.00839133010965,-0.00960874287706,-0.011002777685,-0.0125990588294,-0.014426928175,-0.0165199844992,-0.0189167010845,-0.0216611329108,-0.024803726447,-0.0284022469272,-0.0325228401562,-0.037241248361,-0.0426442024382,-0.0488310161884,-0.0559154118416,-0.0640276104301,-0.0733167254316,-0.0839535036824,-0.0961334639409,-0.110080490795,-0.126050949969,-0.144338400687,-0.165278991693,-0.00252775497852,-0.0028944812476,-0.0033144121024,-0.00379526645531,-0.00434588307723,-0.00497638306648,-0.00569835588861,-0.0065250724069,-0.00747172881925,-0.00855572598541,-0.00979698927895,-0.0112183348433,-0.0128458889842,-0.0147095684073,-0.0168436301291,-0.0192873011683,-0.0220854995926,-0.0252896601759,-0.0289586798402,-0.0331600002631,-0.0379708475495,-0.0434796517549,-0.049787672352,-0.0570108595213,-0.0652819854757,-0.0747530849989,-0.0855982500552,-0.0980168298421,-0.112237095105,-0.128520434072,-0.14716615713,-0.168516998568,-0.0024791848754,-0.00283886460205,-0.00325072660322,-0.00372234147458,-0.0042623781525,-0.00488076326125,-0.00558886357805,-0.00639969497025,-0.00732816164508,-0.00839133010965,-0.00960874287706,-0.011002777685,-0.0125990588294,-0.014426928175,-0.0165199844992,-0.0189167010845,-0.0216611329108,-0.024803726447,-0.0284022469272,-0.0325228401562,-0.037241248361,-0.0426442024382,-0.0488310161884,-0.0559154118416,-0.0640276104301,-0.0733167254316,-0.0839535036824,-0.0961334639409,-0.110080490795,-0.126050949969,-0.144338400687,-0.165278991693,-0.00233534108786,-0.00267415198189,-0.00306211750372,-0.00350636899849,-0.00401507242574,-0.00459757846106,-0.00526459437445,-0.00602838084489,-0.00690297732858,-0.00790446012369,-0.00905123787506,-0.0103643899506,-0.0118680539094,-0.0135898691836,-0.0155614851295,-0.0178191427867,-0.0204043410389,-0.0233645994207,-0.0267543315929,-0.0306358455411,-0.0350804888831,-0.040169960337,-0.0459978114574,-0.0526711662426,-0.0603126902227,-0.0690628452225,-0.0790824712447,-0.0905557429328,-0.103693554956,-0.118737398549,-0.135963800451,-0.155689405857,-0.00210175145198,-0.00240667320076,-0.00275583294579,-0.00315564872818,-0.00361346971734,-0.00413771129896,-0.00473800976146,-0.00542539942441,-0.00621251546457,-0.00711382616805,-0.0081458988775,-0.00932770452285,-0.0106809663334,-0.0122305591408,-0.0140049666132,-0.0160368048247,-0.0183634217838,-0.0210275839417,-0.0240782622995,-0.0275715325627,-0.0315716058908,-0.0361520091877,-0.041396936628,-0.0474027972632,-0.0542799871538,-0.0621549186024,-0.0711723437871,-0.0814980155079,-0.0933217339532,-0.106860835491,-0.122364187613,-0.140116763466,-0.00178739268649,-0.00204670731819,-0.00234364327325,-0.00268365864696,-0.00307300339416,-0.00351883421209,-0.00402934609045,-0.00461392294665,-0.00528331011528,-0.00604981186226,-0.00692751755436,-0.00793256064132,-0.00908341521108,-0.0104012355691,-0.0119102450841,-0.0136381814469,-0.0156168065278,-0.0178824902043,-0.0204768788892,-0.0234476610502,-0.0268494437897,-0.0307447565995,-0.0352052007396,-0.0403127653688,-0.0461613346192,-0.0528584133173,-0.0605271030717,-0.0693083650518,-0.0793636110497,-0.0908776704536,-0.104062187668,-0.119159512433,-0.00140434542243,-0.0016080876212,-0.00184138870405,-0.00210853706895,-0.00241444327389,-0.00276473029984,-0.00316583690886,-0.00362513599757,-0.00415107012117,-0.00475330667937,-0.0054429156166,-0.00623257290299,-0.00713679353628,-0.00817219834767,-0.00935781951574,-0.0107154504044,-0.012270046155,-0.0140501823969,-0.0160885805068,-0.0184227090731,-0.021095472621,-0.0241560002571,-0.0276605487301,-0.0316735365089,-0.0362687278827,-0.0415305888518,-0.0475558397292,-0.0544552329952,-0.0623555890811,-0.0714021275053,-0.0817611362095,-0.0936230281621,-0.000967329951357,-0.00110767001875,-0.00126837059962,-0.00145238559386,-0.00166309745265,-0.00190437935264,-0.00218066639029,-0.0024970371051,-0.00285930683025,-0.00327413458647,-0.00374914548411,-0.00429307088326,-0.00491590888825,-0.00562910812672,-0.00644577819131,-0.00738093061213,-0.00845175478961,-0.00967793395947,-0.011082006998,-0.0126897827179,-0.0145308142701,-0.0166389423716,-0.0190529173451,-0.0218171114037,-0.0249823342735,-0.0286067671472,-0.0327570321356,-0.0375094168735,-0.0429512767936,-0.0491826408398,-0.0563180501386,-0.0644886634238,-0.000493140532737,-0.000564685278664,-0.000646609724351,-0.000740419754903,-0.000847839728982,-0.000970844174915,-0.00111169408527,-0.00127297847704,-0.00145766198136,-0.00166913933758,-0.00191129779322,-0.00218858855707,-0.00250610861851,-0.0028696944373,-0.00328602922581,-0.00376276579574,-0.00430866722742,-0.0049337679474,-0.00564955817519,-0.00646919512938,-0.00740774487566,-0.008482459262,-0.00971309303158,-0.0111222669424,-0.0127358835683,-0.0145836034241,-0.0166993901673,-0.0191221348969,-0.0218963710263,-0.0250730928688,-0.0287106929844,-0.0328760355158,-4.64341056521e-19,-5.3170757926e-19,-6.08847625839e-19,-6.97179137461e-19,-7.9832577e-19,-9.14146739055e-19,-1.04677099491e-18,-1.1986363556e-18,-1.37253431739e-18,-1.57166136636e-18,-1.79967773426e-18,-2.06077467864e-18,-2.359751524e-18,-2.70210388003e-18,-3.09412465855e-18,-3.54301974599e-18,-4.05704045755e-18,-4.6456352079e-18,-5.31962318608e-18,-6.09139322729e-18,-6.97513153687e-18,-7.98708245244e-18,-9.14584703743e-18,-1.04727249944e-17,-1.19921061832e-17,-1.37319189405e-17,-1.57241434414e-17,-1.80053995393e-17,-2.061761989e-17,-2.36088207318e-17,-2.70339844909e-17,-3.09560704347e-17,0.000493140532737,0.000564685278664,0.000646609724351,0.000740419754903,0.000847839728982,0.000970844174915,0.00111169408527,0.00127297847704,0.00145766198136,0.00166913933758,0.00191129779322,0.00218858855707,0.00250610861851,0.0028696944373,0.00328602922581,0.00376276579574,0.00430866722742,0.0049337679474,0.00564955817519,0.00646919512938,0.00740774487566,0.008482459262,0.00971309303158,0.0111222669424,0.0127358835683,0.0145836034241,0.0166993901673,0.0191221348969,0.0218963710263,0.0250730928688,0.0287106929844,0.0328760355158,0.000967329951357,0.00110767001875,0.00126837059962,0.00145238559386,0.00166309745265,0.00190437935264,0.00218066639029,0.0024970371051,0.00285930683025,0.00327413458647,0.00374914548411,0.00429307088326,0.00491590888825,0.00562910812672,0.00644577819131,0.00738093061213,0.00845175478961,0.00967793395947,0.011082006998,0.0126897827179,0.0145308142701,0.0166389423716,0.0190529173451,0.0218171114037,0.0249823342735,0.0286067671472,0.0327570321356,0.0375094168735,0.0429512767936,0.0491826408398,0.0563180501386,0.0644886634238,0.00140434542243,0.0016080876212,0.00184138870405,0.00210853706895,0.00241444327389,0.00276473029984,0.00316583690886,0.00362513599757,0.00415107012117,0.00475330667937,0.0054429156166,0.00623257290299,0.00713679353628,0.00817219834767,0.00935781951574,0.0107154504044,0.012270046155,0.0140501823969,0.0160885805068,0.0184227090731,0.021095472621,0.0241560002571,0.0276605487301,0.0316735365089,0.0362687278827,0.0415305888518,0.0475558397292,0.0544552329952,0.0623555890811,0.0714021275053,0.0817611362095,0.0936230281621,0.00178739268649,0.00204670731819,0.00234364327325,0.00268365864696,0.00307300339416,0.00351883421209,0.00402934609045,0.00461392294665,0.00528331011528,0.00604981186226,0.00692751755436,0.00793256064132,0.00908341521108,0.0104012355691,0.0119102450841,0.0136381814469,0.0156168065278,0.0178824902043,0.0204768788892,0.0234476610502,0.0268494437897,0.0307447565995,0.0352052007396,0.0403127653688,0.0461613346192,0.0528584133173,0.0605271030717,0.0693083650518,0.0793636110497,0.0908776704536,0.104062187668,0.119159512433,0.00210175145198,0.00240667320076,0.00275583294579,0.00315564872818,0.00361346971734,0.00413771129896,0.00473800976146,0.00542539942441,0.00621251546457,0.00711382616805,0.0081458988775,0.00932770452285,0.0106809663334,0.0122305591408,0.0140049666132,0.0160368048247,0.0183634217838,0.0210275839417,0.0240782622995,0.0275715325627,0.0315716058908,0.0361520091877,0.041396936628,0.0474027972632,0.0542799871538,0.0621549186024,0.0711723437871,0.0814980155079,0.0933217339532,0.106860835491,0.122364187613,0.140116763466,0.00233534108786,0.00267415198189,0.00306211750372,0.00350636899849,0.00401507242574,0.00459757846106,0.00526459437445,0.00602838084489,0.00690297732858,0.00790446012369,0.00905123787506,0.0103643899506,0.0118680539094,0.0135898691836,0.0155614851295,0.0178191427867,0.0204043410389,0.0233645994207,0.0267543315929,0.0306358455411,0.0350804888831,0.040169960337,0.0459978114574,0.0526711662426,0.0603126902227,0.0690628452225,0.0790824712447,0.0905557429328,0.103693554956,0.118737398549,0.135963800451,0.155689405857,0.0024791848754,0.00283886460205,0.00325072660322,0.00372234147458,0.0042623781525,0.00488076326125,0.00558886357805,0.00639969497025,0.00732816164508,0.00839133010965,0.00960874287706,0.011002777685,0.0125990588294,0.014426928175,0.0165199844992,0.0189167010845,0.0216611329108,0.024803726447,0.0284022469272,0.0325228401562,0.037241248361,0.0426442024382,0.0488310161884,0.0559154118416,0.0640276104301,0.0733167254316,0.0839535036824,0.0961334639409,0.110080490795,0.126050949969,0.144338400687,0.165278991693};

  SpiceDouble Lats[1024] = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.000493140532737,0.000564685278664,0.000646609724351,0.000740419754903,0.000847839728982,0.000970844174915,0.00111169408527,0.00127297847704,0.00145766198136,0.00166913933758,0.00191129779322,0.00218858855707,0.00250610861851,0.0028696944373,0.00328602922581,0.00376276579574,0.00430866722742,0.0049337679474,0.00564955817519,0.00646919512938,0.00740774487566,0.008482459262,0.00971309303158,0.0111222669424,0.0127358835683,0.0145836034241,0.0166993901673,0.0191221348969,0.0218963710263,0.0250730928688,0.0287106929844,0.0328760355158,0.000967329951357,0.00110767001875,0.00126837059962,0.00145238559386,0.00166309745265,0.00190437935264,0.00218066639029,0.0024970371051,0.00285930683025,0.00327413458647,0.00374914548411,0.00429307088326,0.00491590888825,0.00562910812672,0.00644577819131,0.00738093061213,0.00845175478961,0.00967793395947,0.011082006998,0.0126897827179,0.0145308142701,0.0166389423716,0.0190529173451,0.0218171114037,0.0249823342735,0.0286067671472,0.0327570321356,0.0375094168735,0.0429512767936,0.0491826408398,0.0563180501386,0.0644886634238,0.00140434542243,0.0016080876212,0.00184138870405,0.00210853706895,0.00241444327389,0.00276473029984,0.00316583690886,0.00362513599757,0.00415107012117,0.00475330667937,0.0054429156166,0.00623257290299,0.00713679353628,0.00817219834767,0.00935781951574,0.0107154504044,0.012270046155,0.0140501823969,0.0160885805068,0.0184227090731,0.021095472621,0.0241560002571,0.0276605487301,0.0316735365089,0.0362687278827,0.0415305888518,0.0475558397292,0.0544552329952,0.0623555890811,0.0714021275053,0.0817611362095,0.0936230281621,0.00178739268649,0.00204670731819,0.00234364327325,0.00268365864696,0.00307300339416,0.00351883421209,0.00402934609045,0.00461392294665,0.00528331011528,0.00604981186226,0.00692751755436,0.00793256064132,0.00908341521108,0.0104012355691,0.0119102450841,0.0136381814469,0.0156168065278,0.0178824902043,0.0204768788892,0.0234476610502,0.0268494437897,0.0307447565995,0.0352052007396,0.0403127653688,0.0461613346192,0.0528584133173,0.0605271030717,0.0693083650518,0.0793636110497,0.0908776704536,0.104062187668,0.119159512433,0.00210175145198,0.00240667320076,0.00275583294579,0.00315564872818,0.00361346971734,0.00413771129896,0.00473800976146,0.00542539942441,0.00621251546457,0.00711382616805,0.0081458988775,0.00932770452285,0.0106809663334,0.0122305591408,0.0140049666132,0.0160368048247,0.0183634217838,0.0210275839417,0.0240782622995,0.0275715325627,0.0315716058908,0.0361520091877,0.041396936628,0.0474027972632,0.0542799871538,0.0621549186024,0.0711723437871,0.0814980155079,0.0933217339532,0.106860835491,0.122364187613,0.140116763466,0.00233534108786,0.00267415198189,0.00306211750372,0.00350636899849,0.00401507242574,0.00459757846106,0.00526459437445,0.00602838084489,0.00690297732858,0.00790446012369,0.00905123787506,0.0103643899506,0.0118680539094,0.0135898691836,0.0155614851295,0.0178191427867,0.0204043410389,0.0233645994207,0.0267543315929,0.0306358455411,0.0350804888831,0.040169960337,0.0459978114574,0.0526711662426,0.0603126902227,0.0690628452225,0.0790824712447,0.0905557429328,0.103693554956,0.118737398549,0.135963800451,0.155689405857,0.0024791848754,0.00283886460205,0.00325072660322,0.00372234147458,0.0042623781525,0.00488076326125,0.00558886357805,0.00639969497025,0.00732816164508,0.00839133010965,0.00960874287706,0.011002777685,0.0125990588294,0.014426928175,0.0165199844992,0.0189167010845,0.0216611329108,0.024803726447,0.0284022469272,0.0325228401562,0.037241248361,0.0426442024382,0.0488310161884,0.0559154118416,0.0640276104301,0.0733167254316,0.0839535036824,0.0961334639409,0.110080490795,0.126050949969,0.144338400687,0.165278991693,0.00252775497852,0.0028944812476,0.0033144121024,0.00379526645531,0.00434588307723,0.00497638306648,0.00569835588861,0.0065250724069,0.00747172881925,0.00855572598541,0.00979698927895,0.0112183348433,0.0128458889842,0.0147095684073,0.0168436301291,0.0192873011683,0.0220854995926,0.0252896601759,0.0289586798402,0.0331600002631,0.0379708475495,0.0434796517549,0.049787672352,0.0570108595213,0.0652819854757,0.0747530849989,0.0855982500552,0.0980168298421,0.112237095105,0.128520434072,0.14716615713,0.168516998568,0.0024791848754,0.00283886460205,0.00325072660322,0.00372234147458,0.0042623781525,0.00488076326125,0.00558886357805,0.00639969497025,0.00732816164508,0.00839133010965,0.00960874287706,0.011002777685,0.0125990588294,0.014426928175,0.0165199844992,0.0189167010845,0.0216611329108,0.024803726447,0.0284022469272,0.0325228401562,0.037241248361,0.0426442024382,0.0488310161884,0.0559154118416,0.0640276104301,0.0733167254316,0.0839535036824,0.0961334639409,0.110080490795,0.126050949969,0.144338400687,0.165278991693,0.00233534108786,0.00267415198189,0.00306211750372,0.00350636899849,0.00401507242574,0.00459757846106,0.00526459437445,0.00602838084489,0.00690297732858,0.00790446012369,0.00905123787506,0.0103643899506,0.0118680539094,0.0135898691836,0.0155614851295,0.0178191427867,0.0204043410389,0.0233645994207,0.0267543315929,0.0306358455411,0.0350804888831,0.040169960337,0.0459978114574,0.0526711662426,0.0603126902227,0.0690628452225,0.0790824712447,0.0905557429328,0.103693554956,0.118737398549,0.135963800451,0.155689405857,0.00210175145198,0.00240667320076,0.00275583294579,0.00315564872818,0.00361346971734,0.00413771129896,0.00473800976146,0.00542539942441,0.00621251546457,0.00711382616805,0.0081458988775,0.00932770452285,0.0106809663334,0.0122305591408,0.0140049666132,0.0160368048247,0.0183634217838,0.0210275839417,0.0240782622995,0.0275715325627,0.0315716058908,0.0361520091877,0.041396936628,0.0474027972632,0.0542799871538,0.0621549186024,0.0711723437871,0.0814980155079,0.0933217339532,0.106860835491,0.122364187613,0.140116763466,0.00178739268649,0.00204670731819,0.00234364327325,0.00268365864696,0.00307300339416,0.00351883421209,0.00402934609045,0.00461392294665,0.00528331011528,0.00604981186226,0.00692751755436,0.00793256064132,0.00908341521108,0.0104012355691,0.0119102450841,0.0136381814469,0.0156168065278,0.0178824902043,0.0204768788892,0.0234476610502,0.0268494437897,0.0307447565995,0.0352052007396,0.0403127653688,0.0461613346192,0.0528584133173,0.0605271030717,0.0693083650518,0.0793636110497,0.0908776704536,0.104062187668,0.119159512433,0.00140434542243,0.0016080876212,0.00184138870405,0.00210853706895,0.00241444327389,0.00276473029984,0.00316583690886,0.00362513599757,0.00415107012117,0.00475330667937,0.0054429156166,0.00623257290299,0.00713679353628,0.00817219834767,0.00935781951574,0.0107154504044,0.012270046155,0.0140501823969,0.0160885805068,0.0184227090731,0.021095472621,0.0241560002571,0.0276605487301,0.0316735365089,0.0362687278827,0.0415305888518,0.0475558397292,0.0544552329952,0.0623555890811,0.0714021275053,0.0817611362095,0.0936230281621,0.000967329951357,0.00110767001875,0.00126837059962,0.00145238559386,0.00166309745265,0.00190437935264,0.00218066639029,0.0024970371051,0.00285930683025,0.00327413458647,0.00374914548411,0.00429307088326,0.00491590888825,0.00562910812672,0.00644577819131,0.00738093061213,0.00845175478961,0.00967793395947,0.011082006998,0.0126897827179,0.0145308142701,0.0166389423716,0.0190529173451,0.0218171114037,0.0249823342735,0.0286067671472,0.0327570321356,0.0375094168735,0.0429512767936,0.0491826408398,0.0563180501386,0.0644886634238,0.000493140532737,0.000564685278664,0.000646609724351,0.000740419754903,0.000847839728982,0.000970844174915,0.00111169408527,0.00127297847704,0.00145766198136,0.00166913933758,0.00191129779322,0.00218858855707,0.00250610861851,0.0028696944373,0.00328602922581,0.00376276579574,0.00430866722742,0.0049337679474,0.00564955817519,0.00646919512938,0.00740774487566,0.008482459262,0.00971309303158,0.0111222669424,0.0127358835683,0.0145836034241,0.0166993901673,0.0191221348969,0.0218963710263,0.0250730928688,0.0287106929844,0.0328760355158,3.09560704347e-19,3.54471719506e-19,4.05898417226e-19,4.64786091641e-19,5.3221718e-19,6.0943115937e-19,6.97847329939e-19,7.99090903731e-19,9.15022878259e-19,1.04777424424e-18,1.19978515618e-18,1.37384978576e-18,1.57316768267e-18,1.80140258669e-18,2.06274977237e-18,2.36201316399e-18,2.70469363837e-18,3.0970901386e-18,3.54641545738e-18,4.06092881819e-18,4.65008769125e-18,5.32472163496e-18,6.09723135829e-18,6.98181666293e-18,7.99473745548e-18,9.15461262702e-18,1.04827622943e-17,1.20035996929e-17,1.37450799266e-17,1.57392138212e-17,1.80226563272e-17,2.06373802898e-17,-0.000493140532737,-0.000564685278664,-0.000646609724351,-0.000740419754903,-0.000847839728982,-0.000970844174915,-0.00111169408527,-0.00127297847704,-0.00145766198136,-0.00166913933758,-0.00191129779322,-0.00218858855707,-0.00250610861851,-0.0028696944373,-0.00328602922581,-0.00376276579574,-0.00430866722742,-0.0049337679474,-0.00564955817519,-0.00646919512938,-0.00740774487566,-0.008482459262,-0.00971309303158,-0.0111222669424,-0.0127358835683,-0.0145836034241,-0.0166993901673,-0.0191221348969,-0.0218963710263,-0.0250730928688,-0.0287106929844,-0.0328760355158,-0.000967329951357,-0.00110767001875,-0.00126837059962,-0.00145238559386,-0.00166309745265,-0.00190437935264,-0.00218066639029,-0.0024970371051,-0.00285930683025,-0.00327413458647,-0.00374914548411,-0.00429307088326,-0.00491590888825,-0.00562910812672,-0.00644577819131,-0.00738093061213,-0.00845175478961,-0.00967793395947,-0.011082006998,-0.0126897827179,-0.0145308142701,-0.0166389423716,-0.0190529173451,-0.0218171114037,-0.0249823342735,-0.0286067671472,-0.0327570321356,-0.0375094168735,-0.0429512767936,-0.0491826408398,-0.0563180501386,-0.0644886634238,-0.00140434542243,-0.0016080876212,-0.00184138870405,-0.00210853706895,-0.00241444327389,-0.00276473029984,-0.00316583690886,-0.00362513599757,-0.00415107012117,-0.00475330667937,-0.0054429156166,-0.00623257290299,-0.00713679353628,-0.00817219834767,-0.00935781951574,-0.0107154504044,-0.012270046155,-0.0140501823969,-0.0160885805068,-0.0184227090731,-0.021095472621,-0.0241560002571,-0.0276605487301,-0.0316735365089,-0.0362687278827,-0.0415305888518,-0.0475558397292,-0.0544552329952,-0.0623555890811,-0.0714021275053,-0.0817611362095,-0.0936230281621,-0.00178739268649,-0.00204670731819,-0.00234364327325,-0.00268365864696,-0.00307300339416,-0.00351883421209,-0.00402934609045,-0.00461392294665,-0.00528331011528,-0.00604981186226,-0.00692751755436,-0.00793256064132,-0.00908341521108,-0.0104012355691,-0.0119102450841,-0.0136381814469,-0.0156168065278,-0.0178824902043,-0.0204768788892,-0.0234476610502,-0.0268494437897,-0.0307447565995,-0.0352052007396,-0.0403127653688,-0.0461613346192,-0.0528584133173,-0.0605271030717,-0.0693083650518,-0.0793636110497,-0.0908776704536,-0.104062187668,-0.119159512433,-0.00210175145198,-0.00240667320076,-0.00275583294579,-0.00315564872818,-0.00361346971734,-0.00413771129896,-0.00473800976146,-0.00542539942441,-0.00621251546457,-0.00711382616805,-0.0081458988775,-0.00932770452285,-0.0106809663334,-0.0122305591408,-0.0140049666132,-0.0160368048247,-0.0183634217838,-0.0210275839417,-0.0240782622995,-0.0275715325627,-0.0315716058908,-0.0361520091877,-0.041396936628,-0.0474027972632,-0.0542799871538,-0.0621549186024,-0.0711723437871,-0.0814980155079,-0.0933217339532,-0.106860835491,-0.122364187613,-0.140116763466,-0.00233534108786,-0.00267415198189,-0.00306211750372,-0.00350636899849,-0.00401507242574,-0.00459757846106,-0.00526459437445,-0.00602838084489,-0.00690297732858,-0.00790446012369,-0.00905123787506,-0.0103643899506,-0.0118680539094,-0.0135898691836,-0.0155614851295,-0.0178191427867,-0.0204043410389,-0.0233645994207,-0.0267543315929,-0.0306358455411,-0.0350804888831,-0.040169960337,-0.0459978114574,-0.0526711662426,-0.0603126902227,-0.0690628452225,-0.0790824712447,-0.0905557429328,-0.103693554956,-0.118737398549,-0.135963800451,-0.155689405857,-0.0024791848754,-0.00283886460205,-0.00325072660322,-0.00372234147458,-0.0042623781525,-0.00488076326125,-0.00558886357805,-0.00639969497025,-0.00732816164508,-0.00839133010965,-0.00960874287706,-0.011002777685,-0.0125990588294,-0.014426928175,-0.0165199844992,-0.0189167010845,-0.0216611329108,-0.024803726447,-0.0284022469272,-0.0325228401562,-0.037241248361,-0.0426442024382,-0.0488310161884,-0.0559154118416,-0.0640276104301,-0.0733167254316,-0.0839535036824,-0.0961334639409,-0.110080490795,-0.126050949969,-0.144338400687,-0.165278991693,-0.00252775497852,-0.0028944812476,-0.0033144121024,-0.00379526645531,-0.00434588307723,-0.00497638306648,-0.00569835588861,-0.0065250724069,-0.00747172881925,-0.00855572598541,-0.00979698927895,-0.0112183348433,-0.0128458889842,-0.0147095684073,-0.0168436301291,-0.0192873011683,-0.0220854995926,-0.0252896601759,-0.0289586798402,-0.0331600002631,-0.0379708475495,-0.0434796517549,-0.049787672352,-0.0570108595213,-0.0652819854757,-0.0747530849989,-0.0855982500552,-0.0980168298421,-0.112237095105,-0.128520434072,-0.14716615713,-0.168516998568,-0.0024791848754,-0.00283886460205,-0.00325072660322,-0.00372234147458,-0.0042623781525,-0.00488076326125,-0.00558886357805,-0.00639969497025,-0.00732816164508,-0.00839133010965,-0.00960874287706,-0.011002777685,-0.0125990588294,-0.014426928175,-0.0165199844992,-0.0189167010845,-0.0216611329108,-0.024803726447,-0.0284022469272,-0.0325228401562,-0.037241248361,-0.0426442024382,-0.0488310161884,-0.0559154118416,-0.0640276104301,-0.0733167254316,-0.0839535036824,-0.0961334639409,-0.110080490795,-0.126050949969,-0.144338400687,-0.165278991693,-0.00233534108786,-0.00267415198189,-0.00306211750372,-0.00350636899849,-0.00401507242574,-0.00459757846106,-0.00526459437445,-0.00602838084489,-0.00690297732858,-0.00790446012369,-0.00905123787506,-0.0103643899506,-0.0118680539094,-0.0135898691836,-0.0155614851295,-0.0178191427867,-0.0204043410389,-0.0233645994207,-0.0267543315929,-0.0306358455411,-0.0350804888831,-0.040169960337,-0.0459978114574,-0.0526711662426,-0.0603126902227,-0.0690628452225,-0.0790824712447,-0.0905557429328,-0.103693554956,-0.118737398549,-0.135963800451,-0.155689405857,-0.00210175145198,-0.00240667320076,-0.00275583294579,-0.00315564872818,-0.00361346971734,-0.00413771129896,-0.00473800976146,-0.00542539942441,-0.00621251546457,-0.00711382616805,-0.0081458988775,-0.00932770452285,-0.0106809663334,-0.0122305591408,-0.0140049666132,-0.0160368048247,-0.0183634217838,-0.0210275839417,-0.0240782622995,-0.0275715325627,-0.0315716058908,-0.0361520091877,-0.041396936628,-0.0474027972632,-0.0542799871538,-0.0621549186024,-0.0711723437871,-0.0814980155079,-0.0933217339532,-0.106860835491,-0.122364187613,-0.140116763466,-0.00178739268649,-0.00204670731819,-0.00234364327325,-0.00268365864696,-0.00307300339416,-0.00351883421209,-0.00402934609045,-0.00461392294665,-0.00528331011528,-0.00604981186226,-0.00692751755436,-0.00793256064132,-0.00908341521108,-0.0104012355691,-0.0119102450841,-0.0136381814469,-0.0156168065278,-0.0178824902043,-0.0204768788892,-0.0234476610502,-0.0268494437897,-0.0307447565995,-0.0352052007396,-0.0403127653688,-0.0461613346192,-0.0528584133173,-0.0605271030717,-0.0693083650518,-0.0793636110497,-0.0908776704536,-0.104062187668,-0.119159512433,-0.00140434542243,-0.0016080876212,-0.00184138870405,-0.00210853706895,-0.00241444327389,-0.00276473029984,-0.00316583690886,-0.00362513599757,-0.00415107012117,-0.00475330667937,-0.0054429156166,-0.00623257290299,-0.00713679353628,-0.00817219834767,-0.00935781951574,-0.0107154504044,-0.012270046155,-0.0140501823969,-0.0160885805068,-0.0184227090731,-0.021095472621,-0.0241560002571,-0.0276605487301,-0.0316735365089,-0.0362687278827,-0.0415305888518,-0.0475558397292,-0.0544552329952,-0.0623555890811,-0.0714021275053,-0.0817611362095,-0.0936230281621,-0.000967329951357,-0.00110767001875,-0.00126837059962,-0.00145238559386,-0.00166309745265,-0.00190437935264,-0.00218066639029,-0.0024970371051,-0.00285930683025,-0.00327413458647,-0.00374914548411,-0.00429307088326,-0.00491590888825,-0.00562910812672,-0.00644577819131,-0.00738093061213,-0.00845175478961,-0.00967793395947,-0.011082006998,-0.0126897827179,-0.0145308142701,-0.0166389423716,-0.0190529173451,-0.0218171114037,-0.0249823342735,-0.0286067671472,-0.0327570321356,-0.0375094168735,-0.0429512767936,-0.0491826408398,-0.0563180501386,-0.0644886634238,-0.000493140532737,-0.000564685278664,-0.000646609724351,-0.000740419754903,-0.000847839728982,-0.000970844174915,-0.00111169408527,-0.00127297847704,-0.00145766198136,-0.00166913933758,-0.00191129779322,-0.00218858855707,-0.00250610861851,-0.0028696944373,-0.00328602922581,-0.00376276579574,-0.00430866722742,-0.0049337679474,-0.00564955817519,-0.00646919512938,-0.00740774487566,-0.008482459262,-0.00971309303158,-0.0111222669424,-0.0127358835683,-0.0145836034241,-0.0166993901673,-0.0191221348969,-0.0218963710263,-0.0250730928688,-0.0287106929844,-0.0328760355158};



          //altitudes from lunar mean radius 1737.4 km

  SpiceDouble Alts[1024] = {-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.73012149334,-0.73012149334,-0.73012149334,-0.73012149334,-0.73012149334,-0.72012680769,-0.72012680769,-0.72012680769,-0.714380443096,-0.714380443096,-0.714449107647,-0.714449107647,-0.714929640293,-0.718271076679,-0.718864440918,-0.72364461422,-0.726099133492,-0.727720797062,-0.730371415615,-0.732929110527,-0.723115205765,-0.718985319138,-0.730421125889,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.73012149334,-0.73012149334,-0.73012149334,-0.73012149334,-0.73012149334,-0.72012680769,-0.72012680769,-0.72012680769,-0.714380443096,-0.714380443096,-0.714449107647,-0.714449107647,-0.717620372772,-0.718120932579,-0.717998683453,-0.7199447155,-0.723495066166,-0.730910599232,-0.72618418932,-0.72581756115,-0.725074470043,-0.725822329521,-0.790489494801,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.73012149334,-0.73012149334,-0.73012149334,-0.73012149334,-0.73012149334,-0.73012149334,-0.72012680769,-0.716304600239,-0.716304600239,-0.715957939625,-0.715957939625,-0.715473532677,-0.714732289314,-0.714732289314,-0.719098925591,-0.716016888618,-0.713691413403,-0.713053226471,-0.717180490494,-0.714909911156,-0.726971328259,-0.725488364697,-0.725026488304,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.73012149334,-0.73012149334,-0.73012149334,-0.717242240906,-0.717242240906,-0.716304600239,-0.716304600239,-0.716304600239,-0.71305334568,-0.71305334568,-0.717064976692,-0.715915620327,-0.716104924679,-0.716416954994,-0.716416954994,-0.715326964855,-0.714339911938,-0.713883638382,-0.719497382641,-0.72226780653,-0.719751775265,-0.724036872387,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.717242240906,-0.717242240906,-0.717242240906,-0.717242240906,-0.717242240906,-0.717242240906,-0.716521263123,-0.716521263123,-0.716638207436,-0.716638207436,-0.716638207436,-0.716456472874,-0.716443538666,-0.716443538666,-0.713865935802,-0.719653725624,-0.715703368187,-0.717787921429,-0.719383716583,-0.725938558578,-0.71760648489,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.722521364689,-0.722521364689,-0.722521364689,-0.717242240906,-0.717242240906,-0.719521164894,-0.719521164894,-0.719521164894,-0.715231060982,-0.715231060982,-0.71707457304,-0.716763496399,-0.718959033489,-0.717772722244,-0.717772722244,-0.717345714569,-0.718113541603,-0.719312846661,-0.717840373516,-0.723482370377,-0.721987843513,-0.720775961876,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.722521364689,-0.722521364689,-0.722521364689,-0.722521364689,-0.722521364689,-0.722521364689,-0.719153106213,-0.719521164894,-0.719521164894,-0.720948457718,-0.720948457718,-0.7223097682,-0.720236003399,-0.720236003399,-0.717047572136,-0.717816710472,-0.718984663486,-0.720891714096,-0.7182751894,-0.722472548485,-0.720764458179,-0.724670767784,-0.718264341354,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.722521364689,-0.722521364689,-0.722521364689,-0.722521364689,-0.722521364689,-0.719153106213,-0.719153106213,-0.719153106213,-0.71845728159,-0.71845728159,-0.719589710236,-0.719589710236,-0.719052612782,-0.719366192818,-0.721935033798,-0.718352138996,-0.718169152737,-0.718461334705,-0.720837235451,-0.720205008984,-0.722945988178,-0.716510474682,-0.719286262989,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.723654925823,-0.722521364689,-0.722521364689,-0.722521364689,-0.722521364689,-0.722521364689,-0.719153106213,-0.719153106213,-0.719153106213,-0.71845728159,-0.71845728159,-0.719589710236,-0.719589710236,-0.721557557583,-0.720439910889,-0.7202013731,-0.718226015568,-0.722136437893,-0.720345318317,-0.719036400318,-0.718846440315,-0.716140806675,-0.718886435032,-0.722832322121,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.720596194267,-0.720596194267,-0.720596194267,-0.720596194267,-0.720596194267,-0.719012916088,-0.719012916088,-0.719012916088,-0.720067918301,-0.720067918301,-0.721381366253,-0.721381366253,-0.726071178913,-0.725263416767,-0.721805155277,-0.719836711884,-0.715869486332,-0.718342363834,-0.719995319843,-0.717442333698,-0.71825414896,-0.71759146452,-0.716826677322,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.720596194267,-0.720596194267,-0.720596194267,-0.720596194267,-0.720596194267,-0.720596194267,-0.719012916088,-0.721644341946,-0.721644341946,-0.723568320274,-0.723568320274,-0.721955418587,-0.727910459042,-0.727910459042,-0.726643562317,-0.726311564445,-0.730561673641,-0.722113549709,-0.723727881908,-0.721273183823,-0.718544542789,-0.716426193714,-0.717926979065,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.720596194267,-0.720596194267,-0.720596194267,-0.720985233784,-0.720985233784,-0.721644341946,-0.721644341946,-0.721644341946,-0.726011395454,-0.726011395454,-0.72618252039,-0.727651298046,-0.728201031685,-0.726223230362,-0.726223230362,-0.724258184433,-0.719209015369,-0.720791757107,-0.718822002411,-0.716063082218,-0.719426989555,-0.71492254734,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.720985233784,-0.720985233784,-0.720985233784,-0.720985233784,-0.720985233784,-0.720985233784,-0.723076760769,-0.723076760769,-0.724818348885,-0.724818348885,-0.724818348885,-0.724435091019,-0.725177228451,-0.725177228451,-0.724160313606,-0.722471892834,-0.721042752266,-0.718745827675,-0.718447208405,-0.718376874924,-0.720678567886,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.719298064709,-0.719298064709,-0.719298064709,-0.720985233784,-0.720985233784,-0.722671508789,-0.722671508789,-0.722671508789,-0.725634634495,-0.725634634495,-0.726938307285,-0.726829171181,-0.72272336483,-0.724803626537,-0.724803626537,-0.72680670023,-0.723146378994,-0.722590327263,-0.717531323433,-0.715524375439,-0.718767762184,-0.71777009964,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.719298064709,-0.719298064709,-0.719298064709,-0.719298064709,-0.719298064709,-0.719298064709,-0.723770081997,-0.722671508789,-0.722671508789,-0.723599433899,-0.723599433899,-0.723654329777,-0.724576950073,-0.724576950073,-0.724284231663,-0.72555065155,-0.726314425468,-0.726395905018,-0.72451967001,-0.7179505229,-0.716151833534,-0.712656617165,-0.719221413136,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.719298064709,-0.719298064709,-0.719298064709,-0.719298064709,-0.719298064709,-0.723770081997,-0.723770081997,-0.723770081997,-0.722320199013,-0.722320199013,-0.721269607544,-0.721269607544,-0.727106630802,-0.725063025951,-0.722769796848,-0.7248082757,-0.728188693523,-0.728860318661,-0.727750241756,-0.724588811398,-0.718290150166,-0.714827537537,-0.71980714798,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.71919220686,-0.719298064709,-0.719298064709,-0.719298064709,-0.719298064709,-0.719298064709,-0.723770081997,-0.723770081997,-0.723770081997,-0.722320199013,-0.722320199013,-0.721269607544,-0.721269607544,-0.722577631474,-0.719708800316,-0.723362505436,-0.724613845348,-0.727321267128,-0.728477060795,-0.73030102253,-0.728192865849,-0.720155954361,-0.715999126434,-0.714836061001,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.718028664589,-0.718028664589,-0.718028664589,-0.718028664589,-0.718028664589,-0.724915385246,-0.724915385246,-0.724915385246,-0.717384815216,-0.717384815216,-0.722229480743,-0.722229480743,-0.719835519791,-0.719711661339,-0.723007321358,-0.722828865051,-0.725000023842,-0.731186926365,-0.727631270885,-0.728936493397,-0.723783969879,-0.720469355583,-0.725761413574,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.718028664589,-0.718028664589,-0.718028664589,-0.718028664589,-0.718028664589,-0.718028664589,-0.724915385246,-0.716834008694,-0.716834008694,-0.723405063152,-0.723405063152,-0.715004503727,-0.718415439129,-0.718415439129,-0.719777941704,-0.722244381905,-0.745058655739,-0.731962680817,-0.729427158833,-0.729896247387,-0.731828689575,-0.724826693535,-0.734626948833,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.718028664589,-0.718028664589,-0.718028664589,-0.718072354794,-0.718072354794,-0.716834008694,-0.716834008694,-0.716834008694,-0.722429692745,-0.722429692745,-0.713915228844,-0.720967650414,-0.722881615162,-0.725944459438,-0.725944459438,-0.729584276676,-0.73335313797,-0.734344244003,-0.733998835087,-0.72977489233,-0.744315564632,-0.770918130875,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.718072354794,-0.718072354794,-0.718072354794,-0.718072354794,-0.718072354794,-0.718072354794,-0.724771976471,-0.724771976471,-0.725002408028,-0.725002408028,-0.725002408028,-0.722218990326,-0.724696218967,-0.724696218967,-0.732136189938,-0.738628685474,-0.733216285706,-0.715158879757,-0.750563502312,-0.771677851677,-0.767779052258,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.720608770847,-0.720608770847,-0.720608770847,-0.718072354794,-0.718072354794,-0.721190094948,-0.721190094948,-0.721190094948,-0.724925100803,-0.724925100803,-0.723444342613,-0.721595168114,-0.724731385708,-0.73037481308,-0.73037481308,-0.732835292816,-0.737534761429,-0.73720061779,-0.74924737215,-0.787658810616,-0.788382589817,-0.785831987858,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.720608770847,-0.720608770847,-0.720608770847,-0.720608770847,-0.720608770847,-0.720608770847,-0.721467971802,-0.721190094948,-0.721190094948,-0.723655760288,-0.723655760288,-0.728094637394,-0.725802898407,-0.725802898407,-0.730545341969,-0.737409114838,-0.74717694521,-0.750578522682,-0.767625808716,-0.781298875809,-0.798165798187,-0.793278455734,-0.78863543272,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.717235088348,-0.720608770847,-0.720608770847,-0.720608770847,-0.720608770847,-0.720608770847,-0.721467971802,-0.721467971802,-0.721467971802,-0.721947669983,-0.721947669983,-0.733177304268,-0.733177304268,-0.730617702007,-0.739066779613,-0.751126825809,-0.74474298954,-0.745490729809,-0.745061516762,-0.772075772285,-0.735041499138,-0.745224237442,-0.77257168293,-0.794606924057,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719126522541,-0.719126522541,-0.719126522541,-0.719126522541,-0.719126522541,-0.721614181995,-0.721614181995,-0.721614181995,-0.726164340973,-0.726164340973,-0.73869407177,-0.73869407177,-0.737677931786,-0.742101788521,-0.749741196632,-0.751274764538,-0.749127566814,-0.745845019817,-0.722940206528,-0.897243320942,-1.09380793571,-1.03870213032,-0.77656686306,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719126522541,-0.719126522541,-0.719126522541,-0.719126522541,-0.719126522541,-0.721614181995,-0.721614181995,-0.721614181995,-0.726164340973,-0.726164340973,-0.73869407177,-0.73869407177,-0.740215063095,-0.751873612404,-0.760840892792,-0.755667805672,-0.750838518143,-0.744236528873,-0.750048339367,-0.888940095901,-0.960704445839,-0.927856326103,-0.7619830966,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719126522541,-0.719126522541,-0.719126522541,-0.719126522541,-0.719126522541,-0.719126522541,-0.721614181995,-0.724221527576,-0.724221527576,-0.72556501627,-0.72556501627,-0.730661094189,-0.741057217121,-0.741057217121,-0.752442777157,-0.766116082668,-0.755227446556,-0.766662418842,-0.761548876762,-0.769749164581,-0.749208331108,-0.838645398617,-0.904966950417,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719126522541,-0.719126522541,-0.719126522541,-0.718506574631,-0.718506574631,-0.724221527576,-0.724221527576,-0.724221527576,-0.723232924938,-0.723232924938,-0.728397607803,-0.727674841881,-0.737458407879,-0.734424114227,-0.734424114227,-0.717260479927,-0.755699694157,-0.778932094574,-0.787646949291,-0.79194009304,-0.859095394611,-0.856132209301,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.718506574631,-0.718506574631,-0.718506574631,-0.718506574631,-0.718506574631,-0.718506574631,-0.718760609627,-0.718760609627,-0.723305821419,-0.723305821419,-0.723305821419,-0.72538369894,-0.720516979694,-0.720516979694,-0.715488612652,-0.700640916824,-0.733388960361,-0.775557100773,-0.773238778114,-0.83878326416,-0.815860927105,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.717695891857,-0.717695891857,-0.717695891857,-0.718506574631,-0.718506574631,-0.716277837753,-0.716277837753,-0.716277837753,-0.719357728958,-0.719357728958,-0.721943378448,-0.723596274853,-0.718622207642,-0.716745436192,-0.716745436192,-0.710021555424,-0.705233454704,-0.715558648109,-0.7361728549,-0.77126199007,-0.789159953594,-0.794698655605,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.717695891857,-0.717695891857,-0.717695891857,-0.717695891857,-0.717695891857,-0.717695891857,-0.722022771835,-0.716277837753,-0.716277837753,-0.716399788857,-0.716399788857,-0.718072772026,-0.719125032425,-0.719125032425,-0.720728039742,-0.719613790512,-0.717113494873,-0.69402885437,-0.692016065121,-0.708469510078,-0.730239391327,-0.749190151691,-0.764064192772,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.719230175018,-0.717695891857,-0.717695891857,-0.717695891857,-0.717695891857,-0.717695891857,-0.722022771835,-0.722022771835,-0.722022771835,-0.719241499901,-0.719241499901,-0.715243577957,-0.715243577957,-0.717280089855,-0.718126237392,-0.716805875301,-0.723260343075,-0.728696644306,-0.731341123581,-0.724613189697,-0.709999084473,-0.696378707886,-0.703413009644,-0.731259286404};




  //eventually saved to files for reading in by python scripts
  double XYZ[numsc][numDates][3];
  double XYZpos[numsc][numDates][3];
  double jXYZ[numsc][numDates][3];

  double jNorms[numsc][numDates][3];

  double ras[numDates];
  double decs[numDates];


  double SolAng[numsc][numDates];
  double EarthAng[numsc][numDates];


// temp stuff used in loops

  SpiceDouble rectan[3];

  SpiceDouble j2000coord[3];

  SpiceDouble j2000Pos[3];


  SpiceDouble lat, lon;

  SpiceDouble lunarPos[3]; //in km
  SpiceDouble lt;

  SpiceDouble EarthfromMoonPos[3]; //in km

  SpiceDouble sunPos[3]; //in km
  SpiceDouble sunfromMoon[3];

  SpiceDouble range, ra, dec;

  SpiceDouble solar;
  SpiceDouble trgepc;
  SpiceDouble srfvec[3];
  SpiceDouble emissn;
  SpiceDouble phase;

//surface normal vars
  SpiceInt npts = 1;
  SpiceDouble srfpt[1][3];
  SpiceDouble normal[1][3];
  SpiceDouble normal1D[3];
  SpiceDouble normal1DJ2000[3];


  //eventually want allscpos = np.zeros((numsc, length, 3))

  int c = 0;

  for(int d1 = 1; d1 < 13; d1++){
    for(int d2 = 7; d2 < 29; d2 += 7) {

      sprintf(date,  "%d/%d/2025 12:00:0.0", d1, d2);
      str2et_c ( date , &et );
      //printf("%f \n", et);

      //calculate lunar position, ra dec, with earth centered coordinates,
      spkpos_c("MOON", et, "J2000", "NONE", "EARTH", lunarPos, &lt);

      //printf ("Moon in J2000 %11.6f , %11.6f , %11.6f \n", lunarPos[0], lunarPos[1], lunarPos[2]);

      //find ra dec of sun from moon
      spkpos_c("SUN", et, "J2000", "NONE", "EARTH", sunPos, &lt);
      vsub_c(sunPos, lunarPos, sunfromMoon);

      spkpos_c("EARTH", et, "J2000", "NONE", "MOON", EarthfromMoonPos, &lt);

      recrad_c(EarthfromMoonPos, &range, &ra, &dec);
      ra *= dpr_c();
      dec *= dpr_c();

      ras[c] = ra;
      decs[c] = dec;

      //printf("RA Dec Range from moon to sun %11.6f , %11.6f , %11.6f \n", ra, dec, range);

      //calc rot matrix once
      SpiceDouble rotate[3][3];
      pxform_c("MOON_ME", "J2000", et, rotate);


      //get points in new frame

      for(int i=0; i < numsc; i++) {

        lat = Lats[i]*rpd_c();
        lon = Longs[i]*rpd_c();


        //get MOON_ME coords of lat lon alt
        latrec_c(1737.4 + Alts[i], lon, lat, rectan);

        //convert J2000 coordsys, axes aligned
        mxv_c(rotate, rectan, j2000coord);

        //add to pos of moon to get true j2000 xyz
        vadd_c(lunarPos, j2000coord, j2000Pos);

        for(int j=0; j<3; j++){
          //coord is moon centered
          XYZ[i][c][j] = j2000coord[j];
          //pos is earth centered
          XYZpos[i][c][j] = j2000Pos[j];
          //this is in MOON ME moon centered
          jXYZ[i][c][j] = rectan[j];

        }


        //find angle between sun and zenith to see if it's visible
        // solar angle
                  // between the surface normal vector at `spoint' and the
                  // spoint-sun vector.  Units are radians.  The range
                  // of `solar' is [0, pi]
        ilumin_c ( "Ellipsoid", "MOON", et, "MOON_ME", "CN+S", "EARTH", rectan, &trgepc, srfvec, &phase, &solar, &emissn );

        //rad to degrees
        solar *= dpr_c();

        SolAng[i][c] = solar;

        emissn *= dpr_c();

        EarthAng[i][c] = emissn;

        //printf("Angle between the surface normal vector at spoint/rectan and the spoint-sun vector  %11.6f degrees \n", solar);

        //get normal vector to surface, do in J2000

        for(int j=0; j<3; j++){
          srfpt[0][j] = rectan[j];
        }


        srfnrm_c( "Ellipsoid", "MOON", et, "MOON_ME", npts, srfpt, normal);

        //convert J2000 coordsys, axes aligned


        for(int j=0; j<3; j++){
          //normal vector in moon me points
          normal1D[j] = normal[0][j];

        }

        mxv_c(rotate, normal1D, normal1DJ2000);

        for(int j=0; j<3; j++){

          jNorms[i][c][j] = normal1DJ2000[j];


        }

      }



      c+=1;
      //printf("%d \n", c);

    }
  }

  //save to files
  FILE *file;


//xyz in earth centered j2000 vals
  file = fopen("eqXYZ_EarthCentered.txt", "w");
  for(int i = 0; i< numsc; i++) {
    for(int j = 0; j < numDates; j++){
      for(int k=0; k < 3; k++){
        fprintf(file, "%11.6f \n", XYZpos[i][j][k]);
      }
    }
  }
  fclose(file);

  //ras of earth from moon
  file = fopen("RAs.txt", "w");
  for(int i = 0; i< numDates; i++) {
    fprintf(file, "%11.6f \n", ras[i]);
  }
  fclose(file);

  //decs of earth from moon
  file = fopen("Decs.txt", "w");
  for(int i = 0; i< numDates; i++) {
    fprintf(file, "%11.6f \n", decs[i]);
  }
  fclose(file);
  //
  //
  file = fopen("eqSolAngs.txt", "w");
  for(int i = 0; i< numsc; i++) {
    for(int j = 0; j < numDates; j++){
      fprintf(file, "%11.6f \n", SolAng[i][j]);
    }
  }
  fclose(file);

  file = fopen("eqEarthAngs.txt", "w");
  for(int i = 0; i< numsc; i++) {
    for(int j = 0; j < numDates; j++){
      fprintf(file, "%11.6f \n", EarthAng[i][j]);
    }
  }
  fclose(file);


  // optional values to save
  
  // file = fopen("eqXYZ_MoonCentered.txt", "w");
  // for(int i = 0; i< numsc; i++) {
  //   for(int j = 0; j < numDates; j++){
  //     for(int k=0; k < 3; k++){
  //       fprintf(file, "%11.6f \n", XYZ[i][j][k]);
  //     }
  //   }
  // }
  // fclose(file);
  //
  //
  // file = fopen("eqNorms.txt", "w");
  // for(int i = 0; i< numsc; i++) {
  //   for(int j = 0; j < numDates; j++){
  //     for(int k=0; k < 3; k++){
  //       fprintf(file, "%11.6f \n", jNorms[i][j][k]);
  //     }
  //   }
  // }
  // fclose(file);
  //
  //
  // file = fopen("eqME_XYZ.txt", "w");
  // for(int i = 0; i< numsc; i++) {
  //   for(int j = 0; j < numDates; j++){
  //     for(int k=0; k < 3; k++){
  //       fprintf(file, "%11.6f \n", jXYZ[i][j][k]);
  //     }
  //   }
  // }
  // fclose(file);



}
