clear all
close all
clc
%% This code was developed for the data analysis of silver carp fish mucus 
% Concentrations of 400 mg/mL, 200 mg/mL, and 100 mg/mL.
% Phase Angle v. Angular Frequency  ; Loss, Storage Modulus v. Angular Frequency Data. 
% Code written by Samantha Racan 
%Last revised: 2/20/20 

%% 
std=xlsread('freq_sweep_fm.xlsx');
std1=xlsread('std_fm_delta_freq.xlsx');
%400
fm_400_1=xlsread('fm_1_400_061919.xls','Frequency sweep - 2');
fm_400_2=xlsread('fm_2_400_061919.xls','Frequency sweep - 2');
fm_400_3=xlsread('fm_3_400_061919.xls','Frequency sweep - 2');
fm_400_4=xlsread('fm_3_400_061919-2.xls','Frequency sweep - 2');
fm_400_5=xlsread('fm_4_400_061919.xls','Frequency sweep - 2');
fm_400_6=xlsread('fm_5_400_061919.xls','Frequency sweep - 2');
fm_400_7=xlsread('fm_5_400_061919-1.xls','Frequency sweep - 2');
%200
fm_200_1=xlsread('fm_1n_200_062019.xls','Frequency sweep - 2');
fm_200_2=xlsread('fm_2_200_062019.xls','Frequency sweep - 2');
fm_200_3=xlsread('fm_2_200_062019-1.xls','Frequency sweep - 2');
fm_200_4=xlsread('fm_3_200_062019.xls','Frequency sweep - 2');
fm_200_5=xlsread('fm_4_200_062019.xls','Frequency sweep - 2');
%100
fm_100_1=xlsread('fm_2_100_062019.xls','Frequency sweep - 2');
fm_100_2=xlsread('fm_3_100_062019.xls','Frequency sweep - 2');
fm_100_3=xlsread('fm_4_100_062019.xls','Frequency sweep - 2');
%% 
%400 both trials 3 and 4 are outliers. Just like the amplitude sweep. 

fm400_stor=[fm_400_5(:,1) fm_400_6(:,1) fm_400_7(:,1)];
fm400_meanstor= mean(fm400_stor,2);
fm400_loss=[fm_400_5(:,2) fm_400_6(:,2) fm_400_7(:,2)];
fm400_meanloss=mean(fm400_loss,2);
fm400_angfreq= [fm_400_5(:,4) fm_400_6(:,4) fm_400_7(:,4)];
fm400_meanangfreq=mean(fm400_angfreq,2);

delta_400=[atan(fm_400_5(:,3)) atan(fm_400_6(:,3)) atan(fm_400_7(:,3))];
mean_delta_400= mean(delta_400,2) *(180/pi);

figure(1)
a=loglog(fm400_meanangfreq,fm400_meanstor, 'mo', 'linewidth',3)
hold on
errorbar(fm400_meanangfreq,fm400_meanstor,fm400_meanstor+std(:,4),fm400_meanstor-std(:,4), 'mx', 'linewidth',1)
b=loglog(fm400_meanangfreq,fm400_meanloss, 'bo','linewidth',3)
errorbar(fm400_meanangfreq,fm400_meanloss,fm400_meanloss+std(:,8),fm400_meanloss-std(:,8), 'bx', 'linewidth',1)
grid minor 
xlabel('$Angular\ Frequency,\ \omega\ [rad/s]$','interpreter','latex','FontSize',16)
ylabel('$G^{,}$, $G^{"}$ [Pa]', 'interpreter','latex','FontSize',16)
axis([10^.5 10^2.25 10^-3 10^1])
legend([a b],{'Storage Modulus', 'Loss Modulus'},'location','southwest')
set(gca,'TickLabelInterpreter','none');
set(gca,'fontweight','bold','fontsize',18);

figure(2) 
semilogx(fm_400_5(:,4),atan(fm_400_5(:,3))*(180/pi), 'r^', 'linewidth',3)
hold on
semilogx(fm_400_6(:,4),atan(fm_400_7(:,3))*(180/pi), 'rv', 'linewidth',3)
semilogx(fm_400_7(:,4),atan(fm_400_7(:,3))*(180/pi), 'r<', 'linewidth',3)
xlabel('$Angular\ Frequency,\ \omega\ [rad/s]$','interpreter','latex','FontSize',16)
ylabel('$Phase\ Angle,\ \delta\ [^{o}]$','interpreter','latex','FontSize',16)
axis([10^.5 10^2.25 0 90])
% title('$400\ mg/mL$','interpreter','latex','FontSize',16)
legend('Test 1','Test 2','Test 3','location','northeast','fontsize',10)
text(10^.56,80,'$\bf \delta=tan^{-1}(\frac{G^{\prime\prime}}{G^{\prime}})$','interpreter','latex','fontsize',24)
set(gca,'TickLabelInterpreter','none');
set(gca,'fontweight','bold','fontsize',18);
grid minor 
%%
% 200 mg/mL- looks good (except for trial 2, as per flow sweep)
fm200_stor=[fm_200_1(:,1) fm_200_4(:,1) fm_200_5(:,1)];
fm200_meanstor= mean(fm200_stor,2);
fm200_loss=[fm_200_1(:,2) fm_200_4(:,2) fm_200_5(:,2)];
fm200_meanloss=mean(fm200_loss,2);
fm200_angfreq= [fm_200_1(:,4) fm_200_4(:,4) fm_200_5(:,4)];
fm200_meanangfreq=mean(fm200_angfreq,2);

delta_200=[atan(fm_200_1(:,3)) atan(fm_200_4(:,3)) atan(fm_200_5(:,3))];
mean_delta_200=mean(delta_200,2)*(180/pi) ;

figure(3)
c=loglog(fm200_meanangfreq,fm200_meanstor, 'mo','linewidth',2)
hold on
errorbar(fm200_meanangfreq,fm200_meanstor,fm200_meanstor+std(:,12),fm200_meanstor-std(:,12), 'mx', 'linewidth',1)
d=loglog(fm200_meanangfreq,fm200_meanloss, 'bo','linewidth',2)
errorbar(fm200_meanangfreq,fm200_meanloss,fm200_meanloss+std(:,16),fm200_meanloss-std(:,16), 'bx', 'linewidth',1) 
grid minor 
%title('$200\ mg/mL$','interpreter','latex','FontSize',16)
xlabel('$Angular\ Frequency,\ \omega\ [rad/s]$','interpreter','latex','FontSize',16)
ylabel('$G^{,}$, $G^{"}$ [Pa]', 'interpreter','latex','FontSize',16)
axis([10^.5 10^2.25 10^-3 10^1])
legend([c d],{'Storage Modulus', 'Loss Modulus'},'location','southwest')
set(gca,'TickLabelInterpreter','none');
set(gca,'fontweight','bold','fontsize',18);

figure(4)
semilogx(fm_200_2(:,4), atan(fm_200_1(:,3))*(180/pi), 'r^', 'linewidth',3)
hold on
semilogx(fm_200_4(:,4), atan(fm_200_4(:,3))*(180/pi), 'rv', 'linewidth',3)
semilogx(fm_200_5(:,4), atan(fm_200_5(:,3))*(180/pi), 'r<', 'linewidth',3)
ylabel('$Phase\ Angle,\ \delta\ [^{o}]$','interpreter','latex','FontSize',16)
xlabel('$Angular\ Frequency,\ \omega\ [rad/s]$','interpreter','latex','FontSize',16)
% title('$200\ mg/mL$','interpreter','latex','FontSize',16)
legend('Test 1','Test 2','Test 3','location','northeast','fontsize',10)
axis([10^.5 10^2.25 0 90])
text(10^.56,80,'$\bf \delta=tan^{-1}(\frac{G^{\prime\prime}}{G^{\prime}})$','interpreter','latex','fontsize',24)
set(gca,'TickLabelInterpreter','none');
set(gca,'fontweight','bold','fontsize',18);
grid minor 


%%
%100 mg/mL- looks good. 
fm100_stor=[fm_100_1(:,1) fm_100_2(:,1) fm_100_3(:,1)];
fm100_meanstor= mean(fm100_stor,2);
fm100_loss=[fm_100_1(:,2) fm_100_2(:,2) fm_100_3(:,2)];
fm100_meanloss= mean(fm100_loss,2);
fm100_angfreq=[fm_100_1(:,4) fm_100_2(:,4) fm_100_3(:,4)];
fm100_meanangfreq=mean(fm100_angfreq,2);

delta_100=[atan(fm_100_1(:,3)) atan(fm_100_2(:,3)) atan(fm_100_3(:,3))];
mean_delta_100=mean(delta_100,2)*(180/pi) ;

figure(5)
e=loglog(fm100_meanangfreq,fm100_meanstor, 'mo', 'linewidth',1)
hold on
errorbar(fm100_meanangfreq,fm100_meanstor,fm100_meanstor+std(:,20),fm100_meanstor-std(:,20), 'mx', 'linewidth',1)
f=loglog(fm100_meanangfreq,fm100_meanloss, 'bo', 'linewidth',1)
errorbar(fm100_meanangfreq,fm100_meanloss,fm100_meanloss+std(:,24),fm100_meanloss-std(:,24),'bx', 'linewidth',1)
grid minor 
legend([e f],'Storage Modulus','Loss Modulus', 'location','northeast')
ylabel('$G^{,}$, $G^{"}$ [Pa]', 'interpreter','latex','FontSize',16)
xlabel('$Angular\ Frequency,\ \omega\ [rad/s]$','interpreter','latex','FontSize',16)
axis([10^.5 10^2.25 10^-3 10^1])
set(gca,'TickLabelInterpreter','none');
set(gca,'fontweight','bold','fontsize',18);


figure(6)
semilogx(fm_100_1(:,4),atan(fm_100_1(:,3))*(180/pi), 'r^', 'linewidth',3)
hold on
semilogx(fm_100_2(:,4),atan(fm_100_2(:,3))*(180/pi), 'rv', 'linewidth',3)
semilogx(fm_100_3(:,4),atan(fm_100_3(:,3))*(180/pi), 'r<', 'linewidth',3)
axis([10^.5 10^2.25 0 90])
xlabel('$Angular\ Frequency,\ \omega\ [rad/s]$','interpreter','latex','FontSize',16)
ylabel('$Phase\ Angle,\ \delta\ [^{o}]$','interpreter','latex','FontSize',16)
legend('Test 1','Test 2','Test 3','location','northeast','fontsize',10)
text(10^.56,80,'$\bf \delta=tan^{-1}(\frac{G^{\prime\prime}}{G^{\prime}})$','interpreter','latex','fontsize',24)
grid minor
set(gca,'TickLabelInterpreter','none');
set(gca,'fontweight','bold','fontsize',18);




