clear all 
close all 
clc

%% This code was developed for the data analysis of silver carp fish mucus 
% Concentrations of 400 mg/mL, 200 mg/mL, and 100 mg/mL.
% Phase Angle v. Oscillation Stress  ; Loss, Storage Modulus v. Oscillation Stress Data 
% Code written by Samantha Racan 
%Last revised: 2/20/20 

%% fm_400_1=xlsread('fm_1_400_061919.xls','Flow sweep - 3');
std=xlsread('amp_Sweep_fm.xlsx');
std1=xlsread('fm_delta_std.xlsx');
%400
fm_400_1=xlsread('fm_1_400_061919.xls','Amplitude sweep - 1');
fm_400_2=xlsread('fm_2_400_061919.xls','Amplitude sweep - 1');
fm_400_3=xlsread('fm_3_400_061919.xls','Amplitude sweep - 1');
fm_400_4=xlsread('fm_3_400_061919-2.xls','Amplitude sweep - 1');
fm_400_5=xlsread('fm_4_400_061919-3.xls','Amplitude sweep - 1');
fm_400_6=xlsread('fm_5_400_061919-6.xls','Amplitude sweep - 1');
fm_400_7=xlsread('fm_5_400_061919-1-3.xls','Amplitude sweep - 1');
%200
fm_200_1=xlsread('fm_1n_200_062019-3.xls','Amplitude sweep - 1');
fm_200_2=xlsread('fm_2_200_062019.xls','Amplitude sweep - 1');
fm_200_3=xlsread('fm_2_200_062019-1.xls','Amplitude sweep - 1');
fm_200_4=xlsread('fm_3_200_062019-3.xls','Amplitude sweep - 1');
fm_200_5=xlsread('fm_4_200_062019-3.xls','Amplitude sweep - 1');
%100
fm_100_1=xlsread('fm_2_100_062019-3.xls','Amplitude sweep - 1');
fm_100_2=xlsread('fm_3_100_062019-3.xls','Amplitude sweep - 1');
fm_100_3=xlsread('fm_4_100_062019-3.xls','Amplitude sweep - 1');
%% 

%400 
%For Loss Modulus, trials 3 and 4 were outliers. They were not averaged in totals for loss or storage 
%modulus. Should be looked into to take out of flow sweep experiments.
fm400_stor=[fm_400_5(:,1) fm_400_6(:,1) fm_400_7(:,1)];
fm400_meanstor= mean(fm400_stor,2);
fm400_loss=[fm_400_5(:,2) fm_400_6(:,2) fm_400_7(:,2)];
fm400_meanloss=mean(fm400_loss,2);
fm400_osci= [fm_400_5(:,10) fm_400_6(:,10) fm_400_7(:,10)];
fm400_meanosci=mean(fm400_osci,2);
fm400_strain=[fm_400_5(:,9)*(180/pi) fm_400_6(:,9)*(180/pi) fm_400_7(:,9)*(180/pi)];
fm400_meanstrain=mean(fm400_strain,2);

delta_400=[atan(fm_400_5(:,3)) atan(fm_400_6(:,3)) atan(fm_400_7(:,3))];
mean_delta_400= mean(delta_400,2) *(180/pi);

figure(1)
a=loglog(fm400_meanosci,fm400_meanstor, 'mo','linewidth',2)
hold on 
errorbar(fm400_meanosci,fm400_meanstor,fm400_meanstor-(std(1:21,4)/3^.5),fm400_meanstor+(std(1:21,4)/3^.5),'mx','linewidth',1)
b=loglog(fm400_meanosci,fm400_meanloss,'bo','linewidth',2)
errorbar(fm400_meanosci,fm400_meanloss,fm400_meanloss-(std(1:21,8)/3^.5),fm400_meanloss+(std(1:21,8)/3^.5),'bx','linewidth',1)
ylabel('$G^{,}$, $G^{"}$ [Pa]', 'interpreter','latex','FontSize',16)
xlabel('$Oscillation\ Stress,\ \bar{\sigma}\ [Pa]$','interpreter','latex','FontSize',16)
axis([10^-1.25 10^0 10^-5 10^0])
legend([a b],{'Storage Modulus', 'Loss Modulus'},'location','southwest','fontsize',10)
set(gca,'TickLabelInterpreter','none');
set(gca,'fontweight','bold','fontsize',18);
grid minor

figure(2)
a=loglog(fm400_meanstrain,fm400_meanstor, 'mo','linewidth',2)
hold on 
errorbar(fm400_meanstrain,fm400_meanstor,fm400_meanstor-std(1:21,4),fm400_meanstor+std(1:21,4),'mx','linewidth',1)
b=loglog(fm400_meanstrain,fm400_meanloss,'bo','linewidth',2)
errorbar(fm400_meanstrain,fm400_meanloss,fm400_meanstor-std(1:21,8),fm400_meanstor+std(1:21,8),'bx','linewidth',1)
ylabel('$G^{,}$, $G^{"}$ [Pa]', 'interpreter','latex','FontSize',16)
xlabel('$Oscillation\ Strain,\ \bar{\gamma}$','interpreter','latex','FontSize',16)
axis([10^0 10^2 10^-5 10^0])
legend([a b],{'Storage Modulus', 'Loss Modulus'},'location','southwest','fontsize',10)
set(gca,'TickLabelInterpreter','none');
set(gca,'fontweight','bold','fontsize',18);
grid minor

figure (3)
c=semilogx(fm_400_5(:,10),atan(fm_400_5(:,3))*(180/pi), 'r^','linewidth',3)
hold on
d=semilogx(fm_400_6(:,10),atan(fm_400_6(:,3))*(180/pi),'rv','linewidth',3)
e=semilogx(fm_400_7(:,10),atan(fm_400_7(:,3))*(180/pi),'r<','linewidth',3)
xlabel('$Oscillation\ Stress,\ \bar{\sigma}\ [Pa]$','interpreter','latex','FontSize',16)
legend([c d e],{'Test 1','Test 2','Test 3'},'location','southeast','fontsize',10)
ylabel('$Phase\ Angle,\ \delta\ [^{o}]$','interpreter','latex','FontSize',16)
axis([10^-1.25 10^0 0 90])
text(10^-1.16,80,'$\bf \delta=tan^{-1}(\frac{G^{\prime\prime}}{G^{\prime}})$','interpreter','latex','fontsize',24)
grid minor
set(gca,'TickLabelInterpreter','none');
set(gca,'fontweight','bold','fontsize',18);

%% 
% %200
% all trials looked good- trial 2 is still out because it was an outleir in
% the flow experiments.
fm200_stor=[fm_200_1(:,1) fm_200_4(:,1) fm_200_5(:,1)];
fm200_meanstor= mean(fm200_stor,2);
fm200_loss=[fm_200_1(:,2) fm_200_4(:,2) fm_200_5(:,2)];
fm200_meanloss=mean(fm200_loss,2);
fm200_osci= [fm_200_1(:,10) fm_200_4(:,10) fm_200_5(:,10)];
fm200_meanosci=mean(fm200_osci,2);
fm200_strain=[fm_200_1(:,9)*(180/pi) fm_200_4(:,9)*(180/pi) fm_200_5(:,9)*(180/pi)];
fm200_meanstrain=mean(fm200_strain,2);


delta_200=[atan(fm_200_1(:,3)) atan(fm_200_4(:,3)) atan(fm_200_5(:,3))];
mean_delta_200=mean(delta_200,2)*(180/pi) ;

figure(4)
f=loglog(fm200_meanosci, fm200_meanstor, 'mo','linewidth',2)
hold on
errorbar(fm200_meanosci, fm200_meanstor,fm200_meanstor+(std(1:21,12)),fm200_meanstor+(std(1:21,12)),'mx','linewidth',1)
g=loglog(fm200_meanosci, fm200_meanloss, 'bo','linewidth',2)
errorbar(fm200_meanosci, fm200_meanloss,fm200_meanloss+(std(1:21,16)),fm200_meanloss+(std(1:21,16)),'bx','linewidth',1)
axis([10^-2 10^0 10^-5 10^0])
ylabel('$G^{,}$, $G^{"}$ [Pa]', 'interpreter','latex','FontSize',16)
xlabel('$Oscillation\ Stress,\ \bar{\sigma}$','interpreter','latex','FontSize',16)
% title('$200\ mg/mL$','interpreter','latex','FontSize',16)
legend([f g],{'Storage Modulus','Loss Modulus'}, 'location','southwest','fontsize',10)
grid minor 
set(gca,'TickLabelInterpreter','none');
set(gca,'fontweight','bold','fontsize',18);

figure(5)
h=semilogx(fm_200_1(:,10),atan(fm_200_1(:,3))*(180/pi), 'r^','linewidth',2)
hold on
i=semilogx(fm_200_4(:,10),atan(fm_200_4(:,3))*(180/pi),'rv','linewidth',2)
j=semilogx(fm_200_5(:,10),atan(fm_200_5(:,3))*(180/pi),'r<','linewidth',2)
xlabel('$Oscillation\ Stress,\ \bar{\sigma}\ [Pa]$','interpreter','latex','FontSize',16)
% title('$200\ mg/mL$','interpreter','latex','FontSize',16)
legend([h i j],{'Test 1','Test 2','Test 3'},'location','southeast','fontsize',10)
ylabel('$Phase\ Angle,\ \delta\ [^{o}]$','interpreter','latex','FontSize',16)
axis([10^-2 10^0 0 90])
text(10^-1.86,80,'$\bf \delta=tan^{-1}(\frac{G^{\prime\prime}}{G^{\prime}})$','interpreter','latex','fontsize',24)
grid minor
set(gca,'TickLabelInterpreter','none');
set(gca,'fontweight','bold','fontsize',18);

%%
%100
%All trials are alright.
fm100_stor=[fm_100_1(:,1) fm_100_2(:,1) fm_100_3(:,1)];
fm100_meanstor= mean(fm100_stor,2);
fm100_loss=[fm_100_1(:,2) fm_100_2(:,2) fm_100_3(:,2)];
fm100_meanloss= mean(fm100_loss,2);
fm100_osci=[fm_100_1(:,10) fm_100_2(:,10) fm_100_3(:,10)];
fm100_meanosci=mean(fm100_osci,2);
fm100_strain=[fm_100_1(:,9)*(180/pi) fm_100_2(:,9)*(180/pi) fm_100_3(:,9)*(180/pi)];
fm100_meanstrain=mean(fm100_strain,2);

delta_100=[atan(fm_100_1(:,3)) atan(fm_100_2(:,3)) atan(fm_100_3(:,3))];
mean_delta_100=mean(delta_100,2)*(180/pi) ;

figure(6)
k=loglog(fm100_meanosci, fm100_meanstor, 'mo','linewidth',2)
hold on
errorbar(fm100_meanosci,fm100_meanstor,fm100_meanstor-(std(1:21,20)),fm100_meanstor+(std(1:21,20)),'mx','linewidth',1)
l=loglog(fm100_meanosci, fm100_meanloss, 'bo','linewidth',2)
errorbar(fm100_meanosci, fm100_meanloss,fm100_meanloss-(std(1:21,24)),fm100_meanloss+(std(1:21,24)),'bx','linewidth',1)
grid minor 
axis([10^-2 10^0 10^-5 10^0])
ylabel('$G^{,}$, $G^{"}$ [Pa]', 'interpreter','latex','FontSize',16)
xlabel('$Oscillation\ Stress,\ \bar{\sigma}$','interpreter','latex','FontSize',16)
legend([k l],{'Storage Modulus','Loss Modulus'}, 'location','southwest', 'fontsize',10)
set(gca,'TickLabelInterpreter','none');
set(gca,'fontweight','bold','fontsize',18);

figure(7)
m=semilogx(fm_100_1(:,10),atan(fm_100_1(:,3))*(180/pi), 'r^', 'linewidth',2)
hold on
n=semilogx(fm_100_2(:,10),atan(fm_100_2(:,3))*(180/pi),'rv','linewidth',2)
o=semilogx(fm_100_3(:,10),atan(fm_100_3(:,3))*(180/pi),'r<','linewidth',2)
xlabel('$Oscillation\ Stress,\ \bar{\sigma}\ [Pa]$','interpreter','latex','FontSize',16)
% title('$100\ mg/mL$','interpreter','latex','FontSize',16)
legend([m n o],{'Test 1','Test 2','Test 3'},'location','southeast','fontsize',10)
ylabel('$Phase\ Angle,\ \delta\ [^{o}]$','interpreter','latex','FontSize',16)
axis([10^-2 10^0 0 90])
text(10^-1.86,80,'$\bf \delta=tan^{-1}(\frac{G^{\prime\prime}}{G^{\prime}})$','interpreter','latex','fontsize',24)
grid minor
set(gca,'TickLabelInterpreter','none');
set(gca,'fontweight','bold','fontsize',18);

