clear all
close all
clc
%% This code was developed for the data analysis of silver carp fish mucus 
% Concentrations of 400 mg/mL, 200 mg/mL, and 100 mg/mL.
% Apparent Viscosity v. Shear Rate ; Stress v. Shear Rate Data. 
% Code written by Samantha Racan 
%Last revised: 2/20/20 

%% First Batch of Concentrations 
%%% Read the data Files
std=xlsread('std_fm.xlsx');
%400 mg/mL
fm_400_1=xlsread('fm_1_400_061919.xls','Flow sweep - 3');
fm_400_2=xlsread('fm_2_400_061919.xls','Flow sweep - 3');
fm_400_3=xlsread('fm_3_400_061919.xls','Flow sweep - 3');
fm_400_4=xlsread('fm_3_400_061919-2.xls','Flow sweep - 3');
fm_400_5=xlsread('fm_4_400_061919.xls','Flow sweep - 3');
fm_400_6=xlsread('fm_5_400_061919.xls','Flow sweep - 3');
fm_400_7=xlsread('fm_5_400_061919-1.xls','Flow sweep - 3');
%200 mg/mL
fm_200_1=xlsread('fm_1n_200_062019.xls','Flow sweep - 3');
fm_200_2=xlsread('fm_2_200_062019.xls','Flow sweep - 3');
fm_200_3=xlsread('fm_2_200_062019-1.xls','Flow sweep - 3');
fm_200_4=xlsread('fm_3_200_062019.xls','Flow sweep - 3');
fm_200_5=xlsread('fm_4_200_062019.xls','Flow sweep - 3');
%100 mg/mL
fm_100_1=xlsread('fm_2_100_062019.xls','Flow sweep - 3');
fm_100_2=xlsread('fm_3_100_062019.xls','Flow sweep - 3');
fm_100_3=xlsread('fm_4_100_062019.xls','Flow sweep - 3');
%% Average the Data

% 400 mg/mL -not including 1 and 2 trials; outlier data
fm400= [fm_400_3 fm_400_4 fm_400_5 fm_400_6 fm_400_7];
fm400_shear=[fm_400_3(:,2) fm_400_4(:,2) fm_400_5(:,2) fm_400_6(:,2) fm_400_7(:,2)];
fm400_meanshear= mean(fm400_shear,2);
fm400_stress= [fm_400_3(:,1) fm_400_4(:,1) fm_400_5(:,1) fm_400_6(:,1) fm_400_7(:,1)];
fm400_meanstress= mean(fm400_stress,2);
fm400_viscosity= [fm_400_3(:,3) fm_400_4(:,3) fm_400_5(:,3) fm_400_6(:,3) fm_400_7(:,3)];
fm400_meanviscosity=mean(fm400_viscosity,2);
 
%200 mg/mL- not including data 2 because outlier
fm200= [fm_200_1 fm_200_3 fm_200_4 fm_200_5];
fm200_shear=[fm_200_1(:,2) fm_200_3(:,2) fm_200_4(:,2) fm_200_5(:,2)];
fm200_meanshear= mean(fm200_shear,2);
fm200_stress=[fm_200_1(:,1) fm_200_3(:,1) fm_400_4(:,1) fm_400_5(:,1)];
fm200_meanstress= mean(fm200_stress,2);
fm200_viscosity= [fm_200_1(:,3) fm_200_3(:,3) fm_200_4(:,3) fm_200_5(:,3)];
fm200_meanviscosity=mean(fm200_viscosity,2);
 
%100 mg/mL
fm100= [fm_100_1 fm_100_2 fm_100_3];
fm100_shear=[fm_100_1(:,2) fm_100_2(:,2) fm_100_3(:,2)];
fm100_meanshear= mean(fm100_shear,2);
fm100_stress= [fm_100_1(:,1) fm_100_2(:,1) fm_100_3(:,1)];
fm100_meanstress= mean(fm100_stress,2);
fm100_viscosity= [fm_100_1(:,3) fm_100_2(:,3) fm_100_3(:,3)];
fm100_meanviscosity=mean(fm100_viscosity,2);    


%% Plot the data 
figure(1)
a=loglog(fm400_meanshear,fm400_meanviscosity, 'kd-', 'linewidth',2)
hold on 
errorbar(fm400_meanshear,fm400_meanviscosity,(std(:,6)),'kx','linewidth',1)
b=loglog(fm200_meanshear,fm200_meanviscosity, 'bs-', 'linewidth',2)
errorbar(fm200_meanshear,fm200_meanviscosity,(std(:,11)),'bx','linewidth', 1) 
c=loglog(fm100_meanshear,fm100_meanviscosity, 'ro-', 'linewidth',2)
errorbar(fm100_meanshear,fm100_meanviscosity,(std(:,15)), 'rx','linewidth', 1)
hold off
grid minor
axis([10^0 10^4 10^-4 10^0])
xlabel('$Shear\ Rate\ [1/s]$', 'interpreter','latex', 'FontSize',16)
ylabel('$Apparent Viscosity\ [Pa.s]$', 'interpreter', 'latex', 'FontSize', 16)
legend([a b c],{'400 mg/ml','200 mg/ml','100 mg/ml'},'location', 'best')
set(gca,'TickLabelInterpreter','none');
set(gca,'fontweight','bold','fontsize',18);

figure(2)
d=loglog(fm400_meanshear,fm400_meanstress, 'kd-', 'linewidth',2)
hold on 
errorbar(fm400_meanshear,fm400_meanstress,std(:,21),'kx','linewidth',1)
e=loglog(fm200_meanshear,fm200_meanstress, 'bs-', 'linewidth',2)
errorbar(fm200_meanshear,fm200_meanstress,std(:,26),'bx','linewidth', 1) 
f=loglog(fm100_meanshear,fm100_meanstress, 'ro-', 'linewidth',2)
errorbar(fm100_meanshear,fm100_meanstress,std(:,30), 'rx','linewidth', 1)%fm100_meanviscosity+(std(:,15)/3^.5),fm100_meanviscosity-(std(:,15)/3^.5),
hold off
grid minor
%axis([10^0 10^4 10^-4 10^0])
xlabel('$Shear\ Rate\ [1/s]$', 'interpreter','latex', 'FontSize',16)
ylabel('$Stress\ [Pa]$', 'interpreter', 'latex', 'FontSize', 16)
legend([d e f],{'400 mg/ml','200 mg/ml','100 mg/ml'},'location', 'best')
set(gca,'TickLabelInterpreter','none');
set(gca,'fontweight','bold','fontsize',18);

